/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.notification;

import android.content.Context;
import android.content.Intent;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

public class NotificationDeleteMessageHandler
extends AbstractMessageHandler<MessageV3> {
    private Context mContext;

    public NotificationDeleteMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
        this.mContext = context;
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        return (MessageV3)intent.getParcelableExtra("pushMessage");
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if (message == null) {
            return;
        }
        if (this.appLogicListener() == null) {
            this.appLogicListener().onNotificationDeleted(this.context(), MzPushMessage.fromMessageV3(message));
        }
        this.clearNotifyOption(message);
        this.cleanAdNotificationInfo(this.mContext, message);
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start NotificationDeleteMessageHandler match");
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "notification_delete".equals(this.getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return 128;
    }

    @Override
    protected void onBeforeEvent(MessageV3 message) {
        UxIPUtils.onDeletePushMessageEvent(this.context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp());
    }
}

