/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.notification;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.PushMessageProxy;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.Advertisement.AdNotification;
import com.meizu.cloud.pushsdk.handler.impl.model.ControlMessage;
import com.meizu.cloud.pushsdk.handler.impl.model.WithDrawMessage;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

public class WithDrawMessageHandler
extends AbstractMessageHandler<WithDrawMessage> {
    public WithDrawMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    public boolean messageMatch(Intent intent) {
        ControlMessage controlMessage;
        DebugLogger.i("AbstractMessageHandler", "start WithDrawMessageHandler match");
        String control = intent.getStringExtra("mz_push_control_message");
        int pushType = 0;
        if (!TextUtils.isEmpty((CharSequence)control) && (controlMessage = ControlMessage.parse(control)).getControl() != null) {
            pushType = controlMessage.getControl().getPushType();
        }
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "4".equals(String.valueOf(pushType));
    }

    @Override
    public int getProcessorType() {
        return 262144;
    }

    @Override
    protected WithDrawMessage getMessage(Intent intent) {
        String control = intent.getStringExtra("mz_push_control_message");
        String seqId = intent.getStringExtra("extra_app_push_seq_Id");
        String deviceId = intent.getStringExtra("statistics_imei_key");
        String pushMessage = intent.getStringExtra("pushMessage");
        String revokePackageName = this.getPushServiceDefaultPackageName(intent);
        return new WithDrawMessage(pushMessage, revokePackageName, control, deviceId, seqId);
    }

    @Override
    protected void unsafeSend(WithDrawMessage message, PushNotification pushNotification) {
        NotificationManager notificationManager = (NotificationManager)this.context().getSystemService("notification");
        if (notificationManager != null) {
            DebugLogger.e("AbstractMessageHandler", "start cancel notification id " + message.getNotifyId());
            notificationManager.cancel(message.getNotifyId());
            AdNotification adNotification = PushMessageProxy.with(this.context()).getAdNotification();
            if (adNotification != null) {
                adNotification.cleanAdNotification(message.getNotifyId());
            }
        }
    }

    @Override
    protected void onBeforeEvent(WithDrawMessage message) {
        UxIPUtils.onReceivePushMessageEvent(this.context(), message.getRevokePackageName(), message.getControlMessage().getStatics().getDeviceId(), message.getControlMessage().getStatics().getTaskId(), message.getControlMessage().getStatics().getSeqId(), message.getControlMessage().getStatics().getTime());
    }
}

