/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.platform;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.StatusSerialize;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;

public class PushSwitchStatusHandler
extends AbstractMessageHandler<PushSwitchStatus> {
    private static final String CODE_OK = "200";

    public PushSwitchStatusHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected PushSwitchStatus getMessage(Intent intent) {
        String messageValue = intent.getStringExtra("messageValue");
        PushSwitchStatus pushSwitchStatus = !TextUtils.isEmpty((CharSequence)messageValue) ? StatusSerialize.stringToPushSwitchStatus(messageValue) : (PushSwitchStatus)intent.getSerializableExtra("extra_app_push_switch_status");
        if (CODE_OK.equals(pushSwitchStatus.getCode())) {
            String packageName = this.getPushServiceDefaultPackageName(intent);
            DebugLogger.e("AbstractMessageHandler", "PushSwitchStatusHandler update local " + packageName + " switch status " + pushSwitchStatus);
            PushPreferencesUtils.setNotificationMessageSwitchStatus(this.context(), packageName, pushSwitchStatus.isSwitchNotificationMessage());
            PushPreferencesUtils.setThroughMessageSwitchStatus(this.context(), packageName, pushSwitchStatus.isSwitchThroughMessage());
        }
        return pushSwitchStatus;
    }

    @Override
    protected void unsafeSend(PushSwitchStatus message, PushNotification pushNotification) {
        if (this.appLogicListener() != null && message != null) {
            this.appLogicListener().onPushStatus(this.context(), message);
        }
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start PushSwitchStatusHandler match");
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "push_status".equals(this.getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return 256;
    }
}

