/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.platform;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.thread.IOExecutorUtils;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.StatusSerialize;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;

public class RegisterStatusHandler
extends AbstractMessageHandler<RegisterStatus> {
    public RegisterStatusHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected RegisterStatus getMessage(Intent intent) {
        String messageValue = intent.getStringExtra("messageValue");
        RegisterStatus registerStatus = !TextUtils.isEmpty((CharSequence)messageValue) ? StatusSerialize.stringToRegisterStatus(messageValue) : (RegisterStatus)intent.getSerializableExtra("extra_app_push_register_status");
        if (!TextUtils.isEmpty((CharSequence)registerStatus.getPushId())) {
            PushPreferencesUtils.putPushId(this.context(), registerStatus.getPushId(), this.context().getPackageName());
            PushPreferencesUtils.putPushIdExpireTime(this.context(), (int)(System.currentTimeMillis() / 1000L + (long)registerStatus.getExpireTime()), this.context().getPackageName());
        }
        return registerStatus;
    }

    @Override
    protected void unsafeSend(RegisterStatus message, PushNotification pushNotification) {
        if (this.appLogicListener() != null && message != null) {
            this.appLogicListener().onRegisterStatus(this.context(), message);
        }
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start RegisterStatusHandler match");
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "register_status".equals(this.getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return 512;
    }

    @Override
    protected void onAfterEvent(RegisterStatus registerStatus) {
        IOExecutorUtils.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                RegisterStatusHandler.this.advanceRequestPublicKey();
            }
        });
    }

    private void advanceRequestPublicKey() {
        String packageName = MzSystemUtils.getMzPushServicePackageName(this.context());
        if (!PushPreferencesUtils.getFirstRequestPublicKey(this.context(), packageName)) {
            return;
        }
        PushPreferencesUtils.putFirstRequestPublicKey(this.context(), packageName, false);
        String publicKey = PushPreferencesUtils.getPublicKeyByPackageName(this.context(), packageName);
        if (!TextUtils.isEmpty((CharSequence)publicKey)) {
            return;
        }
        publicKey = this.networkRequestPublicKey();
        if (!TextUtils.isEmpty((CharSequence)publicKey)) {
            PushPreferencesUtils.putPublicKeyByPackageName(this.context(), packageName, publicKey);
        }
    }
}

