/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.schedule;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSetting;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSettingEx;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BrightNotification {
    private static final String TAG = "BrightNotification";
    private Context mContext;
    private List<Intent> mBrightNotificationIntentList;
    private BroadcastReceiver mUserPresentBroadCastReceiver;

    public BrightNotification(Context context) {
        this.mContext = context.getApplicationContext();
        this.registerUserPresentReceiver();
    }

    public void addBrightNotificationIntent(Intent intent, String packageName) {
        if (intent == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return;
        }
        if (this.mBrightNotificationIntentList == null) {
            this.mBrightNotificationIntentList = new ArrayList<Intent>();
        } else {
            for (Intent brightIntent : this.mBrightNotificationIntentList) {
                MessageV3 message = (MessageV3)brightIntent.getParcelableExtra("extra_app_push_bright_notification_message");
                if (message == null || message.getUploadDataPackageName() == null || !packageName.equalsIgnoreCase(message.getUploadDataPackageName())) continue;
                this.mBrightNotificationIntentList.remove(brightIntent);
                break;
            }
        }
        this.mBrightNotificationIntentList.add(intent);
        DebugLogger.d(TAG, "add bright notification intent, intent list: " + this.mBrightNotificationIntentList);
    }

    private void sendBrightNotification() {
        if (this.mBrightNotificationIntentList == null || this.mBrightNotificationIntentList.size() == 0) {
            return;
        }
        int listSize = this.mBrightNotificationIntentList.size();
        int index = 0;
        Iterator<Intent> it = this.mBrightNotificationIntentList.iterator();
        while (it.hasNext()) {
            Intent brightIntent = it.next();
            try {
                if (index != listSize - 1) {
                    this.cleanSound(brightIntent);
                }
                DebugLogger.d(TAG, "start bright notification service " + brightIntent);
                this.mContext.startService(brightIntent);
                it.remove();
                ++index;
            }
            catch (Exception e) {
                DebugLogger.e(TAG, "send bright notification error " + e.getMessage());
            }
        }
    }

    private void cleanSound(Intent intent) {
        MessageV3 message = (MessageV3)intent.getParcelableExtra("extra_app_push_bright_notification_message");
        if (message == null) {
            return;
        }
        AdvanceSetting advanceSetting = message.getAdvanceSetting();
        AdvanceSettingEx advanceSettingEx = message.getAdvanceSettingEx();
        if (advanceSetting == null || advanceSettingEx == null) {
            return;
        }
        advanceSettingEx.setSoundTitle(null);
        advanceSetting.getNotifyType().setSound(false);
        advanceSetting.getNotifyType().setLights(false);
        advanceSetting.getNotifyType().setVibrate(false);
    }

    private void registerUserPresentReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_PRESENT");
        if (this.mUserPresentBroadCastReceiver == null) {
            this.mUserPresentBroadCastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (!"android.intent.action.USER_PRESENT".equalsIgnoreCase(intent.getAction())) {
                        return;
                    }
                    BrightNotification.this.sendBrightNotification();
                }
            };
        }
        this.mContext.registerReceiver(this.mUserPresentBroadCastReceiver, filter);
    }

    private void unRegisterUserPresentReceiver(Context context) {
        if (this.mUserPresentBroadCastReceiver != null) {
            this.mContext.unregisterReceiver(this.mUserPresentBroadCastReceiver);
        }
    }
}

