/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.schedule;

import android.content.Context;
import android.content.Intent;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.impl.MessageV3Handler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

public class ScheduleNotificationHandler
extends MessageV3Handler {
    public ScheduleNotificationHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        return (MessageV3)intent.getParcelableExtra("extra_app_push_schedule_notification_message");
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if (pushNotification != null) {
            pushNotification.show(message);
            this.sendArrivedMessage(message);
        }
    }

    @Override
    protected int scheduleNotificationStatus(MessageV3 message) {
        return 0;
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start ScheduleNotificationHandler match");
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "schedule_notification".equals(this.getIntentMethod(intent));
    }

    @Override
    protected void onBeforeEvent(MessageV3 message) {
        DebugLogger.e("AbstractMessageHandler", "ScheduleNotificationHandler don't repeat upload receiver push event");
    }

    @Override
    protected void onAfterEvent(MessageV3 message) {
        UxIPUtils.onShowPushMessageEvent(this.context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp(), message.getDelayedReportMillis());
    }

    @Override
    public int getProcessorType() {
        return 8192;
    }
}

