/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.networking.common;

import android.graphics.Bitmap;
import android.text.TextUtils;
import android.widget.ImageView;
import com.meizu.cloud.pushsdk.networking.common.ANLog;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.common.Priority;
import com.meizu.cloud.pushsdk.networking.common.RequestBuilder;
import com.meizu.cloud.pushsdk.networking.common.ResponseType;
import com.meizu.cloud.pushsdk.networking.core.Core;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.networking.http.Call;
import com.meizu.cloud.pushsdk.networking.http.FormBody;
import com.meizu.cloud.pushsdk.networking.http.Headers;
import com.meizu.cloud.pushsdk.networking.http.HttpUrl;
import com.meizu.cloud.pushsdk.networking.http.MediaType;
import com.meizu.cloud.pushsdk.networking.http.MultipartBody;
import com.meizu.cloud.pushsdk.networking.http.RequestBody;
import com.meizu.cloud.pushsdk.networking.http.Response;
import com.meizu.cloud.pushsdk.networking.interfaces.AnalyticsListener;
import com.meizu.cloud.pushsdk.networking.interfaces.BitmapRequestListener;
import com.meizu.cloud.pushsdk.networking.interfaces.DownloadListener;
import com.meizu.cloud.pushsdk.networking.interfaces.DownloadProgressListener;
import com.meizu.cloud.pushsdk.networking.interfaces.JSONArrayRequestListener;
import com.meizu.cloud.pushsdk.networking.interfaces.JSONObjectRequestListener;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndBitmapRequestListener;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndJSONArrayRequestListener;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndJSONObjectRequestListener;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndParsedRequestListener;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndStringRequestListener;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseListener;
import com.meizu.cloud.pushsdk.networking.interfaces.ParsedRequestListener;
import com.meizu.cloud.pushsdk.networking.interfaces.StringRequestListener;
import com.meizu.cloud.pushsdk.networking.interfaces.UploadProgressListener;
import com.meizu.cloud.pushsdk.networking.internal.ANRequestQueue;
import com.meizu.cloud.pushsdk.networking.internal.SynchronousCall;
import com.meizu.cloud.pushsdk.networking.okio.Okio;
import com.meizu.cloud.pushsdk.networking.utils.Utils;
import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class ANRequest<T extends ANRequest> {
    private static final String TAG = ANRequest.class.getSimpleName();
    private final int mMethod;
    private final Priority mPriority;
    private final int mRequestType;
    private final String mUrl;
    private int sequenceNumber;
    private final Object mTag;
    private ResponseType mResponseType;
    private final HashMap<String, String> mHeadersMap;
    private HashMap<String, String> mBodyParameterMap = new HashMap();
    private HashMap<String, String> mUrlEncodedFormBodyParameterMap = new HashMap();
    private HashMap<String, String> mMultiPartParameterMap = new HashMap();
    private final HashMap<String, String> mQueryParameterMap;
    private final HashMap<String, String> mPathParameterMap;
    private HashMap<String, File> mMultiPartFileMap = new HashMap();
    private String mDirPath;
    private String mFileName;
    private JSONObject mJsonObject = null;
    private JSONArray mJsonArray = null;
    private String mStringBody = null;
    private byte[] mByte = null;
    private File mFile = null;
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse("application/json; charset=utf-8");
    private static final MediaType MEDIA_TYPE_MARKDOWN = MediaType.parse("text/x-markdown; charset=utf-8");
    private MediaType customMediaType = null;
    private static final Object DECODE_LOCK = new Object();
    private Future future;
    private Call call;
    private int mProgress;
    private boolean isCancelled;
    private boolean isDelivered;
    private int mPercentageThresholdForCancelling = 0;
    private JSONArrayRequestListener mJsonArrayRequestListener;
    private JSONObjectRequestListener mJsonObjectRequestListener;
    private StringRequestListener mStringRequestListener;
    private OkHttpResponseListener mOkHttpResponseListener;
    private BitmapRequestListener mBitmapRequestListener;
    private ParsedRequestListener mParsedRequestListener;
    private OkHttpResponseAndJSONObjectRequestListener mOkHttpResponseAndJsonObjectRequestListener;
    private OkHttpResponseAndJSONArrayRequestListener mOkHttpResponseAndJsonArrayRequestListener;
    private OkHttpResponseAndStringRequestListener mOkHttpResponseAndStringRequestListener;
    private OkHttpResponseAndBitmapRequestListener mOkHttpResponseAndBitmapRequestListener;
    private OkHttpResponseAndParsedRequestListener mOkHttpResponseAndParsedRequestListener;
    private DownloadProgressListener mDownloadProgressListener;
    private UploadProgressListener mUploadProgressListener;
    private DownloadListener mDownloadListener;
    private AnalyticsListener mAnalyticsListener;
    private Bitmap.Config mDecodeConfig;
    private int mMaxWidth;
    private int mMaxHeight;
    private ImageView.ScaleType mScaleType;
    private final Executor mExecutor;
    private String mUserAgent;
    private Type mType = null;

    public ANRequest(GetRequestBuilder builder) {
        this.mRequestType = 0;
        this.mMethod = builder.mMethod;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mHeadersMap = builder.mHeadersMap;
        this.mDecodeConfig = builder.mDecodeConfig;
        this.mMaxHeight = builder.mMaxHeight;
        this.mMaxWidth = builder.mMaxWidth;
        this.mScaleType = builder.mScaleType;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mExecutor = builder.mExecutor;
        this.mUserAgent = builder.mUserAgent;
    }

    public ANRequest(PostRequestBuilder builder) {
        this.mRequestType = 0;
        this.mMethod = builder.mMethod;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mHeadersMap = builder.mHeadersMap;
        this.mBodyParameterMap = builder.mBodyParameterMap;
        this.mUrlEncodedFormBodyParameterMap = builder.mUrlEncodedFormBodyParameterMap;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mJsonObject = builder.mJsonObject;
        this.mJsonArray = builder.mJsonArray;
        this.mStringBody = builder.mStringBody;
        this.mFile = builder.mFile;
        this.mByte = builder.mByte;
        this.mExecutor = builder.mExecutor;
        this.mUserAgent = builder.mUserAgent;
        if (builder.mCustomContentType != null) {
            this.customMediaType = MediaType.parse(builder.mCustomContentType);
        }
    }

    public ANRequest(DownloadBuilder builder) {
        this.mRequestType = 1;
        this.mMethod = 0;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mDirPath = builder.mDirPath;
        this.mFileName = builder.mFileName;
        this.mHeadersMap = builder.mHeadersMap;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mPercentageThresholdForCancelling = builder.mPercentageThresholdForCancelling;
        this.mExecutor = builder.mExecutor;
        this.mUserAgent = builder.mUserAgent;
    }

    public ANRequest(MultiPartBuilder builder) {
        this.mRequestType = 2;
        this.mMethod = 1;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mHeadersMap = builder.mHeadersMap;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mMultiPartParameterMap = builder.mMultiPartParameterMap;
        this.mMultiPartFileMap = builder.mMultiPartFileMap;
        this.mPercentageThresholdForCancelling = builder.mPercentageThresholdForCancelling;
        this.mExecutor = builder.mExecutor;
        this.mUserAgent = builder.mUserAgent;
        if (builder.mCustomContentType != null) {
            this.customMediaType = MediaType.parse(builder.mCustomContentType);
        }
    }

    public void getAsJsonObject(JSONObjectRequestListener requestListener) {
        this.mResponseType = ResponseType.JSON_OBJECT;
        this.mJsonObjectRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsJsonArray(JSONArrayRequestListener requestListener) {
        this.mResponseType = ResponseType.JSON_ARRAY;
        this.mJsonArrayRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsString(StringRequestListener requestListener) {
        this.mResponseType = ResponseType.STRING;
        this.mStringRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponse(OkHttpResponseListener requestListener) {
        this.mResponseType = ResponseType.OK_HTTP_RESPONSE;
        this.mOkHttpResponseListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsBitmap(BitmapRequestListener requestListener) {
        this.mResponseType = ResponseType.BITMAP;
        this.mBitmapRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndJsonObject(OkHttpResponseAndJSONObjectRequestListener requestListener) {
        this.mResponseType = ResponseType.JSON_OBJECT;
        this.mOkHttpResponseAndJsonObjectRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndJsonArray(OkHttpResponseAndJSONArrayRequestListener requestListener) {
        this.mResponseType = ResponseType.JSON_ARRAY;
        this.mOkHttpResponseAndJsonArrayRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndString(OkHttpResponseAndStringRequestListener requestListener) {
        this.mResponseType = ResponseType.STRING;
        this.mOkHttpResponseAndStringRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndBitmap(OkHttpResponseAndBitmapRequestListener requestListener) {
        this.mResponseType = ResponseType.BITMAP;
        this.mOkHttpResponseAndBitmapRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void startDownload(DownloadListener downloadListener) {
        this.mDownloadListener = downloadListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void prefetch() {
        this.mResponseType = ResponseType.PREFETCH;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public ANResponse executeForJsonObject() {
        this.mResponseType = ResponseType.JSON_OBJECT;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForJsonArray() {
        this.mResponseType = ResponseType.JSON_ARRAY;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForString() {
        this.mResponseType = ResponseType.STRING;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForOkHttpResponse() {
        this.mResponseType = ResponseType.OK_HTTP_RESPONSE;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForBitmap() {
        this.mResponseType = ResponseType.BITMAP;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForDownload() {
        return SynchronousCall.execute(this);
    }

    public T setDownloadProgressListener(DownloadProgressListener downloadProgressListener) {
        this.mDownloadProgressListener = downloadProgressListener;
        return (T)this;
    }

    public T setUploadProgressListener(UploadProgressListener uploadProgressListener) {
        this.mUploadProgressListener = uploadProgressListener;
        return (T)this;
    }

    public T setAnalyticsListener(AnalyticsListener analyticsListener) {
        this.mAnalyticsListener = analyticsListener;
        return (T)this;
    }

    public AnalyticsListener getAnalyticsListener() {
        return this.mAnalyticsListener;
    }

    public int getMethod() {
        return this.mMethod;
    }

    public Priority getPriority() {
        return this.mPriority;
    }

    public String getUrl() {
        String tempUrl = this.mUrl;
        for (Map.Entry<String, String> entry : this.mPathParameterMap.entrySet()) {
            tempUrl = tempUrl.replace("{" + entry.getKey() + "}", String.valueOf(entry.getValue()));
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse(tempUrl).newBuilder();
        for (Map.Entry<String, String> entry : this.mQueryParameterMap.entrySet()) {
            urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
        }
        return urlBuilder.build().toString();
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setProgress(int progress) {
        this.mProgress = progress;
    }

    public void setResponseAs(ResponseType responseType) {
        this.mResponseType = responseType;
    }

    public ResponseType getResponseAs() {
        return this.mResponseType;
    }

    public Object getTag() {
        return this.mTag;
    }

    public int getRequestType() {
        return this.mRequestType;
    }

    public void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public String getUserAgent() {
        return this.mUserAgent;
    }

    public Type getType() {
        return this.mType;
    }

    public void setType(Type type) {
        this.mType = type;
    }

    public DownloadProgressListener getDownloadProgressListener() {
        return new DownloadProgressListener(){

            @Override
            public void onProgress(long bytesDownloaded, long totalBytes) {
                if (ANRequest.this.mDownloadProgressListener != null && !ANRequest.this.isCancelled) {
                    ANRequest.this.mDownloadProgressListener.onProgress(bytesDownloaded, totalBytes);
                }
            }
        };
    }

    public void updateDownloadCompletion() {
        this.isDelivered = true;
        if (this.mDownloadListener != null) {
            if (!this.isCancelled) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mDownloadListener != null) {
                                ANRequest.this.mDownloadListener.onDownloadComplete();
                            }
                            ANLog.d("Delivering success : " + this.toString());
                            ANRequest.this.finish();
                        }
                    });
                } else {
                    Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mDownloadListener != null) {
                                ANRequest.this.mDownloadListener.onDownloadComplete();
                            }
                            ANLog.d("Delivering success : " + this.toString());
                            ANRequest.this.finish();
                        }
                    });
                }
            } else {
                this.deliverError(new ANError());
                this.finish();
            }
        } else {
            ANLog.d("Prefetch done : " + this.toString());
            this.finish();
        }
    }

    public UploadProgressListener getUploadProgressListener() {
        return new UploadProgressListener(){

            @Override
            public void onProgress(long bytesUploaded, long totalBytes) {
                ANRequest.this.mProgress = (int)(bytesUploaded * 100L / totalBytes);
                if (ANRequest.this.mUploadProgressListener != null && !ANRequest.this.isCancelled) {
                    ANRequest.this.mUploadProgressListener.onProgress(bytesUploaded, totalBytes);
                }
            }
        };
    }

    public String getDirPath() {
        return this.mDirPath;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void cancel(boolean forceCancel) {
        try {
            if (forceCancel || this.mPercentageThresholdForCancelling == 0 || this.mProgress < this.mPercentageThresholdForCancelling) {
                ANLog.d("cancelling request : " + this.toString());
                this.isCancelled = true;
                if (this.call != null) {
                    this.call.cancel();
                }
                if (this.future != null) {
                    this.future.cancel(true);
                }
                if (!this.isDelivered) {
                    this.deliverError(new ANError());
                }
            } else {
                ANLog.d("not cancelling request : " + this.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isCanceled() {
        return this.isCancelled;
    }

    public Call getCall() {
        return this.call;
    }

    public void setCall(Call call) {
        this.call = call;
    }

    public Future getFuture() {
        return this.future;
    }

    public void setFuture(Future future) {
        this.future = future;
    }

    public void destroy() {
        this.mJsonArrayRequestListener = null;
        this.mStringRequestListener = null;
        this.mBitmapRequestListener = null;
        this.mParsedRequestListener = null;
        this.mDownloadProgressListener = null;
        this.mUploadProgressListener = null;
        this.mDownloadListener = null;
        this.mAnalyticsListener = null;
    }

    public void finish() {
        this.destroy();
        ANRequestQueue.getInstance().finish(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ANResponse parseResponse(Response response) {
        switch (this.mResponseType) {
            case JSON_ARRAY: {
                try {
                    JSONArray json = new JSONArray(Okio.buffer(response.body().source()).readUtf8());
                    return ANResponse.success(json);
                }
                catch (Exception e) {
                    return ANResponse.failed(Utils.getErrorForParse(new ANError(e)));
                }
            }
            case JSON_OBJECT: {
                try {
                    JSONObject json = new JSONObject(Okio.buffer(response.body().source()).readUtf8());
                    return ANResponse.success(json);
                }
                catch (Exception e) {
                    return ANResponse.failed(Utils.getErrorForParse(new ANError(e)));
                }
            }
            case STRING: {
                try {
                    return ANResponse.success(Okio.buffer(response.body().source()).readUtf8());
                }
                catch (Exception e) {
                    return ANResponse.failed(Utils.getErrorForParse(new ANError(e)));
                }
            }
            case BITMAP: {
                Object object = DECODE_LOCK;
                synchronized (object) {
                    try {
                        return Utils.decodeBitmap(response, this.mMaxWidth, this.mMaxHeight, this.mDecodeConfig, this.mScaleType);
                    }
                    catch (Exception e) {
                        return ANResponse.failed(Utils.getErrorForParse(new ANError(e)));
                    }
                }
            }
            case PREFETCH: {
                return ANResponse.success("prefetch");
            }
        }
        return null;
    }

    public ANError parseNetworkError(ANError anError) {
        try {
            if (anError.getResponse() != null && anError.getResponse().body() != null && anError.getResponse().body().source() != null) {
                anError.setErrorBody(Okio.buffer(anError.getResponse().body().source()).readUtf8());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return anError;
    }

    public synchronized void deliverError(ANError anError) {
        try {
            if (!this.isDelivered) {
                if (this.isCancelled) {
                    anError.setCancellationMessageInError();
                    anError.setErrorCode(0);
                }
                this.deliverErrorResponse(anError);
                ANLog.d("Delivering anError : " + this.toString());
            }
            this.isDelivered = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deliverResponse(final ANResponse response) {
        try {
            this.isDelivered = true;
            if (!this.isCancelled) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ANRequest.this.deliverSuccessResponse(response);
                        }
                    });
                } else {
                    Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                        @Override
                        public void run() {
                            ANRequest.this.deliverSuccessResponse(response);
                        }
                    });
                }
                ANLog.d("Delivering success : " + this.toString());
            } else {
                ANError anError = new ANError();
                anError.setCancellationMessageInError();
                anError.setErrorCode(0);
                this.deliverErrorResponse(anError);
                this.finish();
                ANLog.d("Delivering cancelled : " + this.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deliverSuccessResponse(ANResponse response) {
        if (this.mJsonObjectRequestListener != null) {
            this.mJsonObjectRequestListener.onResponse((JSONObject)response.getResult());
        } else if (this.mJsonArrayRequestListener != null) {
            this.mJsonArrayRequestListener.onResponse((JSONArray)response.getResult());
        } else if (this.mStringRequestListener != null) {
            this.mStringRequestListener.onResponse((String)response.getResult());
        } else if (this.mBitmapRequestListener != null) {
            this.mBitmapRequestListener.onResponse((Bitmap)response.getResult());
        } else if (this.mParsedRequestListener != null) {
            this.mParsedRequestListener.onResponse(response.getResult());
        } else if (this.mOkHttpResponseAndJsonObjectRequestListener != null) {
            this.mOkHttpResponseAndJsonObjectRequestListener.onResponse(response.getOkHttpResponse(), (JSONObject)response.getResult());
        } else if (this.mOkHttpResponseAndJsonArrayRequestListener != null) {
            this.mOkHttpResponseAndJsonArrayRequestListener.onResponse(response.getOkHttpResponse(), (JSONArray)response.getResult());
        } else if (this.mOkHttpResponseAndStringRequestListener != null) {
            this.mOkHttpResponseAndStringRequestListener.onResponse(response.getOkHttpResponse(), (String)response.getResult());
        } else if (this.mOkHttpResponseAndBitmapRequestListener != null) {
            this.mOkHttpResponseAndBitmapRequestListener.onResponse(response.getOkHttpResponse(), (Bitmap)response.getResult());
        } else if (this.mOkHttpResponseAndParsedRequestListener != null) {
            this.mOkHttpResponseAndParsedRequestListener.onResponse(response.getOkHttpResponse(), response.getResult());
        }
        this.finish();
    }

    private void deliverErrorResponse(ANError anError) {
        if (this.mJsonObjectRequestListener != null) {
            this.mJsonObjectRequestListener.onError(anError);
        } else if (this.mJsonArrayRequestListener != null) {
            this.mJsonArrayRequestListener.onError(anError);
        } else if (this.mStringRequestListener != null) {
            this.mStringRequestListener.onError(anError);
        } else if (this.mBitmapRequestListener != null) {
            this.mBitmapRequestListener.onError(anError);
        } else if (this.mParsedRequestListener != null) {
            this.mParsedRequestListener.onError(anError);
        } else if (this.mOkHttpResponseAndJsonObjectRequestListener != null) {
            this.mOkHttpResponseAndJsonObjectRequestListener.onError(anError);
        } else if (this.mOkHttpResponseAndJsonArrayRequestListener != null) {
            this.mOkHttpResponseAndJsonArrayRequestListener.onError(anError);
        } else if (this.mOkHttpResponseAndStringRequestListener != null) {
            this.mOkHttpResponseAndStringRequestListener.onError(anError);
        } else if (this.mOkHttpResponseAndBitmapRequestListener != null) {
            this.mOkHttpResponseAndBitmapRequestListener.onError(anError);
        } else if (this.mOkHttpResponseAndParsedRequestListener != null) {
            this.mOkHttpResponseAndParsedRequestListener.onError(anError);
        } else if (this.mDownloadListener != null) {
            this.mDownloadListener.onError(anError);
        }
    }

    public void deliverOkHttpResponse(final Response response) {
        try {
            this.isDelivered = true;
            if (!this.isCancelled) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mOkHttpResponseListener != null) {
                                ANRequest.this.mOkHttpResponseListener.onResponse(response);
                            }
                            ANRequest.this.finish();
                        }
                    });
                } else {
                    Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mOkHttpResponseListener != null) {
                                ANRequest.this.mOkHttpResponseListener.onResponse(response);
                            }
                            ANRequest.this.finish();
                        }
                    });
                }
                ANLog.d("Delivering success : " + this.toString());
            } else {
                ANError anError = new ANError();
                anError.setCancellationMessageInError();
                anError.setErrorCode(0);
                if (this.mOkHttpResponseListener != null) {
                    this.mOkHttpResponseListener.onError(anError);
                }
                this.finish();
                ANLog.d("Delivering cancelled : " + this.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RequestBody getRequestBody() {
        if (this.mJsonObject != null) {
            if (this.customMediaType != null) {
                return RequestBody.create(this.customMediaType, this.mJsonObject.toString());
            }
            return RequestBody.create(JSON_MEDIA_TYPE, this.mJsonObject.toString());
        }
        if (this.mJsonArray != null) {
            if (this.customMediaType != null) {
                return RequestBody.create(this.customMediaType, this.mJsonArray.toString());
            }
            return RequestBody.create(JSON_MEDIA_TYPE, this.mJsonArray.toString());
        }
        if (this.mStringBody != null) {
            if (this.customMediaType != null) {
                return RequestBody.create(this.customMediaType, this.mStringBody);
            }
            return RequestBody.create(MEDIA_TYPE_MARKDOWN, this.mStringBody);
        }
        if (this.mFile != null) {
            if (this.customMediaType != null) {
                return RequestBody.create(this.customMediaType, this.mFile);
            }
            return RequestBody.create(MEDIA_TYPE_MARKDOWN, this.mFile);
        }
        if (this.mByte != null) {
            if (this.customMediaType != null) {
                return RequestBody.create(this.customMediaType, this.mByte);
            }
            return RequestBody.create(MEDIA_TYPE_MARKDOWN, this.mByte);
        }
        FormBody.Builder builder = new FormBody.Builder();
        try {
            for (Map.Entry<String, String> entry : this.mBodyParameterMap.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getKey()) || TextUtils.isEmpty((CharSequence)entry.getValue())) continue;
                builder.add(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.mUrlEncodedFormBodyParameterMap.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getKey()) || TextUtils.isEmpty((CharSequence)entry.getValue())) continue;
                builder.addEncoded(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public RequestBody getMultiPartRequestBody() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        try {
            for (Map.Entry<String, String> entry : this.mMultiPartParameterMap.entrySet()) {
                builder.addPart(Headers.of("Content-Disposition", "form-data; name=\"" + entry.getKey() + "\""), RequestBody.create(null, entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : this.mMultiPartFileMap.entrySet()) {
                if (entry.getValue() == null) continue;
                String fileName = ((File)entry.getValue()).getName();
                RequestBody fileBody = RequestBody.create(MediaType.parse(Utils.getMimeType(fileName)), (File)entry.getValue());
                builder.addPart(Headers.of("Content-Disposition", "form-data; name=\"" + entry.getKey() + "\"; filename=\"" + fileName + "\""), fileBody);
                if (this.customMediaType == null) continue;
                builder.setType(this.customMediaType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public Headers getHeaders() {
        Headers.Builder builder = new Headers.Builder();
        try {
            for (Map.Entry<String, String> entry : this.mHeadersMap.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return "ANRequest{sequenceNumber='" + this.sequenceNumber + ", mMethod=" + this.mMethod + ", mPriority=" + (Object)((Object)this.mPriority) + ", mRequestType=" + this.mRequestType + ", mUrl=" + this.mUrl + '}';
    }

    public static class MultiPartBuilder<T extends MultiPartBuilder>
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private final String mUrl;
        private Object mTag;
        private final HashMap<String, String> mHeadersMap = new HashMap();
        private final HashMap<String, String> mMultiPartParameterMap = new HashMap();
        private final HashMap<String, String> mQueryParameterMap = new HashMap();
        private final HashMap<String, String> mPathParameterMap = new HashMap();
        private final HashMap<String, File> mMultiPartFileMap = new HashMap();
        private int mPercentageThresholdForCancelling = 0;
        private Executor mExecutor;
        private String mUserAgent;
        private String mCustomContentType;

        public MultiPartBuilder(String url) {
            this.mUrl = url;
        }

        public T setPriority(Priority priority) {
            this.mPriority = priority;
            return (T)this;
        }

        public T setTag(Object tag) {
            this.mTag = tag;
            return (T)this;
        }

        public T addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return (T)this;
        }

        public T addQueryParameter(HashMap<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                for (Map.Entry<String, String> entry : queryParameterMap.entrySet()) {
                    this.mQueryParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(HashMap<String, String> headerMap) {
            if (headerMap != null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    this.mHeadersMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T doNotCacheResponse() {
            return (T)this;
        }

        public T getResponseOnlyIfCached() {
            return (T)this;
        }

        public T getResponseOnlyFromNetwork() {
            return (T)this;
        }

        public T setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            return (T)this;
        }

        public T setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            return (T)this;
        }

        public T setExecutor(Executor executor) {
            this.mExecutor = executor;
            return (T)this;
        }

        public T setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return (T)this;
        }

        public T addMultipartParameter(String key, String value) {
            this.mMultiPartParameterMap.put(key, value);
            return (T)this;
        }

        public T addMultipartParameter(HashMap<String, String> multiPartParameterMap) {
            if (multiPartParameterMap != null) {
                for (Map.Entry<String, String> entry : multiPartParameterMap.entrySet()) {
                    this.mMultiPartParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T addMultipartFile(String key, File file) {
            this.mMultiPartFileMap.put(key, file);
            return (T)this;
        }

        public T addMultipartFile(HashMap<String, File> multiPartFileMap) {
            if (multiPartFileMap != null) {
                for (Map.Entry<String, File> entry : multiPartFileMap.entrySet()) {
                    this.mMultiPartFileMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T setPercentageThresholdForCancelling(int percentageThresholdForCancelling) {
            this.mPercentageThresholdForCancelling = percentageThresholdForCancelling;
            return (T)this;
        }

        public T setContentType(String contentType) {
            this.mCustomContentType = contentType;
            return (T)this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class DownloadBuilder<T extends DownloadBuilder>
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private final String mUrl;
        private Object mTag;
        private final HashMap<String, String> mHeadersMap = new HashMap();
        private final HashMap<String, String> mQueryParameterMap = new HashMap();
        private final HashMap<String, String> mPathParameterMap = new HashMap();
        private final String mDirPath;
        private final String mFileName;
        private int mPercentageThresholdForCancelling = 0;
        private Executor mExecutor;
        private String mUserAgent;

        public DownloadBuilder(String url, String dirPath, String fileName) {
            this.mUrl = url;
            this.mDirPath = dirPath;
            this.mFileName = fileName;
        }

        public T setPriority(Priority priority) {
            this.mPriority = priority;
            return (T)this;
        }

        public T setTag(Object tag) {
            this.mTag = tag;
            return (T)this;
        }

        public T addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(HashMap<String, String> headerMap) {
            if (headerMap != null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    this.mHeadersMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return (T)this;
        }

        public T addQueryParameter(HashMap<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                for (Map.Entry<String, String> entry : queryParameterMap.entrySet()) {
                    this.mQueryParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return (T)this;
        }

        public T doNotCacheResponse() {
            return (T)this;
        }

        public T getResponseOnlyIfCached() {
            return (T)this;
        }

        public T getResponseOnlyFromNetwork() {
            return (T)this;
        }

        public T setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            return (T)this;
        }

        public T setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            return (T)this;
        }

        public T setExecutor(Executor executor) {
            this.mExecutor = executor;
            return (T)this;
        }

        public T setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return (T)this;
        }

        public T setPercentageThresholdForCancelling(int percentageThresholdForCancelling) {
            this.mPercentageThresholdForCancelling = percentageThresholdForCancelling;
            return (T)this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class PostRequestBuilder<T extends PostRequestBuilder>
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private final int mMethod;
        private final String mUrl;
        private Object mTag;
        private JSONObject mJsonObject = null;
        private JSONArray mJsonArray = null;
        private String mStringBody = null;
        private byte[] mByte = null;
        private File mFile = null;
        private final HashMap<String, String> mHeadersMap = new HashMap();
        private final HashMap<String, String> mBodyParameterMap = new HashMap();
        private final HashMap<String, String> mUrlEncodedFormBodyParameterMap = new HashMap();
        private final HashMap<String, String> mQueryParameterMap = new HashMap();
        private final HashMap<String, String> mPathParameterMap = new HashMap();
        private Executor mExecutor;
        private String mUserAgent;
        private String mCustomContentType;

        public PostRequestBuilder(String url) {
            this.mUrl = url;
            this.mMethod = 1;
        }

        public PostRequestBuilder(String url, int method) {
            this.mUrl = url;
            this.mMethod = method;
        }

        public T setPriority(Priority priority) {
            this.mPriority = priority;
            return (T)this;
        }

        public T setTag(Object tag) {
            this.mTag = tag;
            return (T)this;
        }

        public T addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return (T)this;
        }

        public T addQueryParameter(HashMap<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                for (Map.Entry<String, String> entry : queryParameterMap.entrySet()) {
                    this.mQueryParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(HashMap<String, String> headerMap) {
            if (headerMap != null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    this.mHeadersMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T doNotCacheResponse() {
            return (T)this;
        }

        public T getResponseOnlyIfCached() {
            return (T)this;
        }

        public T getResponseOnlyFromNetwork() {
            return (T)this;
        }

        public T setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            return (T)this;
        }

        public T setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            return (T)this;
        }

        public T setExecutor(Executor executor) {
            this.mExecutor = executor;
            return (T)this;
        }

        public T setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return (T)this;
        }

        public T addBodyParameter(String key, String value) {
            this.mBodyParameterMap.put(key, value);
            return (T)this;
        }

        public T addUrlEncodeFormBodyParameter(String key, String value) {
            this.mUrlEncodedFormBodyParameterMap.put(key, value);
            return (T)this;
        }

        public T addBodyParameter(HashMap<String, String> bodyParameterMap) {
            if (bodyParameterMap != null) {
                for (Map.Entry<String, String> entry : bodyParameterMap.entrySet()) {
                    this.mBodyParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T addUrlEncodeFormBodyParameter(HashMap<String, String> bodyParameterMap) {
            if (bodyParameterMap != null) {
                for (Map.Entry<String, String> entry : bodyParameterMap.entrySet()) {
                    this.mUrlEncodedFormBodyParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T addJsonObjectBody(JSONObject jsonObject) {
            this.mJsonObject = jsonObject;
            return (T)this;
        }

        public T addJsonArrayBody(JSONArray jsonArray) {
            this.mJsonArray = jsonArray;
            return (T)this;
        }

        public T addStringBody(String stringBody) {
            this.mStringBody = stringBody;
            return (T)this;
        }

        public T addFileBody(File file) {
            this.mFile = file;
            return (T)this;
        }

        public T addByteBody(byte[] bytes) {
            this.mByte = bytes;
            return (T)this;
        }

        public T setContentType(String contentType) {
            this.mCustomContentType = contentType;
            return (T)this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class PatchRequestBuilder
    extends PostRequestBuilder {
        public PatchRequestBuilder(String url) {
            super(url, 5);
        }
    }

    public static class DeleteRequestBuilder
    extends PostRequestBuilder {
        public DeleteRequestBuilder(String url) {
            super(url, 3);
        }
    }

    public static class PutRequestBuilder
    extends PostRequestBuilder {
        public PutRequestBuilder(String url) {
            super(url, 2);
        }
    }

    public static class GetRequestBuilder<T extends GetRequestBuilder>
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private final int mMethod;
        private final String mUrl;
        private Object mTag;
        private Bitmap.Config mDecodeConfig;
        private int mMaxWidth;
        private int mMaxHeight;
        private ImageView.ScaleType mScaleType;
        private final HashMap<String, String> mHeadersMap = new HashMap();
        private final HashMap<String, String> mQueryParameterMap = new HashMap();
        private final HashMap<String, String> mPathParameterMap = new HashMap();
        private Executor mExecutor;
        private String mUserAgent;

        public GetRequestBuilder(String url) {
            this.mUrl = url;
            this.mMethod = 0;
        }

        public GetRequestBuilder(String url, int method) {
            this.mUrl = url;
            this.mMethod = method;
        }

        public T setPriority(Priority priority) {
            this.mPriority = priority;
            return (T)this;
        }

        public T setTag(Object tag) {
            this.mTag = tag;
            return (T)this;
        }

        public T addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return (T)this;
        }

        public T addQueryParameter(HashMap<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                for (Map.Entry<String, String> entry : queryParameterMap.entrySet()) {
                    this.mQueryParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(HashMap<String, String> headerMap) {
            if (headerMap != null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    this.mHeadersMap.put(entry.getKey(), entry.getValue());
                }
            }
            return (T)this;
        }

        public T doNotCacheResponse() {
            return (T)this;
        }

        public T getResponseOnlyIfCached() {
            return (T)this;
        }

        public T getResponseOnlyFromNetwork() {
            return (T)this;
        }

        public T setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            return (T)this;
        }

        public T setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            return (T)this;
        }

        public T setExecutor(Executor executor) {
            this.mExecutor = executor;
            return (T)this;
        }

        public T setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return (T)this;
        }

        public T setBitmapConfig(Bitmap.Config bitmapConfig) {
            this.mDecodeConfig = bitmapConfig;
            return (T)this;
        }

        public T setBitmapMaxHeight(int maxHeight) {
            this.mMaxHeight = maxHeight;
            return (T)this;
        }

        public T setBitmapMaxWidth(int maxWidth) {
            this.mMaxWidth = maxWidth;
            return (T)this;
        }

        public T setImageScaleType(ImageView.ScaleType imageScaleType) {
            this.mScaleType = imageScaleType;
            return (T)this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class HeadRequestBuilder
    extends GetRequestBuilder {
        public HeadRequestBuilder(String url) {
            super(url, 4);
        }
    }
}

