/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.networking.core;

import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import com.meizu.cloud.pushsdk.networking.common.Priority;
import com.meizu.cloud.pushsdk.networking.internal.InternalRunnable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ANExecutor
extends ThreadPoolExecutor {
    private static final int DEFAULT_THREAD_COUNT = 3;

    ANExecutor(int maxNumThreads, ThreadFactory threadFactory) {
        super(maxNumThreads, maxNumThreads, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), threadFactory);
    }

    void adjustThreadCount(NetworkInfo info) {
        if (info == null || !info.isConnectedOrConnecting()) {
            this.setThreadCount(3);
            return;
        }
        block0 : switch (info.getType()) {
            case 1: 
            case 6: 
            case 9: {
                this.setThreadCount(4);
                break;
            }
            case 0: {
                switch (info.getSubtype()) {
                    case 13: 
                    case 14: 
                    case 15: {
                        this.setThreadCount(3);
                        break block0;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 12: {
                        this.setThreadCount(2);
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        this.setThreadCount(1);
                        break block0;
                    }
                }
                this.setThreadCount(3);
                break;
            }
            default: {
                this.setThreadCount(3);
            }
        }
    }

    private void setThreadCount(int threadCount) {
        this.setCorePoolSize(threadCount);
        this.setMaximumPoolSize(threadCount);
    }

    @Override
    @NonNull
    public Future<?> submit(Runnable task) {
        AndroidNetworkingFutureTask futureTask = new AndroidNetworkingFutureTask((InternalRunnable)task);
        this.execute(futureTask);
        return futureTask;
    }

    private static final class AndroidNetworkingFutureTask
    extends FutureTask<InternalRunnable>
    implements Comparable<AndroidNetworkingFutureTask> {
        private final InternalRunnable hunter;

        public AndroidNetworkingFutureTask(InternalRunnable hunter) {
            super(hunter, null);
            this.hunter = hunter;
        }

        @Override
        public int compareTo(AndroidNetworkingFutureTask other) {
            Priority p2;
            Priority p1 = this.hunter.getPriority();
            return p1 == (p2 = other.hunter.getPriority()) ? this.hunter.sequence - other.hunter.sequence : p2.ordinal() - p1.ordinal();
        }
    }
}

