/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.networking.core;

import com.meizu.cloud.pushsdk.networking.core.ANExecutor;
import com.meizu.cloud.pushsdk.networking.core.ExecutorSupplier;
import com.meizu.cloud.pushsdk.networking.core.MainThreadExecutor;
import com.meizu.cloud.pushsdk.networking.core.PriorityThreadFactory;
import java.util.concurrent.Executor;

public class DefaultExecutorSupplier
implements ExecutorSupplier {
    private static final int DEFAULT_MAX_NUM_THREADS = 2 * Runtime.getRuntime().availableProcessors() + 1;
    private final ANExecutor mNetworkExecutor;
    private final ANExecutor mImmediateNetworkExecutor;
    private final Executor mMainThreadExecutor;

    public DefaultExecutorSupplier() {
        PriorityThreadFactory backgroundPriorityThreadFactory = new PriorityThreadFactory(10);
        this.mNetworkExecutor = new ANExecutor(DEFAULT_MAX_NUM_THREADS, backgroundPriorityThreadFactory);
        this.mImmediateNetworkExecutor = new ANExecutor(2, backgroundPriorityThreadFactory);
        this.mMainThreadExecutor = new MainThreadExecutor();
    }

    @Override
    public ANExecutor forNetworkTasks() {
        return this.mNetworkExecutor;
    }

    @Override
    public ANExecutor forImmediateNetworkTasks() {
        return this.mImmediateNetworkExecutor;
    }

    @Override
    public Executor forMainThreadTasks() {
        return this.mMainThreadExecutor;
    }
}

