/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.networking.internal;

import com.meizu.cloud.pushsdk.networking.common.ANRequest;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.networking.http.Headers;
import com.meizu.cloud.pushsdk.networking.http.HttpURLConnectionCall;
import com.meizu.cloud.pushsdk.networking.http.Request;
import com.meizu.cloud.pushsdk.networking.http.RequestBody;
import com.meizu.cloud.pushsdk.networking.http.Response;
import com.meizu.cloud.pushsdk.networking.internal.RequestProgressBody;
import com.meizu.cloud.pushsdk.networking.utils.Utils;
import java.io.File;
import java.io.IOException;

public final class InternalNetworking {
    private static String sUserAgent = null;

    private InternalNetworking() {
    }

    public static Response performSimpleRequest(ANRequest request) throws ANError {
        Response okHttpResponse;
        try {
            Request.Builder builder = new Request.Builder().url(request.getUrl());
            InternalNetworking.addHeadersToRequestBuilder(builder, request);
            switch (request.getMethod()) {
                case 0: {
                    builder = builder.get();
                    break;
                }
                case 1: {
                    RequestBody requestBody = request.getRequestBody();
                    builder = builder.post(requestBody);
                    break;
                }
                case 2: {
                    RequestBody requestBody = request.getRequestBody();
                    builder = builder.put(requestBody);
                    break;
                }
                case 3: {
                    RequestBody requestBody = request.getRequestBody();
                    builder = builder.delete(requestBody);
                    break;
                }
                case 4: {
                    builder = builder.head();
                    break;
                }
                case 5: {
                    RequestBody requestBody = request.getRequestBody();
                    builder = builder.patch(requestBody);
                    break;
                }
            }
            Request okHttpRequest = builder.build();
            request.setCall(new HttpURLConnectionCall());
            okHttpResponse = request.getCall().execute(okHttpRequest);
        }
        catch (IOException ioe) {
            throw new ANError(ioe);
        }
        return okHttpResponse;
    }

    public static Response performDownloadRequest(ANRequest request) throws ANError {
        Response okHttpResponse;
        try {
            Request.Builder builder = new Request.Builder().url(request.getUrl());
            InternalNetworking.addHeadersToRequestBuilder(builder, request);
            builder = builder.get();
            Request okHttpRequest = builder.build();
            request.setCall(new HttpURLConnectionCall());
            okHttpResponse = request.getCall().execute(okHttpRequest);
            Utils.saveFile(okHttpResponse, request.getDirPath(), request.getFileName());
        }
        catch (IOException ioe) {
            try {
                File destinationFile = new File(request.getDirPath() + File.separator + request.getFileName());
                if (destinationFile.exists()) {
                    destinationFile.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new ANError(ioe);
        }
        return okHttpResponse;
    }

    public static Response performUploadRequest(ANRequest request) throws ANError {
        Response okHttpResponse;
        try {
            Request.Builder builder = new Request.Builder().url(request.getUrl());
            InternalNetworking.addHeadersToRequestBuilder(builder, request);
            RequestBody requestBody = request.getMultiPartRequestBody();
            builder = builder.post(new RequestProgressBody(requestBody, request.getUploadProgressListener()));
            Request okHttpRequest = builder.build();
            request.setCall(new HttpURLConnectionCall());
            okHttpResponse = request.getCall().execute(okHttpRequest);
        }
        catch (IOException ioe) {
            throw new ANError(ioe);
        }
        return okHttpResponse;
    }

    public static void addHeadersToRequestBuilder(Request.Builder builder, ANRequest request) {
        if (request.getUserAgent() != null) {
            builder.addHeader("User-Agent", request.getUserAgent());
        } else if (sUserAgent != null) {
            request.setUserAgent(sUserAgent);
            builder.addHeader("User-Agent", sUserAgent);
        }
        Headers requestHeaders = request.getHeaders();
        if (requestHeaders != null) {
            builder.headers(requestHeaders);
            if (request.getUserAgent() != null && !requestHeaders.names().contains("User-Agent")) {
                builder.addHeader("User-Agent", request.getUserAgent());
            }
        }
    }

    public static void setUserAgent(String userAgent) {
        sUserAgent = userAgent;
    }
}

