/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.networking.internal;

import com.meizu.cloud.pushsdk.networking.common.ANLog;
import com.meizu.cloud.pushsdk.networking.common.ANRequest;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.common.Priority;
import com.meizu.cloud.pushsdk.networking.common.ResponseType;
import com.meizu.cloud.pushsdk.networking.core.Core;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.networking.http.Response;
import com.meizu.cloud.pushsdk.networking.internal.InternalNetworking;
import com.meizu.cloud.pushsdk.networking.utils.SourceCloseUtil;
import com.meizu.cloud.pushsdk.networking.utils.Utils;

public class InternalRunnable
implements Runnable {
    private static final int ERROR_REQUEST_CODE = 400;
    private final Priority priority;
    public final int sequence;
    private final ANRequest request;

    public InternalRunnable(ANRequest request) {
        this.request = request;
        this.sequence = request.getSequenceNumber();
        this.priority = request.getPriority();
    }

    @Override
    public void run() {
        ANLog.d("execution started : " + this.request.toString());
        switch (this.request.getRequestType()) {
            case 0: {
                this.executeSimpleRequest();
                break;
            }
            case 1: {
                this.executeDownloadRequest();
                break;
            }
            case 2: {
                this.executeUploadRequest();
                break;
            }
        }
        ANLog.d("execution done : " + this.request.toString());
    }

    private void executeSimpleRequest() {
        Response okHttpResponse = null;
        try {
            okHttpResponse = InternalNetworking.performSimpleRequest(this.request);
            if (okHttpResponse == null) {
                this.deliverError(this.request, Utils.getErrorForConnection(new ANError()));
                return;
            }
            if (this.request.getResponseAs() == ResponseType.OK_HTTP_RESPONSE) {
                this.request.deliverOkHttpResponse(okHttpResponse);
                return;
            }
            if (okHttpResponse.code() >= 400) {
                this.deliverError(this.request, Utils.getErrorForServerResponse(new ANError(okHttpResponse), this.request, okHttpResponse.code()));
                return;
            }
            ANResponse response = this.request.parseResponse(okHttpResponse);
            if (!response.isSuccess()) {
                this.deliverError(this.request, response.getError());
                return;
            }
            response.setOkHttpResponse(okHttpResponse);
            this.request.deliverResponse(response);
        }
        catch (Exception e) {
            this.deliverError(this.request, Utils.getErrorForConnection(new ANError(e)));
        }
        finally {
            SourceCloseUtil.close(okHttpResponse, this.request);
        }
    }

    private void executeDownloadRequest() {
        try {
            Response okHttpResponse = InternalNetworking.performDownloadRequest(this.request);
            if (okHttpResponse == null) {
                this.deliverError(this.request, Utils.getErrorForConnection(new ANError()));
                return;
            }
            if (okHttpResponse.code() >= 400) {
                this.deliverError(this.request, Utils.getErrorForServerResponse(new ANError(okHttpResponse), this.request, okHttpResponse.code()));
                return;
            }
            this.request.updateDownloadCompletion();
        }
        catch (Exception e) {
            this.deliverError(this.request, Utils.getErrorForConnection(new ANError(e)));
        }
    }

    private void executeUploadRequest() {
        Response okHttpResponse = null;
        try {
            okHttpResponse = InternalNetworking.performUploadRequest(this.request);
            if (okHttpResponse == null) {
                this.deliverError(this.request, Utils.getErrorForConnection(new ANError()));
                return;
            }
            if (this.request.getResponseAs() == ResponseType.OK_HTTP_RESPONSE) {
                this.request.deliverOkHttpResponse(okHttpResponse);
                return;
            }
            if (okHttpResponse.code() >= 400) {
                this.deliverError(this.request, Utils.getErrorForServerResponse(new ANError(okHttpResponse), this.request, okHttpResponse.code()));
                return;
            }
            ANResponse response = this.request.parseResponse(okHttpResponse);
            if (!response.isSuccess()) {
                this.deliverError(this.request, response.getError());
                return;
            }
            response.setOkHttpResponse(okHttpResponse);
            this.request.deliverResponse(response);
        }
        catch (Exception e) {
            this.deliverError(this.request, Utils.getErrorForConnection(new ANError(e)));
        }
        finally {
            SourceCloseUtil.close(okHttpResponse, this.request);
        }
    }

    public Priority getPriority() {
        return this.priority;
    }

    private void deliverError(final ANRequest request, final ANError anError) {
        Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

            @Override
            public void run() {
                request.deliverError(anError);
                request.finish();
            }
        });
    }
}

