/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Parcelable;
import android.os.PowerManager;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.PushMessageProxy;
import com.meizu.cloud.pushsdk.handler.MessageSerialize;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.impl.Advertisement.AdNotification;
import com.meizu.cloud.pushsdk.networking.AndroidNetworking;
import com.meizu.cloud.pushsdk.networking.common.ANRequest;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSetting;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSettingEx;
import com.meizu.cloud.pushsdk.notification.model.NotifyOption;
import com.meizu.cloud.pushsdk.notification.util.NotificationUtils;
import com.meizu.cloud.pushsdk.notification.util.RProxy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import org.json.JSONObject;

public abstract class AbstractPushNotification
implements PushNotification {
    protected static final String TAG = "AbstractPushNotification";
    protected final Context context;
    protected final PushNotificationBuilder pushNotificationBuilder;
    private final NotificationManager notificationManager;
    private final Handler handler;
    private static final String MZ_PUSH_CHANNEL_ID_MIN = "mz_push_notification_channel_min";
    private static final String MZ_PUSH_CHANNEL_NAME_MIN = "MEIZUPUSHMIN";
    private static final String MZ_PUSH_CHANNEL_ID_LOW = "mz_push_notification_channel_low";
    private static final String MZ_PUSH_CHANNEL_NAME_LOW = "MEIZUPUSHLOW";
    private static final String MZ_PUSH_CHANNEL_ID_DEFAULT = "mz_push_notification_channel";
    private static final String MZ_PUSH_CHANNEL_NAME_DEFAULT = "MEIZUPUSH";
    private static final String MZ_PUSH_CHANNEL_ID_HIGH = "mz_push_notification_channel_high";
    private static final String MZ_PUSH_CHANNEL_NAME_HIGH = "MEIZUPUSHHIGH";
    private static final String MZ_PUSH_CHANNEL_ID_MAX = "mz_push_notification_channel_max";
    private static final String MZ_PUSH_CHANNEL_NAME_MAX = "MEIZUPUSHMAX";

    protected AbstractPushNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        this.pushNotificationBuilder = pushNotificationBuilder;
        this.context = context;
        this.handler = new Handler(context.getMainLooper());
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
    }

    protected void buildExpandableContent(Notification.Builder builder, MessageV3 messageV3) {
    }

    protected void buildContentView(Notification notification, MessageV3 messageV3) {
    }

    protected void buildBigContentView(Notification notification, MessageV3 messageV3, PendingIntent closeIntent) {
    }

    protected void appIconSettingBuilder(Notification.Builder builder, MessageV3 messageV3) {
    }

    private Notification constructNotificationFinal(MessageV3 messageV3, PendingIntent clickIntent, PendingIntent deleteIntent, PendingIntent closeIntent) {
        Notification.Builder builder = new Notification.Builder(this.context);
        this.basicSettingBuilder(builder, messageV3, clickIntent, deleteIntent);
        this.advanceSettingBuilder(builder, messageV3);
        this.appIconSettingBuilder(builder, messageV3);
        this.buildExpandableContent(builder, messageV3);
        this.notificationChannelBuilder(builder, messageV3);
        Notification notification = MinSdkChecker.isSupportNotificationBuild() ? builder.build() : builder.getNotification();
        this.buildNotificationExtraInfo(notification, messageV3);
        this.buildContentView(notification, messageV3);
        this.buildBigContentView(notification, messageV3, closeIntent);
        return notification;
    }

    private PendingIntent createClickIntent(MessageV3 messageV3) {
        if (this.clickIntentToMeizuCloud(messageV3)) {
            return this.createClickIntent(messageV3, messageV3.getPackageName(), false);
        }
        return this.createClickIntent(messageV3, messageV3.getUploadDataPackageName(), true);
    }

    private boolean clickIntentToMeizuCloud(MessageV3 messageV3) {
        if (messageV3.getAdvertisementOption() != null && !TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdPackage())) {
            return true;
        }
        return messageV3.getWhiteList() && !MzSystemUtils.isExistReceiver(this.context, messageV3.getUploadDataPackageName(), "com.meizu.flyme.push.intent.MESSAGE");
    }

    private PendingIntent createClickIntent(MessageV3 messageV3, String packageName, boolean needTransmitMessageValue) {
        Intent serviceClickIntent = new Intent();
        serviceClickIntent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        if (needTransmitMessageValue && MinSdkChecker.isSupportTransmitMessageValue(this.context, packageName)) {
            serviceClickIntent.putExtra("messageValue", MessageSerialize.messageV3ToString(messageV3));
        } else {
            serviceClickIntent.putExtra("pushMessage", (Parcelable)messageV3);
        }
        serviceClickIntent.putExtra("method", "private");
        serviceClickIntent.setClassName(packageName, MzSystemUtils.findReceiver(this.context, "com.meizu.flyme.push.intent.MESSAGE", packageName));
        serviceClickIntent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        serviceClickIntent.setFlags(32);
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)serviceClickIntent, (int)0x40000000);
    }

    private PendingIntent createDeleteIntent(MessageV3 messageV3) {
        Intent serviceDeleteIntent = new Intent();
        serviceDeleteIntent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        serviceDeleteIntent.putExtra("pushMessage", (Parcelable)messageV3);
        serviceDeleteIntent.putExtra("method", "notification_delete");
        serviceDeleteIntent.setClassName(messageV3.getPackageName(), MzSystemUtils.findReceiver(this.context, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getPackageName()));
        serviceDeleteIntent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)serviceDeleteIntent, (int)0x40000000);
    }

    private PendingIntent createCloseIntent(MessageV3 messageV3) {
        Intent serviceDeleteIntent = new Intent();
        serviceDeleteIntent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        serviceDeleteIntent.putExtra("pushMessage", (Parcelable)messageV3);
        serviceDeleteIntent.putExtra("method", "notification_close");
        serviceDeleteIntent.setClassName(messageV3.getPackageName(), MzSystemUtils.findReceiver(this.context, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getPackageName()));
        serviceDeleteIntent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)serviceDeleteIntent, (int)0x40000000);
    }

    private PendingIntent createStateIntent(MessageV3 messageV3) {
        Intent serviceStateIntent = new Intent();
        serviceStateIntent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        serviceStateIntent.putExtra("notification_state_message", messageV3.getNotificationMessage());
        serviceStateIntent.putExtra("notification_extra_task_id", messageV3.getTaskId());
        serviceStateIntent.putExtra("notification_extra_seq_id", messageV3.getSeqId());
        serviceStateIntent.putExtra("notification_extra_device_id", messageV3.getDeviceId());
        serviceStateIntent.putExtra("notification_extra_push_timestamp", messageV3.getPushTimestamp());
        serviceStateIntent.putExtra("notification_extra_show_package_name", messageV3.getUploadDataPackageName());
        serviceStateIntent.putExtra("mz_push_white_list", messageV3.getWhiteList());
        serviceStateIntent.putExtra("mz_push_delayed_report_millis", messageV3.getDelayedReportMillis());
        serviceStateIntent.putExtra("method", "notification_state");
        String messageReceiver = MzSystemUtils.findReceiver(this.context, "com.meizu.flyme.push.intent.MESSAGE", messageV3.getPackageName());
        serviceStateIntent.setClassName(messageV3.getPackageName(), messageReceiver);
        serviceStateIntent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)serviceStateIntent, (int)0x40000000);
    }

    private void basicSettingBuilder(Notification.Builder builder, MessageV3 messageV3, PendingIntent clickIntent, PendingIntent deleteIntent) {
        builder.setContentTitle((CharSequence)messageV3.getTitle());
        builder.setContentText((CharSequence)messageV3.getContent());
        builder.setTicker((CharSequence)messageV3.getTitle());
        builder.setAutoCancel(true);
        if (MinSdkChecker.isSupportSendNotification()) {
            builder.setVisibility(1);
        }
        if (MinSdkChecker.isSupportSetDrawableSmallIcon()) {
            Icon smallIcon = this.loadSmallIcon(messageV3.getUploadDataPackageName());
            if (smallIcon != null) {
                builder.setSmallIcon(smallIcon);
            } else {
                DebugLogger.e(TAG, "cannot get " + messageV3.getUploadDataPackageName() + " smallIcon");
                builder.setSmallIcon(RProxy.statSysThirdAppNotify(this.context));
            }
        } else {
            builder.setSmallIcon(this.pushNotificationBuilder != null && this.pushNotificationBuilder.getStatusBarIcon() != 0 ? this.pushNotificationBuilder.getStatusBarIcon() : RProxy.statSysThirdAppNotify(this.context));
        }
        builder.setContentIntent(clickIntent);
        builder.setDeleteIntent(deleteIntent);
    }

    private void advanceSettingBuilder(Notification.Builder builder, MessageV3 messageV3) {
        boolean sound;
        AdvanceSetting advanceSetting = messageV3.getAdvanceSetting();
        AdvanceSettingEx advanceSettingEx = messageV3.getAdvanceSettingEx();
        if (advanceSetting == null) {
            return;
        }
        if (advanceSettingEx != null && !TextUtils.isEmpty((CharSequence)advanceSettingEx.getSoundTitle())) {
            Uri uri = NotificationUtils.getRingtoneInfo(this.context, advanceSettingEx.getSoundTitle());
            if (uri != null) {
                DebugLogger.e(TAG, "advance setting builder, sound:" + uri);
                builder.setSound(uri);
                sound = false;
            } else {
                sound = true;
            }
        } else {
            sound = advanceSetting.getNotifyType().isSound();
        }
        if (advanceSetting.getNotifyType() != null) {
            boolean vibrate = advanceSetting.getNotifyType().isVibrate();
            boolean lights = advanceSetting.getNotifyType().isLights();
            if (vibrate || lights || sound) {
                int defaultType = 0;
                if (vibrate) {
                    defaultType |= 2;
                }
                if (lights) {
                    defaultType |= 4;
                }
                if (sound) {
                    defaultType |= 1;
                }
                DebugLogger.e(TAG, "advance setting builder, defaults:" + defaultType);
                builder.setDefaults(defaultType);
            }
        }
        DebugLogger.e(TAG, "advance setting builder, ongoing:" + !advanceSetting.isClearNotification());
        builder.setOngoing(!advanceSetting.isClearNotification());
        if (advanceSettingEx != null && MinSdkChecker.isSupportNotificationBuild()) {
            DebugLogger.e(TAG, "advance setting builder, priority:" + advanceSettingEx.getPriorityDisplay());
            builder.setPriority(advanceSettingEx.getPriorityDisplay());
        }
    }

    protected Bitmap getBitmapFromUrl(String src) {
        ANRequest request = AndroidNetworking.get(src).build();
        ANResponse response = request.executeForBitmap();
        if (response.isSuccess() && response.getResult() != null) {
            DebugLogger.i(TAG, "ANRequest On other Thread down load largeIcon " + src + "image " + (response.getResult() != null ? "success" : "fail"));
            return (Bitmap)response.getResult();
        }
        DebugLogger.i(TAG, "ANRequest On other Thread down load largeIcon " + src + "image fail");
        return null;
    }

    @TargetApi(value=23)
    private Icon loadSmallIcon(String packageName) {
        Icon smallIcon = null;
        try {
            Resources res = this.context.getPackageManager().getResourcesForApplication(packageName);
            int titleId = res.getIdentifier("mz_push_notification_small_icon", "drawable", packageName);
            if (titleId != 0) {
                DebugLogger.i(TAG, "get " + packageName + " smallIcon success resId " + titleId);
                smallIcon = Icon.createWithResource((String)packageName, (int)titleId);
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "cannot load smallIcon form package " + packageName + " Error message " + e.getMessage());
        }
        return smallIcon;
    }

    protected Bitmap getAppIcon(Context context, String packageName) {
        Bitmap appIcon = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            Drawable drawable2 = packageManager.getApplicationIcon(packageName);
            BitmapDrawable bitmapDrawable = null;
            if (Build.VERSION.SDK_INT >= 26) {
                if (drawable2 instanceof BitmapDrawable) {
                    bitmapDrawable = (BitmapDrawable)drawable2;
                } else if (drawable2 instanceof AdaptiveIconDrawable) {
                    Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas canvas = new Canvas(bitmap);
                    drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                    drawable2.draw(canvas);
                    appIcon = bitmap;
                }
            } else {
                bitmapDrawable = (BitmapDrawable)drawable2;
            }
            if (appIcon == null) {
                appIcon = bitmapDrawable.getBitmap();
            }
        }
        catch (Exception e) {
            DebugLogger.i(TAG, "get app icon error " + e.getMessage());
            BitmapDrawable bitmapDrawable = (BitmapDrawable)context.getApplicationInfo().loadIcon(context.getPackageManager());
            appIcon = bitmapDrawable.getBitmap();
        }
        return appIcon;
    }

    private String getAppLabel(Context context, String packageName) {
        String applicationLabel = null;
        try {
            CharSequence charSequenceLabel;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 0);
            if (applicationInfo != null && (charSequenceLabel = packageManager.getApplicationLabel(applicationInfo)) != null) {
                applicationLabel = (String)charSequenceLabel;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            DebugLogger.e(TAG, "can not find " + packageName + " application info");
        }
        return applicationLabel;
    }

    protected boolean isOnMainThread() {
        return Thread.currentThread() == this.context.getMainLooper().getThread();
    }

    protected boolean isScreenOnAndUnlock() {
        try {
            PowerManager powerManager = (PowerManager)this.context.getSystemService("power");
            if (Build.VERSION.SDK_INT < 20 ? powerManager.isScreenOn() : powerManager.isInteractive()) {
                KeyguardManager keyguardManager = (KeyguardManager)this.context.getSystemService("keyguard");
                return !keyguardManager.inKeyguardRestrictedInputMode();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected String getFlymeGreenNotificationSetting(MessageV3 messageV3) {
        String flymeNotificationSetting = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)messageV3.getNotificationMessage())) {
                JSONObject jsonObject = new JSONObject(messageV3.getNotificationMessage());
                flymeNotificationSetting = jsonObject.getJSONObject("data").getJSONObject("extra").getString("fns");
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "parse flyme notification setting error " + e.getMessage());
        }
        DebugLogger.i(TAG, "current FlymeGreen notification setting is " + flymeNotificationSetting);
        return flymeNotificationSetting;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void show(MessageV3 messageV3) {
        String uploadDataPackageName = null;
        if (messageV3.getAdvertisementOption() != null && !TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdPackage())) {
            uploadDataPackageName = this.againShowOldAdAndReplacePackage(messageV3);
        }
        Notification notification = this.constructNotificationFinal(messageV3, this.createClickIntent(messageV3), this.createDeleteIntent(messageV3), this.createCloseIntent(messageV3));
        int notifyId = Math.abs((int)System.currentTimeMillis());
        NotifyOption notifyOption = NotifyOption.getNotifyOptionSetting(messageV3);
        if (notifyOption != null && notifyOption.getNotifyId() != 0) {
            notifyId = notifyOption.getNotifyId();
            DebugLogger.e(TAG, "server notify id " + notifyId);
            if (!TextUtils.isEmpty((CharSequence)notifyOption.getNotifyKey())) {
                int preferenceNotifyId = PushPreferencesUtils.getNotifyIdByNotifyKey(this.context, messageV3.getUploadDataPackageName(), notifyOption.getNotifyKey());
                DebugLogger.e(TAG, "notifyKey " + notifyOption.getNotifyKey() + " preference notifyId is " + preferenceNotifyId);
                if (preferenceNotifyId != 0) {
                    DebugLogger.e(TAG, "use preference notifyId " + preferenceNotifyId + " and cancel it");
                    this.notificationManager.cancel(preferenceNotifyId);
                }
                DebugLogger.e(TAG, "store new notifyId " + notifyId + " by notifyKey " + notifyOption.getNotifyKey());
                PushPreferencesUtils.putNotifyIdByNotifyKey(this.context, messageV3.getUploadDataPackageName(), notifyOption.getNotifyKey(), notifyId);
            }
        }
        DebugLogger.e(TAG, "current notify id " + notifyId);
        if (messageV3.isDiscard()) {
            if (PushPreferencesUtils.getDiscardNotificationId(this.context, messageV3.getPackageName()) == 0) {
                PushPreferencesUtils.putDiscardNotificationIdByPackageName(this.context, messageV3.getPackageName(), notifyId);
                DebugLogger.i(TAG, "no notification show so put notification id " + notifyId);
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getTaskId())) {
                if (PushPreferencesUtils.getDiscardNotificationTaskId(this.context, messageV3.getPackageName()) == 0) {
                    PushPreferencesUtils.putDiscardNotificationTaskId(this.context, messageV3.getPackageName(), Integer.valueOf(messageV3.getTaskId()));
                } else {
                    if (Integer.valueOf(messageV3.getTaskId()) < PushPreferencesUtils.getDiscardNotificationTaskId(this.context, messageV3.getPackageName())) {
                        DebugLogger.i(TAG, "current package " + messageV3.getPackageName() + " task id " + messageV3.getTaskId() + " don't show notification");
                        return;
                    }
                    PushPreferencesUtils.putDiscardNotificationTaskId(this.context, messageV3.getPackageName(), Integer.valueOf(messageV3.getTaskId()));
                    notifyId = PushPreferencesUtils.getDiscardNotificationId(this.context, messageV3.getPackageName());
                }
            }
            DebugLogger.i(TAG, "current package " + messageV3.getPackageName() + " notificationId=" + notifyId + " taskId=" + messageV3.getTaskId());
        }
        if (messageV3.getAdvertisementOption() != null && !TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdPackage())) {
            this.saveAdAndRecoveryPackage(notifyId, uploadDataPackageName, messageV3);
        }
        this.notificationManager.notify(notifyId, notification);
    }

    private String againShowOldAdAndReplacePackage(MessageV3 messageV3) {
        if (messageV3 == null || messageV3.getAdvertisementOption() == null || TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdPackage())) {
            return null;
        }
        String uploadDataPackageName = messageV3.getUploadDataPackageName();
        String adPackageName = messageV3.getAdvertisementOption().getAdPackage();
        DebugLogger.e(TAG, "again show old ad and replace package, uploadDataPackageName:" + uploadDataPackageName + ", adPackageName:" + adPackageName);
        AdNotification adNotification = PushMessageProxy.with(this.context).getAdNotification();
        if (adNotification != null) {
            adNotification.againShowOldAdNotification();
        }
        messageV3.setUploadDataPackageName(adPackageName);
        return uploadDataPackageName;
    }

    private void saveAdAndRecoveryPackage(int notifyId, String uploadDataPackageName, MessageV3 messageV3) {
        if (messageV3 == null || messageV3.getAdvertisementOption() == null || TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdPackage())) {
            return;
        }
        DebugLogger.e(TAG, "save ad and recovery package, uploadDataPackageName:" + uploadDataPackageName);
        AdNotification adNotification = PushMessageProxy.with(this.context).getAdNotification();
        if (adNotification != null) {
            int priorityValidTime = messageV3.getAdvertisementOption().getPriorityValidTime();
            adNotification.reduceMessagePriority(messageV3);
            Notification notification = this.constructNotificationFinal(messageV3, this.createClickIntent(messageV3), this.createDeleteIntent(messageV3), this.createCloseIntent(messageV3));
            adNotification.saveAdNotification(notifyId, notification, priorityValidTime);
        }
        messageV3.setUploadDataPackageName(uploadDataPackageName);
    }

    @SuppressLint(value={"NewApi"})
    private void buildNotificationExtraInfo(Notification notification, MessageV3 messageV3) {
        NotificationUtils.setInternalApp(notification, true);
        NotificationUtils.setReplyIntent(notification, this.createStateIntent(messageV3));
        notification.extras.putString("android.originalPackageName", messageV3.getUploadDataPackageName());
        notification.extras.putString("android.flymeNotificationSetting", this.getFlymeGreenNotificationSetting(messageV3));
        notification.extras.putString("notification_extra_task_id", messageV3.getTaskId());
        notification.extras.putString("notification_extra_seq_id", messageV3.getSeqId());
        notification.extras.putString("notification_extra_device_id", messageV3.getDeviceId());
        notification.extras.putString("notification_extra_push_timestamp", messageV3.getPushTimestamp());
        if (!TextUtils.isEmpty((CharSequence)this.pushNotificationBuilder.getAppLabel())) {
            DebugLogger.e(TAG, "set app label " + this.pushNotificationBuilder.getAppLabel());
            notification.extras.putString("android.substName", this.pushNotificationBuilder.getAppLabel());
        } else {
            String label = this.getAppLabel(this.context, messageV3.getUploadDataPackageName());
            DebugLogger.e(TAG, "current package " + messageV3.getUploadDataPackageName() + " label is " + label);
            if (!TextUtils.isEmpty((CharSequence)label)) {
                notification.extras.putString("android.substName", label);
            }
        }
    }

    protected void dismissFloatNotification(final NotificationManager notificationManager, final int notificationId, MessageV3 messageV3) {
        AdvanceSetting advanceSetting = messageV3.getAdvanceSetting();
        if (advanceSetting != null) {
            boolean isFloatNotification = advanceSetting.isHeadUpNotification();
            boolean isClearNotification = advanceSetting.isClearNotification();
            if (isFloatNotification && !isClearNotification) {
                messageV3.getAdvanceSetting().setHeadUpNotification(false);
                messageV3.getAdvanceSetting().getNotifyType().setSound(false);
                messageV3.getAdvanceSetting().getNotifyType().setVibrate(false);
                final Notification notification = this.constructNotificationFinal(messageV3, this.createClickIntent(messageV3), this.createDeleteIntent(messageV3), this.createCloseIntent(messageV3));
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        notificationManager.notify(notificationId, notification);
                    }
                }, 5000L);
            }
        }
    }

    private void notificationChannelBuilder(Notification.Builder builder, MessageV3 messageV3) {
        int importance;
        String channelName;
        String channelId;
        int priorityDisplay;
        if (!MinSdkChecker.isSupportNotificationChannel()) {
            return;
        }
        AdvanceSetting advanceSetting = messageV3.getAdvanceSetting();
        AdvanceSettingEx advanceSettingEx = messageV3.getAdvanceSettingEx();
        int n = priorityDisplay = advanceSettingEx != null ? advanceSettingEx.getPriorityDisplay() : 0;
        if (Build.VERSION.SDK_INT >= 29 && advanceSetting.isHeadUpNotification() && advanceSettingEx.getPriorityDisplay() < 1) {
            priorityDisplay = 1;
        }
        switch (priorityDisplay) {
            case -2: {
                channelId = MZ_PUSH_CHANNEL_ID_MIN;
                channelName = MZ_PUSH_CHANNEL_NAME_MIN;
                importance = 1;
                break;
            }
            case -1: {
                channelId = MZ_PUSH_CHANNEL_ID_LOW;
                channelName = MZ_PUSH_CHANNEL_NAME_LOW;
                importance = 2;
                break;
            }
            case 1: {
                channelId = MZ_PUSH_CHANNEL_ID_HIGH;
                channelName = MZ_PUSH_CHANNEL_NAME_HIGH;
                importance = 4;
                break;
            }
            case 2: {
                channelId = MZ_PUSH_CHANNEL_ID_MAX;
                channelName = MZ_PUSH_CHANNEL_NAME_MAX;
                importance = 5;
                break;
            }
            default: {
                channelId = MZ_PUSH_CHANNEL_ID_DEFAULT;
                channelName = MZ_PUSH_CHANNEL_NAME_DEFAULT;
                importance = 3;
            }
        }
        Uri uri = null;
        if (advanceSettingEx.getSoundTitle() != null) {
            uri = NotificationUtils.getRingtoneInfo(this.context, advanceSettingEx.getSoundTitle());
        }
        if (!advanceSetting.getNotifyType().isSound() && advanceSettingEx.getSoundTitle() == null) {
            channelId = channelId + "_mute";
            channelName = channelName + "_MUTE";
        } else if (uri != null) {
            channelId = channelId + "_" + advanceSettingEx.getSoundTitle().toLowerCase();
            channelName = channelName + "_" + advanceSettingEx.getSoundTitle().toUpperCase();
        }
        DebugLogger.e(TAG, "notification channel builder, channelId: " + channelId + ", channelName: " + channelName + ", importance:" + importance + ", sound: " + uri);
        NotificationChannel notificationChannel = new NotificationChannel(channelId, (CharSequence)channelName, importance);
        notificationChannel.enableLights(true);
        notificationChannel.setLightColor(-16711936);
        notificationChannel.setShowBadge(true);
        if (!advanceSetting.getNotifyType().isSound() && advanceSettingEx.getSoundTitle() == null) {
            notificationChannel.setSound(null, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        } else if (uri != null) {
            notificationChannel.setSound(uri, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        }
        this.notificationManager.createNotificationChannel(notificationChannel);
        builder.setChannelId(channelId);
    }
}

