/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification;

import com.meizu.cloud.pushinternal.DebugLogger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MPushMessage
implements Serializable {
    private static final String TAG = "MPushMessage";
    private String taskId;
    private String pushType;
    private String packageName;
    private String title;
    private String content;
    private String notifyType;
    private String clickType;
    private String isDiscard;
    private Map<String, String> extra = new HashMap<String, String>();
    private Map<String, String> params = new HashMap<String, String>();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getNotifyType() {
        return this.notifyType;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }

    public String getClickType() {
        return this.clickType;
    }

    public void setClickType(String clickType) {
        this.clickType = clickType;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getPushType() {
        return this.pushType;
    }

    public void setPushType(String pushType) {
        this.pushType = pushType;
    }

    public String getIsDiscard() {
        return this.isDiscard;
    }

    public void setIsDiscard(String isDiscard) {
        this.isDiscard = isDiscard;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String toString() {
        return "MPushMessage{taskId='" + this.taskId + '\'' + ", pushType='" + this.pushType + '\'' + ", packageName='" + this.packageName + '\'' + ", title='" + this.title + '\'' + ", content='" + this.content + '\'' + ", notifyType='" + this.notifyType + '\'' + ", clickType='" + this.clickType + '\'' + ", isDiscard='" + this.isDiscard + '\'' + ", extra=" + this.extra + ", params=" + this.params + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPushMessage parsePushMessage(String pushType, String pushMessage, String packageName, String taskId) {
        MPushMessage mPushMessage;
        block13: {
            mPushMessage = new MPushMessage();
            try {
                JSONObject extraArray;
                mPushMessage.setTaskId(taskId);
                mPushMessage.setPushType(pushType);
                mPushMessage.setPackageName(packageName);
                JSONObject contentPushMessageObj = new JSONObject(pushMessage);
                JSONObject pushMessageObj = contentPushMessageObj.getJSONObject("data");
                if (!pushMessageObj.isNull("content")) {
                    mPushMessage.setContent(pushMessageObj.getString("content"));
                }
                if (!pushMessageObj.isNull("isDiscard")) {
                    mPushMessage.setIsDiscard(pushMessageObj.getString("isDiscard"));
                }
                if (!pushMessageObj.isNull("title")) {
                    mPushMessage.setTitle(pushMessageObj.getString("title"));
                }
                if (!pushMessageObj.isNull("clickType")) {
                    mPushMessage.setClickType(pushMessageObj.getString("clickType"));
                }
                if (pushMessageObj.isNull("extra") || (extraArray = pushMessageObj.getJSONObject("extra")) == null) break block13;
                if (!extraArray.isNull("parameters")) {
                    JSONObject parametersJsonObject = null;
                    try {
                        parametersJsonObject = extraArray.getJSONObject("parameters");
                    }
                    catch (JSONException e) {
                        DebugLogger.i(TAG, "parameter parse error message " + e.getMessage());
                    }
                    finally {
                        if (parametersJsonObject != null) {
                            mPushMessage.setParams(MPushMessage.getParamsMap(parametersJsonObject));
                        }
                        extraArray.remove("parameters");
                    }
                }
                Map<String, String> extraMap = MPushMessage.getParamsMap(extraArray);
                mPushMessage.setExtra(extraMap);
            }
            catch (JSONException e) {
                DebugLogger.i(TAG, "parse push message error " + e.getMessage());
            }
        }
        DebugLogger.i(TAG, " parsePushMessage " + mPushMessage);
        return mPushMessage;
    }

    private static Map<String, String> getParamsMap(JSONObject paramsJsonObject) {
        try {
            HashMap<String, String> paramsMap = new HashMap<String, String>(paramsJsonObject.length());
            Iterator extraIterator = paramsJsonObject.keys();
            while (extraIterator.hasNext()) {
                String key = (String)extraIterator.next();
                String value = paramsJsonObject.getString(key);
                paramsMap.put(key, value);
            }
            return paramsMap;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

