/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.flyme.StandardNotification;
import com.meizu.cloud.pushsdk.notification.model.styleenum.InnerStyleLayout;
import com.meizu.cloud.pushsdk.notification.util.RProxy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

public class PictureNotification
extends StandardNotification {
    private static final String TAG = "PictureNotification";

    public PictureNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void buildBigContentView(Notification notification, MessageV3 messageV3, PendingIntent closeIntent) {
        if (MinSdkChecker.isSupportNotificationBuild()) {
            Bitmap bannerBitmap = this.getBitmapFromUrl(messageV3.getNotificationStyle().getBannerImageUrl());
            if (!this.isOnMainThread() && bannerBitmap != null) {
                RemoteViews pureBannerPicView = new RemoteViews(this.context.getPackageName(), RProxy.pushPurePicNotification(this.context));
                pureBannerPicView.setImageViewBitmap(RProxy.pushPureBigViewBanner(this.context), bannerBitmap);
                pureBannerPicView.setViewVisibility(RProxy.pushPureBigViewExpanded(this.context), 8);
                pureBannerPicView.setViewVisibility(RProxy.pushPureBigViewBanner(this.context), 0);
                notification.contentView = pureBannerPicView;
                if (messageV3.getNotificationStyle().getInnerStyle() == InnerStyleLayout.EXPANDABLE_PIC.getCode()) {
                    Bitmap bigBitmap = this.getBitmapFromUrl(messageV3.getNotificationStyle().getExpandableImageUrl());
                    if (!this.isOnMainThread() && bigBitmap != null) {
                        RemoteViews pureBigPicView = new RemoteViews(this.context.getPackageName(), RProxy.pushPurePicNotification(this.context));
                        pureBigPicView.setImageViewBitmap(RProxy.pushPureBigViewExpanded(this.context), bigBitmap);
                        pureBigPicView.setViewVisibility(RProxy.pushPureBigViewExpanded(this.context), 0);
                        pureBigPicView.setViewVisibility(RProxy.pushPureBigViewBanner(this.context), 8);
                        notification.bigContentView = pureBigPicView;
                        if (messageV3.getAdvertisementOption() != null && !TextUtils.isEmpty((CharSequence)messageV3.getAdvertisementOption().getAdInstallPackage())) {
                            pureBigPicView.setViewVisibility(RProxy.pushPureClose(this.context), 0);
                            pureBigPicView.setOnClickPendingIntent(RProxy.pushPureClose(this.context), closeIntent);
                        }
                    }
                }
            }
        }
    }
}

