/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.android;

import android.app.Notification;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.AbstractPushNotification;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.model.AppIconSetting;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;

public class AndroidStandardNotification
extends AbstractPushNotification {
    public AndroidStandardNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void appIconSettingBuilder(Notification.Builder builder, MessageV3 messageV3) {
        if (MzSystemUtils.isInternational() && !MzSystemUtils.isMeizuAndFlyme()) {
            return;
        }
        AppIconSetting appIconSetting = messageV3.getAppIconSetting();
        if (appIconSetting != null) {
            if (appIconSetting.isDefaultLargeIcon()) {
                Bitmap largeIcon;
                if (this.pushNotificationBuilder != null && this.pushNotificationBuilder.getLargeIcon() != 0) {
                    largeIcon = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.pushNotificationBuilder.getLargeIcon());
                    DebugLogger.i("AbstractPushNotification", "set largeIcon by resource id");
                } else if (this.pushNotificationBuilder != null && this.pushNotificationBuilder.getAppLargeIcon() != null) {
                    largeIcon = this.pushNotificationBuilder.getAppLargeIcon();
                    DebugLogger.i("AbstractPushNotification", "set largeIcon by bitmap provided by user setting");
                } else {
                    largeIcon = this.getAppIcon(this.context, messageV3.getUploadDataPackageName());
                    DebugLogger.i("AbstractPushNotification", "set largeIcon by package default large icon");
                }
                builder.setLargeIcon(largeIcon);
            } else if (Thread.currentThread() != this.context.getMainLooper().getThread()) {
                Bitmap largeIcon = this.getBitmapFromUrl(appIconSetting.getLargeIconUrl());
                if (largeIcon != null) {
                    DebugLogger.i("AbstractPushNotification", "On other Thread down load largeIcon image success");
                    builder.setLargeIcon(largeIcon);
                } else {
                    builder.setLargeIcon(this.getAppIcon(this.context, messageV3.getUploadDataPackageName()));
                }
            }
        }
    }
}

