/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.flyme;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.flyme.StandardNotification;
import com.meizu.cloud.pushsdk.notification.util.RProxy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

public class ExpandablePicNotification
extends StandardNotification {
    private static final String TAG = "ExpandablePicNotification";

    public ExpandablePicNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void buildBigContentView(Notification notification, MessageV3 messageV3, PendingIntent closeIntent) {
        if (MinSdkChecker.isSupportNotificationBuild()) {
            RemoteViews expandedView = new RemoteViews(this.context.getPackageName(), RProxy.pushExpandableBigImageNotification(this.context));
            expandedView.setTextViewText(RProxy.pushBigNotificationTitle(this.context), (CharSequence)messageV3.getTitle());
            expandedView.setTextViewText(RProxy.pushBigNotificationContent(this.context), (CharSequence)messageV3.getContent());
            expandedView.setLong(RProxy.pushBigNotificationDate(this.context), "setTime", System.currentTimeMillis());
            this.appLargeIconSetting(expandedView, messageV3);
            this.largeExpandableImageSetting(expandedView, messageV3);
            notification.bigContentView = expandedView;
        }
    }

    private void largeExpandableImageSetting(RemoteViews expandedView, MessageV3 messageV3) {
        if (messageV3.getNotificationStyle() != null && !this.isOnMainThread()) {
            if (!TextUtils.isEmpty((CharSequence)messageV3.getNotificationStyle().getExpandableImageUrl())) {
                Bitmap bitmap = this.getBitmapFromUrl(messageV3.getNotificationStyle().getExpandableImageUrl());
                if (bitmap != null) {
                    expandedView.setViewVisibility(RProxy.pushBigBigViewDefaultView(this.context), 0);
                    expandedView.setImageViewBitmap(RProxy.pushBigBigViewDefaultView(this.context), bitmap);
                } else {
                    expandedView.setViewVisibility(RProxy.pushBigBigViewDefaultView(this.context), 8);
                }
            } else {
                expandedView.setViewVisibility(RProxy.pushBigBigViewDefaultView(this.context), 8);
            }
        }
    }
}

