/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.flyme;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.AbstractPushNotification;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.util.RProxy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

public class StandardNotification
extends AbstractPushNotification {
    public StandardNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void buildContentView(Notification notification, MessageV3 messageV3) {
        if (MinSdkChecker.isSupportNotificationBuild()) {
            RemoteViews standardView = new RemoteViews(this.context.getPackageName(), RProxy.pushExpandableBigImageNotification(this.context));
            standardView.setTextViewText(RProxy.pushBigNotificationTitle(this.context), (CharSequence)messageV3.getTitle());
            standardView.setTextViewText(RProxy.pushBigNotificationContent(this.context), (CharSequence)messageV3.getContent());
            standardView.setLong(RProxy.pushBigNotificationDate(this.context), "setTime", System.currentTimeMillis());
            this.appLargeIconSetting(standardView, messageV3);
            standardView.setViewVisibility(RProxy.pushBigBigViewDefaultView(this.context), 8);
            standardView.setViewVisibility(RProxy.pushBigBigTextDefaultView(this.context), 8);
            notification.contentView = standardView;
        }
    }

    protected void appLargeIconSetting(RemoteViews standardView, MessageV3 messageV3) {
        if (messageV3.getAppIconSetting() != null && !this.isOnMainThread()) {
            if (!messageV3.getAppIconSetting().isDefaultLargeIcon()) {
                Bitmap bitmap = this.getBitmapFromUrl(messageV3.getAppIconSetting().getLargeIconUrl());
                if (bitmap != null) {
                    standardView.setImageViewBitmap(RProxy.pushBigNotificationIcon(this.context), bitmap);
                } else {
                    standardView.setImageViewBitmap(RProxy.pushBigNotificationIcon(this.context), this.getAppIcon(this.context, messageV3.getUploadDataPackageName()));
                }
            } else {
                standardView.setImageViewBitmap(RProxy.pushBigNotificationIcon(this.context), this.getAppIcon(this.context, messageV3.getUploadDataPackageName()));
            }
        } else {
            standardView.setImageViewBitmap(RProxy.pushBigNotificationIcon(this.context), this.getAppIcon(this.context, messageV3.getUploadDataPackageName()));
        }
    }
}

