/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class AdvanceSettingEx
implements Parcelable {
    public static final String TAG = "AdvanceSettingEx";
    public static final String ADVANCE_SETTING_EX = "as";
    public static final String PRIORITY_DISPLAY = "pd";
    public static final String SOUND_TITLE = "st";
    public static final int MZ_PUSH_PRIORITY_MIN = -2;
    public static final int MZ_PUSH_PRIORITY_LOW = -1;
    public static final int MZ_PUSH_PRIORITY_DEFAULT = 0;
    public static final int MZ_PUSH_PRIORITY_HIGH = 1;
    public static final int MZ_PUSH_PRIORITY_MAX = 2;
    private int priorityDisplay = 0;
    private String soundTitle;
    public static final Parcelable.Creator<AdvanceSettingEx> CREATOR = new Parcelable.Creator<AdvanceSettingEx>(){

        public AdvanceSettingEx createFromParcel(Parcel in) {
            return new AdvanceSettingEx(in);
        }

        public AdvanceSettingEx[] newArray(int size) {
            return new AdvanceSettingEx[size];
        }
    };

    public AdvanceSettingEx() {
    }

    protected AdvanceSettingEx(Parcel in) {
        this.priorityDisplay = in.readInt();
        this.soundTitle = in.readString();
    }

    public int getPriorityDisplay() {
        return this.priorityDisplay;
    }

    public void setPriorityDisplay(int priorityDisplay) {
        if (priorityDisplay < -2 || priorityDisplay > 2) {
            priorityDisplay = 0;
        }
        this.priorityDisplay = priorityDisplay;
    }

    public String getSoundTitle() {
        return this.soundTitle;
    }

    public void setSoundTitle(String soundTitle) {
        this.soundTitle = soundTitle;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.priorityDisplay);
        dest.writeString(this.soundTitle);
    }

    public static AdvanceSettingEx parse(String setting) {
        JSONObject advanceObj = null;
        if (!TextUtils.isEmpty((CharSequence)setting)) {
            try {
                advanceObj = new JSONObject(setting);
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return AdvanceSettingEx.parse(advanceObj);
    }

    public static AdvanceSettingEx parse(JSONObject advanceObj) {
        AdvanceSettingEx advanceSettingEx = new AdvanceSettingEx();
        if (advanceObj != null) {
            try {
                if (!advanceObj.isNull(PRIORITY_DISPLAY)) {
                    advanceSettingEx.setPriorityDisplay(advanceObj.getInt(PRIORITY_DISPLAY));
                }
                if (!advanceObj.isNull(SOUND_TITLE)) {
                    advanceSettingEx.setSoundTitle(advanceObj.getString(SOUND_TITLE));
                }
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG, "no such tag AdvanceSettingEx");
        }
        return advanceSettingEx;
    }

    public String toString() {
        return "AdvanceSettingEx{, priorityDisplay=" + this.priorityDisplay + ", soundTitle=" + this.soundTitle + '}';
    }
}

