/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class AdvertisementOption
implements Parcelable {
    public static final String TAG = "AdvertisementOption";
    public static final String ADVERTISEMENT_OPTION = "ado";
    public static final String AD_PACKAGE = "ap";
    public static final String PRIORITY_VALID_TIME = "pt";
    public static final String AD_INSTALL_PACKAGE = "aip";
    private String mAdPackage;
    private int mPriorityValidTime;
    private String mAdInstallPackage;
    public static final Parcelable.Creator<AdvertisementOption> CREATOR = new Parcelable.Creator<AdvertisementOption>(){

        public AdvertisementOption createFromParcel(Parcel in) {
            return new AdvertisementOption(in);
        }

        public AdvertisementOption[] newArray(int size) {
            return new AdvertisementOption[size];
        }
    };

    public AdvertisementOption() {
    }

    protected AdvertisementOption(Parcel in) {
        this.mAdPackage = in.readString();
        this.mPriorityValidTime = in.readInt();
        this.mAdInstallPackage = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mAdPackage);
        dest.writeInt(this.mPriorityValidTime);
        dest.writeString(this.mAdInstallPackage);
    }

    public String getAdPackage() {
        return this.mAdPackage;
    }

    public void setAdPackage(String adPackage) {
        this.mAdPackage = adPackage;
    }

    public int getPriorityValidTime() {
        return this.mPriorityValidTime;
    }

    public void setPriorityValidTime(int priorityValidTime) {
        this.mPriorityValidTime = priorityValidTime;
    }

    public String getAdInstallPackage() {
        return this.mAdInstallPackage;
    }

    public void setAdInstallPackage(String adInstallPackage) {
        this.mAdInstallPackage = adInstallPackage;
    }

    public static AdvertisementOption parse(String setting) {
        JSONObject jsonObject = null;
        if (!TextUtils.isEmpty((CharSequence)setting)) {
            try {
                jsonObject = new JSONObject(setting);
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return AdvertisementOption.parse(jsonObject);
    }

    public static AdvertisementOption parse(JSONObject jsonObject) {
        AdvertisementOption advertisementOption = new AdvertisementOption();
        if (jsonObject != null) {
            try {
                if (!jsonObject.isNull(AD_PACKAGE)) {
                    advertisementOption.setAdPackage(jsonObject.getString(AD_PACKAGE));
                }
                if (!jsonObject.isNull(PRIORITY_VALID_TIME)) {
                    advertisementOption.setPriorityValidTime(jsonObject.getInt(PRIORITY_VALID_TIME));
                }
                if (!jsonObject.isNull(AD_INSTALL_PACKAGE)) {
                    advertisementOption.setAdInstallPackage(jsonObject.getString(AD_INSTALL_PACKAGE));
                }
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG, "no such tag AdvertisementOption");
        }
        return advertisementOption;
    }

    public String toString() {
        return "AdvertisementOption{mAdPackage=" + this.mAdPackage + "mPriorityValidTime=" + this.mPriorityValidTime + "mAdInstallPackage=" + this.mAdInstallPackage + '}';
    }
}

