/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import org.json.JSONException;
import org.json.JSONObject;

public class NotifyOption
implements Parcelable {
    private static final String TAG = "NotifyOption";
    private int notifyId = 0;
    private String notifyKey;
    public static final String NOTIFY_OPTION = "no";
    private static final String NOTIFY_ID = "ni";
    private static final String NOTIFY_KEY = "nk";
    public static final int NO_VALID_NOTIFY_ID = 0;
    public static final Parcelable.Creator<NotifyOption> CREATOR = new Parcelable.Creator<NotifyOption>(){

        public NotifyOption createFromParcel(Parcel in) {
            return new NotifyOption(in);
        }

        public NotifyOption[] newArray(int size) {
            return new NotifyOption[size];
        }
    };

    public NotifyOption() {
    }

    protected NotifyOption(Parcel in) {
        this.notifyId = in.readInt();
        this.notifyKey = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public int getNotifyId() {
        return this.notifyId;
    }

    public void setNotifyId(int notifyId) {
        this.notifyId = notifyId;
    }

    public String getNotifyKey() {
        return this.notifyKey;
    }

    public void setNotifyKey(String notifyKey) {
        this.notifyKey = notifyKey;
    }

    public String toString() {
        return "NotifyOption{notifyId=" + this.notifyId + ", notifyKey='" + this.notifyKey + '\'' + '}';
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.notifyId);
        dest.writeString(this.notifyKey);
    }

    public static NotifyOption parse(String setting) {
        JSONObject notifyOptionObj = null;
        if (!TextUtils.isEmpty((CharSequence)setting)) {
            try {
                notifyOptionObj = new JSONObject(setting);
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return NotifyOption.parse(notifyOptionObj);
    }

    public static NotifyOption parse(JSONObject notifyTypeObj) {
        NotifyOption notifyOption = new NotifyOption();
        if (notifyTypeObj != null) {
            try {
                if (!notifyTypeObj.isNull(NOTIFY_ID)) {
                    notifyOption.setNotifyId(notifyTypeObj.getInt(NOTIFY_ID));
                }
                if (!notifyTypeObj.isNull(NOTIFY_KEY)) {
                    notifyOption.setNotifyKey(notifyTypeObj.getString(NOTIFY_KEY));
                }
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG, "no such tag NotifyOption");
        }
        return notifyOption;
    }

    public static NotifyOption getNotifyOptionSetting(MessageV3 messageV3) {
        NotifyOption notifyOption = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)messageV3.getNotificationMessage())) {
                JSONObject jsonObject = new JSONObject(messageV3.getNotificationMessage());
                notifyOption = NotifyOption.parse(jsonObject.getJSONObject("data").getJSONObject("extra").getJSONObject(NOTIFY_OPTION));
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "parse flyme NotifyOption setting error " + e.getMessage() + " so get from notificationMessage");
            notifyOption = NotifyOption.getNotifyOptionSetting(messageV3.getNotificationMessage());
        }
        DebugLogger.i(TAG, "current notify option is " + notifyOption);
        return notifyOption;
    }

    private static NotifyOption getNotifyOptionSetting(String notificationMessage) {
        NotifyOption notifyOption = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)notificationMessage)) {
                JSONObject notificationExtraMessageJsonObj = new JSONObject(notificationMessage);
                String notifyJson = notificationExtraMessageJsonObj.getString(NOTIFY_OPTION);
                notifyOption = NotifyOption.parse(notifyJson);
            }
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "parse notificationMessage error " + e.getMessage());
        }
        return notifyOption;
    }

    public static int getNotifyId(MessageV3 messageV3) {
        int notifyId = 0;
        NotifyOption notifyOption = NotifyOption.getNotifyOptionSetting(messageV3);
        if (notifyOption != null) {
            notifyId = notifyOption.getNotifyId();
        }
        return notifyId;
    }
}

