/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class NotifyType
implements Parcelable {
    public static final String TAG = "notify_type";
    boolean vibrate;
    boolean lights;
    boolean sound;
    public static final String NOTIFY_TYPE = "nt";
    public static final String VIBRATE = "v";
    public static final String LIGHTS = "l";
    public static final String SOUND = "s";
    public static final Parcelable.Creator<NotifyType> CREATOR = new Parcelable.Creator<NotifyType>(){

        public NotifyType createFromParcel(Parcel in) {
            return new NotifyType(in);
        }

        public NotifyType[] newArray(int size) {
            return new NotifyType[size];
        }
    };

    public NotifyType() {
    }

    public NotifyType(Parcel in) {
        this.vibrate = in.readByte() != 0;
        this.lights = in.readByte() != 0;
        this.sound = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeByte((byte)(this.vibrate ? 1 : 0));
        parcel.writeByte((byte)(this.lights ? 1 : 0));
        parcel.writeByte((byte)(this.sound ? 1 : 0));
    }

    public boolean isVibrate() {
        return this.vibrate;
    }

    public void setVibrate(boolean vibrate) {
        this.vibrate = vibrate;
    }

    public boolean isLights() {
        return this.lights;
    }

    public void setLights(boolean lights) {
        this.lights = lights;
    }

    public boolean isSound() {
        return this.sound;
    }

    public void setSound(boolean sound) {
        this.sound = sound;
    }

    public static NotifyType parse(String setting) {
        JSONObject notificationObj = null;
        if (!TextUtils.isEmpty((CharSequence)setting)) {
            try {
                notificationObj = new JSONObject(setting);
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return NotifyType.parse(notificationObj);
    }

    public static NotifyType parse(JSONObject notifyTypeObj) {
        NotifyType notifyType = new NotifyType();
        if (notifyTypeObj != null) {
            try {
                if (!notifyTypeObj.isNull(VIBRATE)) {
                    notifyType.setVibrate(notifyTypeObj.getInt(VIBRATE) != 0);
                }
                if (!notifyTypeObj.isNull(LIGHTS)) {
                    notifyType.setLights(notifyTypeObj.getInt(LIGHTS) != 0);
                }
                if (!notifyTypeObj.isNull(SOUND)) {
                    notifyType.setSound(notifyTypeObj.getInt(SOUND) != 0);
                }
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG, "no such tag notify_type");
        }
        return notifyType;
    }

    public String toString() {
        return "NotifyType{vibrate=" + this.vibrate + ", lights=" + this.lights + ", sound=" + this.sound + '}';
    }
}

