/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.util;

import com.meizu.cloud.pushinternal.DebugLogger;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.DecimalFormat;

public class FileUtil {
    private static final String TAG = "FileUtil";
    private static final int B_SIZE = 1024;
    private static final int KB_SIZE = 0x100000;
    private static final int MB_SIZE = 0x40000000;

    public static void copyFile(String oldPath, String newPath) {
        try {
            int byteSum = 0;
            File oldFile = new File(oldPath);
            if (!oldFile.exists()) {
                int byteRead;
                FileInputStream inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteRead = ((InputStream)inStream).read(buffer)) != -1) {
                    byteSum += byteRead;
                    fs.write(buffer, 0, byteRead);
                }
                ((InputStream)inStream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFolder(String oldPath, String newPath) {
        try {
            String[] file;
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            for (String s : file = a.list()) {
                File temp = oldPath.endsWith(File.separator) ? new File(oldPath + s) : new File(oldPath + File.separator + s);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(newPath + "/" + temp.getName());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                    continue;
                }
                if (!temp.isDirectory()) continue;
                FileUtil.copyFolder(oldPath + "/" + s, newPath + "/" + s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static File[] listFile(String dir, final String filter) {
        File directory = new File(dir);
        File[] files = new File[]{};
        if (directory.isDirectory()) {
            files = directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String timestamp = file.getName().split("-")[1];
                    boolean flag = true;
                    try {
                        flag = Long.valueOf(filter) > Long.valueOf(timestamp);
                    }
                    catch (Exception e) {
                        DebugLogger.e(FileUtil.TAG, "filters file error " + e.getMessage());
                    }
                    return flag;
                }
            });
        }
        return files;
    }

    public static boolean deleteDirectory(String filePath) {
        File[] files;
        File dirFile;
        if (!filePath.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        if (!(dirFile = new File(filePath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        for (File file : files = dirFile.listFiles()) {
            if (file.isFile() ? !(flag = FileUtil.deleteFile(file.getAbsolutePath())) : !(flag = FileUtil.deleteDirectory(file.getAbsolutePath()))) break;
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static long getDirSize(File dir) {
        File[] files;
        if (dir == null) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return 0L;
        }
        long dirSize = 0L;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                dirSize += file.length();
                continue;
            }
            if (!file.isDirectory()) continue;
            dirSize += file.length();
            dirSize += FileUtil.getDirSize(file);
        }
        return dirSize;
    }

    public static String formatFileSize(long fileSize) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = fileSize < 1024L ? df.format((double)fileSize) + "B" : (fileSize < 0x100000L ? df.format((double)fileSize / 1024.0) + "KB" : (fileSize < 0x40000000L ? df.format((double)fileSize / 1048576.0) + "MB" : df.format((double)fileSize / 1.073741824E9) + "G"));
        return fileSizeString;
    }
}

