/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.util;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.media.RingtoneManager;
import android.net.Uri;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NotificationUtils {
    private static final String TAG = "NotificationUtils";
    private static Field mFlymeNotification = null;
    private static Field mInternalApp = null;
    private static Field mReplyIntent;
    private static final Object LOCK;
    private static final Map<String, Set<String>> NOTIFICATION_ID_MAP;
    private static Map<String, Uri> sRingToneMap;

    public static void setReplyIntent(Notification notification, PendingIntent pendingIntent) {
        if (mReplyIntent != null) {
            try {
                mReplyIntent.set(notification, pendingIntent);
            }
            catch (IllegalAccessException e) {
                DebugLogger.e(TAG, "setReplyIntent error " + e.getMessage());
            }
        }
    }

    public static void setInternalApp(Notification notification, boolean internalApp) {
        if (mFlymeNotification != null && mInternalApp != null) {
            try {
                Object flymeNotification = mFlymeNotification.get(notification);
                mInternalApp.set(flymeNotification, internalApp ? 1 : 0);
            }
            catch (IllegalAccessException e) {
                DebugLogger.e(TAG, "setInternalApp error " + e.getMessage());
            }
        }
    }

    public static void clearNotification(Context context, String packageName, int notifyId) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager != null) {
            DebugLogger.i(TAG, "clear clearNotification notifyId " + notifyId);
            notificationManager.cancel(notifyId);
            Set<String> notifySet = NOTIFICATION_ID_MAP.get(packageName);
            if (notifySet != null) {
                notifySet.remove(String.valueOf(notifyId));
            }
        }
    }

    public static void clearAllNotification(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager != null) {
            notificationManager.cancelAll();
        }
    }

    public static void clearNotification(Context context, String packageName) {
        Set<String> notifySet;
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager != null && !TextUtils.isEmpty((CharSequence)packageName) && (notifySet = NOTIFICATION_ID_MAP.get(packageName)) != null) {
            for (String notifyId : notifySet) {
                DebugLogger.i(TAG, "clear notifyId " + notifyId + " notification");
                notificationManager.cancel(Integer.parseInt(notifyId));
            }
            notifySet.clear();
        }
    }

    public static void storeNotifyIdByPackageName(Context context, String packageName, int notifyId) {
        Set<String> notifySet = NOTIFICATION_ID_MAP.get(packageName);
        DebugLogger.i(TAG, "store notifyId " + notifyId);
        if (notifySet == null) {
            notifySet = new HashSet<String>();
            notifySet.add(String.valueOf(notifyId));
            NOTIFICATION_ID_MAP.put(packageName, notifySet);
        } else {
            notifySet.add(String.valueOf(notifyId));
        }
    }

    public static void removeNotifyIdByPackageName(Context context, String packageName, int notifyId) {
        Set<String> notifySet = NOTIFICATION_ID_MAP.get(packageName);
        if (notifySet != null) {
            notifySet.remove(String.valueOf(notifyId));
            DebugLogger.i(TAG, "remove notifyId " + notifyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeNotifyKey(Context context, String packageName, String notifyKey) {
        Object object = LOCK;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)notifyKey)) {
                return false;
            }
            int notifyId = PushPreferencesUtils.getNotifyIdByNotifyKey(context, packageName, notifyKey);
            DebugLogger.e(TAG, "removeNotifyKey " + notifyKey + " notifyId " + notifyId);
            NotificationUtils.removeNotifyIdByPackageName(context, packageName, notifyId);
            return PushPreferencesUtils.removeNotifyKey(context, packageName, notifyKey);
        }
    }

    public static Uri getRingtoneInfo(Context context, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)title)) {
            return null;
        }
        if (RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)2) == null) {
            return null;
        }
        if (sRingToneMap == null) {
            NotificationUtils.initRingtoneInfo(context);
        }
        if (sRingToneMap == null || sRingToneMap.size() == 0) {
            return null;
        }
        return sRingToneMap.get(title.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initRingtoneInfo(Context context) {
        if (sRingToneMap != null) {
            return;
        }
        try (Cursor cursor = null;){
            RingtoneManager manager = new RingtoneManager(context);
            manager.setType(2);
            cursor = manager.getCursor();
            if (cursor == null) {
                return;
            }
            sRingToneMap = new HashMap<String, Uri>(cursor.getCount());
            boolean cursorExist = cursor.moveToFirst();
            while (cursorExist) {
                String key = cursor.getString(1);
                Uri value = ContentUris.withAppendedId((Uri)Uri.parse((String)cursor.getString(2)), (long)cursor.getLong(0));
                if (!TextUtils.isEmpty((CharSequence)key) && value != null) {
                    sRingToneMap.put(key.toLowerCase(), value);
                }
                cursorExist = cursor.moveToNext();
            }
        }
    }

    static {
        LOCK = new Object();
        NOTIFICATION_ID_MAP = new ConcurrentHashMap<String, Set<String>>();
        try {
            mFlymeNotification = Notification.class.getDeclaredField("mFlymeNotification");
            Class<?> notificationExt = Class.forName("android.app.NotificationExt");
            mInternalApp = notificationExt.getDeclaredField("internalApp");
            mInternalApp.setAccessible(true);
            mReplyIntent = Notification.class.getDeclaredField("replyIntent");
            mReplyIntent.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            DebugLogger.e(TAG, "init NotificationUtils error " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

