/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.util;

import android.os.SystemClock;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.notification.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipExtractTask {
    private static final String LOG_TAG = "ZipExtractTask";
    private final File mInput;
    private final File mOutput;
    private final String mOutputDir;

    public ZipExtractTask(String inFile, String outputDir) {
        this.mInput = new File(inFile);
        this.mOutput = new File(outputDir);
        this.mOutputDir = this.mOutput.getAbsolutePath();
        DebugLogger.i(LOG_TAG, "Extract mInput file = " + this.mInput.toString());
        DebugLogger.i(LOG_TAG, "Extract mOutput file = " + this.mOutput.toString());
    }

    private void deleteZipFile() {
        if (this.mInput != null && this.mInput.exists()) {
            if (this.mInput.delete()) {
                DebugLogger.i(LOG_TAG, "Delete file:" + this.mInput.toString() + " after extracted.");
            } else {
                DebugLogger.i(LOG_TAG, "Can't delete file:" + this.mInput.toString() + " after extracted.");
            }
        }
    }

    public boolean doUnzipSync() {
        long extractedSize = this.unzip();
        return extractedSize > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long unzip() {
        long start = SystemClock.currentThreadTimeMillis();
        long extractedSize = 0L;
        boolean deleteTempDir = false;
        ZipFile zip = null;
        String zipDirName = null;
        try {
            zip = new ZipFile(this.mInput);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String fileName = entry.getName();
                if (fileName != null && fileName.contains("../")) {
                    throw new Exception("Unsafe zip file");
                }
                if (zipDirName == null && fileName != null) {
                    zipDirName = fileName.split("/")[0];
                    DebugLogger.i(LOG_TAG, "Extract temp directory=" + this.mOutput + "/" + zipDirName);
                }
                if (fileName == null) continue;
                File destination = new File(this.mOutput, fileName);
                if (!destination.getParentFile().exists()) {
                    if (destination.getParentFile().mkdirs()) {
                        DebugLogger.i(LOG_TAG, "Make Destination directory=" + destination.getParentFile().getAbsolutePath());
                    } else {
                        DebugLogger.i(LOG_TAG, "Can't make destination directory=" + destination.getParentFile().getAbsolutePath());
                    }
                }
                FileOutputStream outStream = new FileOutputStream(destination);
                extractedSize += (long)this.copy(zip.getInputStream(entry), outStream);
                outStream.close();
            }
            String tempDir = this.mOutput + "/" + zipDirName;
            if (!this.mOutputDir.equals(tempDir)) {
                FileUtil.copyFolder(tempDir, this.mOutputDir);
                deleteTempDir = true;
            }
        }
        catch (ZipException e) {
            DebugLogger.e(LOG_TAG, "ZipException :" + e.toString());
        }
        catch (IOException e) {
            DebugLogger.e(LOG_TAG, "Extracted IOException:" + e.toString());
        }
        catch (Exception e) {
            DebugLogger.e(LOG_TAG, "Extracted Exception " + e.toString());
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {
                DebugLogger.e(LOG_TAG, "Extracted IOException:" + e.toString());
            }
        }
        long end = SystemClock.currentThreadTimeMillis();
        DebugLogger.i(LOG_TAG, "Extract file " + this.mInput + ", UseTime =" + (end - start));
        if (deleteTempDir) {
            FileUtil.deleteDirectory(this.mOutput + "/" + zipDirName);
        }
        this.deleteZipFile();
        return extractedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copy(InputStream input, OutputStream output) {
        byte[] buffer = new byte[8192];
        BufferedInputStream in = new BufferedInputStream(input, 8192);
        BufferedOutputStream out = new BufferedOutputStream(output, 8192);
        int count = 0;
        try {
            int n;
            while ((n = in.read(buffer, 0, 8192)) != -1) {
                out.write(buffer, 0, n);
                count += n;
            }
            out.flush();
        }
        catch (IOException e) {
            DebugLogger.e(LOG_TAG, "Extracted IOException:" + e.toString());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                DebugLogger.e(LOG_TAG, "out.close() IOException e=" + e.toString());
            }
            try {
                in.close();
            }
            catch (IOException e) {
                DebugLogger.e(LOG_TAG, "in.close() IOException e=" + e.toString());
            }
        }
        return count;
    }
}

