/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.PullUpPush;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.impl.model.PlatformMessage;
import com.meizu.cloud.pushsdk.platform.message.BasicPushStatus;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.StatusSerialize;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.UxIPUtils;
import java.io.Serializable;
import java.util.List;

public class PlatformMessageSender {
    private static final String TAG = "PlatformMessageSender";
    private static final int PUSH_SUPPORT_SWITCH_SETTING_VERSION_START = 6;

    public static void sendPushStatus(Context context, String packageName, final PushSwitchStatus pushSwitchStatus) {
        PlatformMessageSender.sendPlatformStatus(context, packageName, new OnUpdateIntent(){

            @Override
            public String getMethod() {
                return "push_status";
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return pushSwitchStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return "extra_app_push_switch_status";
            }

            @Override
            public String getMessageValue() {
                return StatusSerialize.pushSwitchStatusToString(pushSwitchStatus);
            }
        });
    }

    public static void sendRegisterStatus(Context context, String packageName, final RegisterStatus registerStatus) {
        PlatformMessageSender.sendPlatformStatus(context, packageName, new OnUpdateIntent(){

            @Override
            public String getMethod() {
                return "register_status";
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return registerStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return "extra_app_push_register_status";
            }

            @Override
            public String getMessageValue() {
                return StatusSerialize.registerStatusToString(registerStatus);
            }
        });
    }

    public static void sendUnRegisterStatus(Context context, String packageName, final UnRegisterStatus unRegisterStatus) {
        PlatformMessageSender.sendPlatformStatus(context, packageName, new OnUpdateIntent(){

            @Override
            public String getMethod() {
                return "un_register_status";
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return unRegisterStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return "extra_app_push_un_register_status";
            }

            @Override
            public String getMessageValue() {
                return StatusSerialize.unregisterStatusToString(unRegisterStatus);
            }
        });
    }

    public static void sendSubTags(Context context, String packageName, final SubTagsStatus subTagsStatus) {
        PlatformMessageSender.sendPlatformStatus(context, packageName, new OnUpdateIntent(){

            @Override
            public String getMethod() {
                return "sub_tags_status";
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return subTagsStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return "extra_app_push_sub_tags_status";
            }

            @Override
            public String getMessageValue() {
                return StatusSerialize.subTagsStatusToString(subTagsStatus);
            }
        });
    }

    public static void sendSubAlias(Context context, String packageName, final SubAliasStatus subAliasStatus) {
        PlatformMessageSender.sendPlatformStatus(context, packageName, new OnUpdateIntent(){

            @Override
            public String getMethod() {
                return "sub_alias_status";
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return subAliasStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return "extra_app_push_sub_alias_status";
            }

            @Override
            public String getMessageValue() {
                return StatusSerialize.subAliasStatusToString(subAliasStatus);
            }
        });
    }

    private static void sendPlatformStatus(Context context, String packageName, OnUpdateIntent onUpdateIntent) {
        Intent intent = new Intent();
        intent.addCategory(packageName);
        intent.setPackage(packageName);
        intent.putExtra("method", onUpdateIntent.getMethod());
        if (MinSdkChecker.isSupportTransmitMessageValue(context, packageName)) {
            intent.putExtra("messageValue", onUpdateIntent.getMessageValue());
        } else {
            intent.putExtra(onUpdateIntent.getBasicStatusExtra(), (Serializable)onUpdateIntent.getBasicStatus());
        }
        MzSystemUtils.sendMessageFromBroadcast(context, intent, "com.meizu.flyme.push.intent.MESSAGE", packageName);
        PullUpPush.pushServiceStart(context);
    }

    public static void switchPushMessageSetting(Context context, int switchType, boolean switcher, String desPackageName) {
        String cloudVersionName = MzSystemUtils.getAppVersionName(context, "com.meizu.cloud");
        DebugLogger.i(TAG, context.getPackageName() + " switchPushMessageSetting cloudVersion_name " + cloudVersionName);
        if (!TextUtils.isEmpty((CharSequence)cloudVersionName) && Integer.parseInt(cloudVersionName.substring(0, 1)) >= 6) {
            Intent pushServiceIntent = new Intent("com.meizu.flyme.push.intent.MESSAGE_SWITCH");
            pushServiceIntent.putExtra("extra_app_push_switch_setting_type", switchType);
            pushServiceIntent.putExtra("extra_app_push_switch_setting_status", switcher);
            pushServiceIntent.putExtra("extra_app_push_switch_package_name", desPackageName);
            pushServiceIntent.setClassName("com.meizu.cloud", "com.meizu.cloud.pushsdk.pushservice.MzPushService");
            try {
                context.startService(pushServiceIntent);
            }
            catch (Exception e) {
                DebugLogger.e(TAG, "start switch push message setting service error " + e.getMessage());
            }
        }
    }

    public static void launchStartActivity(Context context, String packageName, String pushMessage, String platformExtra) {
        PlatformMessage platformMessage = UxIPUtils.buildPlatformMessage(platformExtra);
        MessageV3 messageV3 = MessageV3.parse(packageName, packageName, platformMessage.getPushTimesTamp(), platformMessage.getDeviceId(), platformMessage.getTaskId(), platformMessage.getSeqId(), pushMessage);
        Intent serviceClickIntent = new Intent();
        serviceClickIntent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        serviceClickIntent.putExtra("pushMessage", (Parcelable)messageV3);
        serviceClickIntent.putExtra("method", "private");
        serviceClickIntent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            serviceClickIntent.setPackage(packageName);
            serviceClickIntent.setClassName(packageName, "com.meizu.cloud.pushsdk.NotificationService");
        }
        serviceClickIntent.putExtra("command_type", "reflect_receiver");
        DebugLogger.i(TAG, "start notification service " + messageV3);
        try {
            context.startService(serviceClickIntent);
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "launchStartActivity error " + e.getMessage());
        }
    }

    public static void showQuickNotification(Context context, String pushMessage, String platformExtra) {
        PlatformMessage platformMessage = UxIPUtils.buildPlatformMessage(platformExtra);
        Intent intent = new Intent();
        intent.putExtra("extra_app_push_seq_Id", platformMessage.getSeqId());
        intent.putExtra("extra_app_push_task_Id", platformMessage.getTaskId());
        intent.putExtra("extra_app_push_task_timestamp", platformMessage.getPushTimesTamp());
        intent.putExtra("extra_app_push_service_default_package_name", context.getPackageName());
        intent.putExtra("pushMessage", pushMessage);
        intent.putExtra("statistics_imei_key", platformMessage.getDeviceId());
        intent.putExtra("method", "notification_show_v3");
        intent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        intent.setClassName(context.getPackageName(), "com.meizu.cloud.pushsdk.NotificationService");
        intent.putExtra("command_type", "reflect_receiver");
        try {
            DebugLogger.e(TAG, "start notification service to show notification");
            context.startService(intent);
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "showNotification error " + e.getMessage());
        }
    }

    public static void changePreference(Context context, String preferenceName, String key, String value) {
        try {
            Intent intent = new Intent();
            intent.setPackage(PlatformMessageSender.findService(context, "com.meizu.flyme.push.intent.CHANGE_PREFERENCE"));
            intent.setAction("com.meizu.flyme.push.intent.CHANGE_PREFERENCE");
            intent.putExtra("push_preference", preferenceName);
            intent.putExtra("push_preference_key", key);
            intent.putExtra("push_preference_value", value);
            intent.putExtra("push_preference_value_type", 0);
            context.startService(intent);
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "start RemoteService error " + e.getMessage());
        }
    }

    protected static String findService(Context paramContext, String action) {
        String componentName = null;
        String servicePackageName = null;
        if (!TextUtils.isEmpty((CharSequence)action)) {
            Intent localIntent = new Intent(action);
            List localList = paramContext.getPackageManager().queryIntentServices(localIntent, 0);
            if (localList != null) {
                for (ResolveInfo info : localList) {
                    if (!"com.meizu.cloud".equals(info.serviceInfo.packageName)) continue;
                    servicePackageName = info.serviceInfo.packageName;
                    componentName = info.serviceInfo.name;
                    break;
                }
                if (TextUtils.isEmpty(componentName) && localList.size() > 0) {
                    servicePackageName = ((ResolveInfo)localList.get((int)0)).serviceInfo.packageName;
                }
            }
        }
        DebugLogger.i(TAG, "current process packageName " + servicePackageName);
        return servicePackageName;
    }

    private static interface OnUpdateIntent {
        public String getMethod();

        public BasicPushStatus getBasicStatus();

        public String getBasicStatusExtra();

        public String getMessageValue();
    }
}

