/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.api;

import android.content.Context;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.AndroidNetworking;
import com.meizu.cloud.pushsdk.networking.common.ANRequest;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndStringRequestListener;
import com.meizu.cloud.pushsdk.platform.SignUtils;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import java.io.File;
import java.util.LinkedHashMap;

public class PushAPI {
    private static final String TAG = "PushAPI";
    private static final String API_PATH = "/garcia/api/client/";
    private static final String MESSAGE_REGISTER_PUSH = "message/registerPush";
    private static final String MESSAGE_UNREGISTER_PUSH = "message/unRegisterPush";
    private static final String ADVANCE_UNREGISTER_PUSH = "advance/unRegisterPush";
    private static final String MESSAGE_GET_REGISTER_SWITCH = "message/getRegisterSwitch";
    private static final String MESSAGE_CHANGE_REGISTER_SWITCH = "message/changeRegisterSwitch";
    private static final String MESSAGE_CHANGE_ALL_SWITCH = "message/changeAllSwitch";
    private static final String MESSAGE_SUBSCRIBE_TAGS = "message/subscribeTags";
    private static final String MESSAGE_UN_SUBSCRIBE_TAGS = "message/unSubscribeTags";
    private static final String MESSAGE_UN_SUB_ALL_TAGS = "message/unSubAllTags";
    private static final String MESSAGE_GET_SUB_TAGS = "message/getSubTags";
    private static final String MESSAGE_SUBSCRIBE_ALIAS = "message/subscribeAlias";
    private static final String MESSAGE_UN_SUBSCRIBE_ALIAS = "message/unSubscribeAlias";
    private static final String MESSAGE_GET_SUB_ALIAS = "message/getSubAlias";
    private static final String ADVANCE_CHANGE_REGISTER_SWITCH = "advance/changeRegisterSwitch";
    private static final String UPLOAD_LOG_FILE_URL_PRIX = "https://api-push.meizu.com/garcia/api/client/log/upload";
    private String mApiServer = "https://api-push.meizu.com/garcia/api/client/";
    private String mRegisterUrlPrix = this.mApiServer + "message/registerPush";
    private String mUnregisterUrlPrix = this.mApiServer + "message/unRegisterPush";
    private String mUnregisterUrlAdvancePrix = this.mApiServer + "advance/unRegisterPush";
    private String mCheckRegisterSwitchStatusUrlPrix = this.mApiServer + "message/getRegisterSwitch";
    private String mChangeRegisterSwitchStatusUrlPrix = this.mApiServer + "message/changeRegisterSwitch";
    private String mChangeAllSwitchStatusUrlPrix = this.mApiServer + "message/changeAllSwitch";
    private String mSubscribeTagsUrlPrix = this.mApiServer + "message/subscribeTags";
    private String mUnsubscribeTagsUrlPrix = this.mApiServer + "message/unSubscribeTags";
    private String mUnsubscribeAllTagsUrlPrix = this.mApiServer + "message/unSubAllTags";
    private String mCheckSubscribeTagsUrlPrix = this.mApiServer + "message/getSubTags";
    private String mSubscribeAliasUrlPrix = this.mApiServer + "message/subscribeAlias";
    private String mUnsubscribeAliasUrlPrix = this.mApiServer + "message/unSubscribeAlias";
    private String mCheckSubscribeAliasUrlPrix = this.mApiServer + "message/getSubAlias";
    private String mChangeNotificationSwitchUrlPrix = this.mApiServer + "advance/changeRegisterSwitch";

    public PushAPI(Context mContext) {
        AndroidNetworking.enableLogging();
        if (MzSystemUtils.isOverseas()) {
            this.mApiServer = "https://api-push.in.meizu.com/garcia/api/client/";
            this.mRegisterUrlPrix = this.mApiServer + MESSAGE_REGISTER_PUSH;
            this.mUnregisterUrlPrix = this.mApiServer + MESSAGE_UNREGISTER_PUSH;
            this.mUnregisterUrlAdvancePrix = this.mApiServer + ADVANCE_UNREGISTER_PUSH;
            this.mCheckRegisterSwitchStatusUrlPrix = this.mApiServer + MESSAGE_GET_REGISTER_SWITCH;
            this.mChangeRegisterSwitchStatusUrlPrix = this.mApiServer + MESSAGE_CHANGE_REGISTER_SWITCH;
            this.mChangeAllSwitchStatusUrlPrix = this.mApiServer + MESSAGE_CHANGE_ALL_SWITCH;
            this.mSubscribeTagsUrlPrix = this.mApiServer + MESSAGE_SUBSCRIBE_TAGS;
            this.mUnsubscribeTagsUrlPrix = this.mApiServer + MESSAGE_UN_SUBSCRIBE_TAGS;
            this.mUnsubscribeAllTagsUrlPrix = this.mApiServer + MESSAGE_UN_SUB_ALL_TAGS;
            this.mCheckSubscribeTagsUrlPrix = this.mApiServer + MESSAGE_GET_SUB_TAGS;
            this.mSubscribeAliasUrlPrix = this.mApiServer + MESSAGE_SUBSCRIBE_ALIAS;
            this.mUnsubscribeAliasUrlPrix = this.mApiServer + MESSAGE_UN_SUBSCRIBE_ALIAS;
            this.mCheckSubscribeAliasUrlPrix = this.mApiServer + MESSAGE_GET_SUB_ALIAS;
            this.mChangeNotificationSwitchUrlPrix = this.mApiServer + ADVANCE_CHANGE_REGISTER_SWITCH;
        }
    }

    public void register(String appId, String appKey, String deviceId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("deviceId", deviceId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "register post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mRegisterUrlPrix).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse register(String appId, String appKey, String deviceId) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("deviceId", deviceId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "register post map " + requestMap);
        return ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mRegisterUrlPrix).addBodyParameter(requestMap)).build().executeForString();
    }

    public void unRegister(String appId, String appKey, String deviceId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("deviceId", deviceId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "unregister post map " + requestMap);
        ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.mUnregisterUrlPrix).addQueryParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse unRegister(String appId, String appKey, String deviceId) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("deviceId", deviceId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "unregister post map " + requestMap);
        return ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.mUnregisterUrlPrix).addQueryParameter(requestMap)).build().executeForString();
    }

    public ANResponse unRegister(String packageName, String deviceId) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("packageName", packageName);
        paramsMap.put("deviceId", deviceId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, "4a2ca769d79f4856bb3bd982d30de790"));
        DebugLogger.i(TAG, "advance unregister post map " + requestMap);
        return ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mUnregisterUrlAdvancePrix).addBodyParameter(requestMap)).build().executeForString();
    }

    public ANResponse changeNotificationSwitch(String packageName, String deviceId, int subSwitch) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("packageName", packageName);
        paramsMap.put("deviceId", deviceId);
        paramsMap.put("subSwitch", String.valueOf(subSwitch));
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, "4a2ca769d79f4856bb3bd982d30de790"));
        DebugLogger.i(TAG, "advance change notification switch post map " + requestMap);
        return ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mChangeNotificationSwitchUrlPrix).addBodyParameter(requestMap)).build().executeForString();
    }

    public void checkPush(String appId, String appKey, String pushId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.mCheckRegisterSwitchStatusUrlPrix).addQueryParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse checkPush(String appId, String appKey, String pushId) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        return ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.mCheckRegisterSwitchStatusUrlPrix).addQueryParameter(requestMap)).build().executeForString();
    }

    public void switchPush(String appId, String appKey, String pushId, int msgType, boolean switcher, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("msgType", String.valueOf(msgType));
        paramsMap.put("subSwitch", switcher ? "1" : "0");
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, this.mChangeRegisterSwitchStatusUrlPrix + " switchPush post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mChangeRegisterSwitchStatusUrlPrix).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse switchPush(String appId, String appKey, String pushId, int msgType, boolean switcher) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("msgType", String.valueOf(msgType));
        paramsMap.put("subSwitch", switcher ? "1" : "0");
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, this.mChangeRegisterSwitchStatusUrlPrix + " switchPush post map " + requestMap);
        return ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mChangeRegisterSwitchStatusUrlPrix).addBodyParameter(requestMap)).build().executeForString();
    }

    public void switchPush(String appId, String appKey, String pushId, boolean switcher, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("subSwitch", switcher ? "1" : "0");
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, this.mChangeAllSwitchStatusUrlPrix + " switchPush post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mChangeAllSwitchStatusUrlPrix).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse switchPush(String appId, String appKey, String pushId, boolean switcher) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("subSwitch", switcher ? "1" : "0");
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, this.mChangeAllSwitchStatusUrlPrix + " switchPush post map " + requestMap);
        return ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mChangeAllSwitchStatusUrlPrix).addBodyParameter(requestMap)).build().executeForString();
    }

    public void subScribeTags(String appId, String appKey, String pushId, String args, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mSubscribeTagsUrlPrix).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse subScribeTags(String appId, String appKey, String pushId, String args) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        return ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mSubscribeTagsUrlPrix).addBodyParameter(requestMap)).build().executeForString();
    }

    public void unSubScribeTags(String appId, String appKey, String pushId, String args, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mUnsubscribeTagsUrlPrix).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse unSubScribeTags(String appId, String appKey, String pushId, String args) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        return ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mUnsubscribeTagsUrlPrix).addBodyParameter(requestMap)).build().executeForString();
    }

    public void unSubAllScribeTags(String appId, String appKey, String pushId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeAllTags post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mUnsubscribeAllTagsUrlPrix).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse unSubAllScribeTags(String appId, String appKey, String pushId) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeAllTags post map " + requestMap);
        return ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mUnsubscribeAllTagsUrlPrix).addBodyParameter(requestMap)).build().executeForString();
    }

    public void checkSubScribeTags(String appId, String appKey, String pushId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.mCheckSubscribeTagsUrlPrix).addQueryParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse checkSubScribeTags(String appId, String appKey, String pushId) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        return ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.mCheckSubscribeTagsUrlPrix).addQueryParameter(requestMap)).build().executeForString();
    }

    public void subScribeAlias(String appId, String appKey, String pushId, String alias, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("appKey", appKey);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mSubscribeAliasUrlPrix).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse subScribeAlias(String appId, String appKey, String pushId, String alias) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("appKey", appKey);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        return ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mSubscribeAliasUrlPrix).addBodyParameter(requestMap)).build().executeForString();
    }

    public void unSubScribeAlias(String appId, String appKey, String pushId, String alias, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mUnsubscribeAliasUrlPrix).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse unSubScribeAlias(String appId, String appKey, String pushId, String alias) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        return ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.mUnsubscribeAliasUrlPrix).addBodyParameter(requestMap)).build().executeForString();
    }

    public void checkSubScribeAlias(String appId, String appKey, String pushId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.mCheckSubscribeAliasUrlPrix).addQueryParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public ANResponse checkSubScribeAlias(String appId, String appKey, String pushId) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        return ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.mCheckSubscribeAliasUrlPrix).addQueryParameter(requestMap)).build().executeForString();
    }

    public ANResponse<String> uploadLogFile(String messageId, String deviceId, String errorMsg, File logFile) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("msgId", messageId);
        paramsMap.put("deviceId", deviceId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, "4a2ca769d79f4856bb3bd982d30de790"));
        if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
            requestMap.put("errorMsg", errorMsg);
        }
        DebugLogger.i(TAG, "uploadLogFile post map " + requestMap);
        ANRequest anRequest = ((ANRequest.MultiPartBuilder)((ANRequest.MultiPartBuilder)AndroidNetworking.upload(UPLOAD_LOG_FILE_URL_PRIX).addMultipartParameter(requestMap)).addMultipartFile("logFile", logFile)).build();
        return anRequest.executeForString();
    }
}

