/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.api;

import android.content.Context;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.StrategyMessage;
import com.meizu.cloud.pushsdk.platform.pushstrategy.NotificationClearStrategy;
import com.meizu.cloud.pushsdk.platform.pushstrategy.RegisterStatusStrategy;
import com.meizu.cloud.pushsdk.platform.pushstrategy.SubScribeAliasStrategy;
import com.meizu.cloud.pushsdk.platform.pushstrategy.SubScribeTagStrategy;
import com.meizu.cloud.pushsdk.platform.pushstrategy.SwitchStatusStrategy;
import com.meizu.cloud.pushsdk.platform.pushstrategy.UnRegisterStatusStrategy;
import com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Executor;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;

public class PushPlatformManager {
    private static final String TAG = "PushPlatformManager";
    private static PushPlatformManager mInstance;
    private ScheduledExecutorService mExecutorService;
    private final Context mContext;
    private final PushAPI mPushApi;
    private final RegisterStatusStrategy mRegisterStatusStrategy;
    private final UnRegisterStatusStrategy mUnRegisterStatusStrategy;
    private final SwitchStatusStrategy mSwitchStatusStrategy;
    private final SubScribeTagStrategy mSubScribeTagStrategy;
    private final SubScribeAliasStrategy mSubScribeAliasStrategy;
    private final boolean mEnableRpc;

    public PushPlatformManager(Context context, boolean isAsync) {
        this(context, isAsync, true);
    }

    public PushPlatformManager(Context context, boolean isAsync, boolean enableRpc) {
        this.mContext = context.getApplicationContext();
        this.mPushApi = new PushAPI(this.mContext);
        if (isAsync) {
            this.mExecutorService = (ScheduledExecutorService)Executor.getExecutor();
        }
        this.mEnableRpc = enableRpc;
        this.mRegisterStatusStrategy = new RegisterStatusStrategy(this.mContext, this.mPushApi, this.mExecutorService, enableRpc);
        this.mUnRegisterStatusStrategy = new UnRegisterStatusStrategy(this.mContext, this.mPushApi, this.mExecutorService, enableRpc);
        this.mSwitchStatusStrategy = new SwitchStatusStrategy(this.mContext, this.mPushApi, this.mExecutorService, enableRpc);
        this.mSubScribeTagStrategy = new SubScribeTagStrategy(this.mContext, this.mPushApi, this.mExecutorService, enableRpc);
        this.mSubScribeAliasStrategy = new SubScribeAliasStrategy(this.mContext, this.mPushApi, this.mExecutorService, enableRpc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushPlatformManager getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<PushPlatformManager> clazz = PushPlatformManager.class;
        synchronized (PushPlatformManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PushPlatformManager(context, true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public void enableRemoteInvoker(boolean isRemoteInvoker) {
        this.mRegisterStatusStrategy.setSupportRemoteInvoke(isRemoteInvoker);
        this.mUnRegisterStatusStrategy.setSupportRemoteInvoke(isRemoteInvoker);
        this.mSwitchStatusStrategy.setSupportRemoteInvoke(isRemoteInvoker);
        this.mSubScribeAliasStrategy.setSupportRemoteInvoke(isRemoteInvoker);
        this.mSubScribeTagStrategy.setSupportRemoteInvoke(isRemoteInvoker);
    }

    public boolean dispatcherStrategyMessage(StrategyMessage strategyMessage) {
        boolean flag = true;
        if (strategyMessage != null) {
            int strategyType = strategyMessage.getStrategyType();
            switch (strategyType) {
                case 2: {
                    flag = this.register(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName());
                    break;
                }
                case 32: {
                    flag = this.unRegister(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName());
                    break;
                }
                case 4: {
                    if (0 == strategyMessage.getStrategyChildType()) {
                        flag = this.subScribeTags(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), strategyMessage.getParams());
                        break;
                    }
                    if (3 == strategyMessage.getStrategyChildType()) {
                        flag = this.checkSubScribeTags(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId());
                        break;
                    }
                    if (1 == strategyMessage.getStrategyChildType()) {
                        flag = this.unSubScribeTags(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), strategyMessage.getParams());
                        break;
                    }
                    if (2 != strategyMessage.getStrategyChildType()) break;
                    flag = this.unSubScribeAllTags(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId());
                    break;
                }
                case 16: {
                    if (0 == strategyMessage.getStrategyChildType()) {
                        flag = this.switchPush(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), 0, "1".equals(strategyMessage.getParams()));
                        break;
                    }
                    if (1 == strategyMessage.getStrategyChildType()) {
                        flag = this.switchPush(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), 1, "1".equals(strategyMessage.getParams()));
                        break;
                    }
                    if (3 == strategyMessage.getStrategyChildType()) {
                        flag = this.switchPush(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), "1".equals(strategyMessage.getParams()));
                        break;
                    }
                    if (2 != strategyMessage.getStrategyChildType()) break;
                    flag = this.checkPush(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId());
                    break;
                }
                case 8: {
                    if (0 == strategyMessage.getStrategyChildType()) {
                        flag = this.subScribeAlias(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), strategyMessage.getParams());
                        break;
                    }
                    if (1 == strategyMessage.getStrategyChildType()) {
                        flag = this.unSubScribeAlias(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId(), strategyMessage.getParams());
                        break;
                    }
                    if (2 != strategyMessage.getStrategyChildType()) break;
                    flag = this.checkSubScribeAlias(strategyMessage.getAppId(), strategyMessage.getAppKey(), strategyMessage.getPackageName(), strategyMessage.getPushId());
                    break;
                }
                case 64: {
                    if (0 == strategyMessage.getStrategyChildType()) {
                        flag = this.clearAllNotification(strategyMessage.getPackageName());
                        break;
                    }
                    if (1 == strategyMessage.getStrategyChildType()) {
                        flag = this.clearNotification(strategyMessage.getPackageName(), Integer.valueOf(strategyMessage.getParams()));
                        break;
                    }
                    if (2 != strategyMessage.getStrategyChildType()) break;
                    flag = this.clearNotifyKey(strategyMessage.getPackageName(), strategyMessage.getParams());
                    break;
                }
                case 128: {
                    if (TextUtils.isEmpty((CharSequence)strategyMessage.getParams())) break;
                    String[] params = strategyMessage.getParams().split(",");
                    flag = this.changeNotificationSwitchAdvance(strategyMessage.getPackageName(), params[0], Integer.valueOf(params[1]));
                    break;
                }
            }
        }
        return flag;
    }

    public boolean register(String appId, String appKey, String packageName) {
        this.mRegisterStatusStrategy.setAppId(appId);
        this.mRegisterStatusStrategy.setAppKey(appKey);
        this.mRegisterStatusStrategy.setStrategyPackageName(packageName);
        return this.mRegisterStatusStrategy.process();
    }

    public boolean unRegister(String appId, String appKey, String packageName) {
        this.mUnRegisterStatusStrategy.setAppId(appId);
        this.mUnRegisterStatusStrategy.setAppKey(appKey);
        this.mUnRegisterStatusStrategy.setStrategyPackageName(packageName);
        return this.mUnRegisterStatusStrategy.process();
    }

    public void unRegisterAdvance(String packageName, String deviceId) {
        ANResponse anResponse = this.mPushApi.unRegister(packageName, deviceId);
        if (anResponse != null) {
            if (anResponse.isSuccess()) {
                PlatformMessageSender.changePreference(this.mContext, "com.meizu.flyme.push", packageName + "_" + "pushId", "");
                DebugLogger.e(TAG, "unregister advance package " + packageName + " result " + anResponse.getResult());
            } else {
                DebugLogger.e(TAG, "unregister advance package " + packageName + " error " + anResponse.getError());
            }
        }
    }

    public boolean changeNotificationSwitchAdvance(String packageName, String deviceId, int subSwitch) {
        boolean flag = true;
        ANResponse anResponse = this.mPushApi.changeNotificationSwitch(packageName, deviceId, subSwitch);
        if (anResponse != null) {
            flag = anResponse.isSuccess();
            if (anResponse.isSuccess()) {
                DebugLogger.e(TAG, "change notification switch advance package " + packageName + " result " + anResponse.getResult());
            } else {
                DebugLogger.e(TAG, "change notification switch advance package " + packageName + " error " + anResponse.getError());
            }
        }
        return flag;
    }

    public boolean checkPush(String appId, String appKey, String packageName, String pushId) {
        this.mSwitchStatusStrategy.setAppId(appId);
        this.mSwitchStatusStrategy.setAppKey(appKey);
        this.mSwitchStatusStrategy.setStrategyPackageName(packageName);
        this.mSwitchStatusStrategy.setPushId(pushId);
        this.mSwitchStatusStrategy.setSwitchType(2);
        return this.mSwitchStatusStrategy.process();
    }

    public boolean switchPush(String appId, String appKey, String packageName, String pushId, int msgType, boolean switcher) {
        this.mSwitchStatusStrategy.setAppId(appId);
        this.mSwitchStatusStrategy.setAppKey(appKey);
        this.mSwitchStatusStrategy.setStrategyPackageName(packageName);
        this.mSwitchStatusStrategy.setPushId(pushId);
        this.mSwitchStatusStrategy.setSwitchType(msgType);
        this.mSwitchStatusStrategy.setSwitcher(switcher);
        return this.mSwitchStatusStrategy.process();
    }

    public boolean switchPush(String appId, String appKey, String packageName, String pushId, boolean switcher) {
        this.mSwitchStatusStrategy.setAppId(appId);
        this.mSwitchStatusStrategy.setAppKey(appKey);
        this.mSwitchStatusStrategy.setStrategyPackageName(packageName);
        this.mSwitchStatusStrategy.setPushId(pushId);
        this.mSwitchStatusStrategy.setSwitchType(3);
        this.mSwitchStatusStrategy.setSwitcher(switcher);
        return this.mSwitchStatusStrategy.process();
    }

    public boolean subScribeTags(String appId, String appKey, String packageName, String pushId, String tags) {
        this.mSubScribeTagStrategy.setAppId(appId);
        this.mSubScribeTagStrategy.setAppKey(appKey);
        this.mSubScribeTagStrategy.setStrategyPackageName(packageName);
        this.mSubScribeTagStrategy.setPushId(pushId);
        this.mSubScribeTagStrategy.setSubTagType(0);
        this.mSubScribeTagStrategy.setSubTags(tags);
        return this.mSubScribeTagStrategy.process();
    }

    public boolean unSubScribeTags(String appId, String appKey, String packageName, String pushId, String tags) {
        this.mSubScribeTagStrategy.setAppId(appId);
        this.mSubScribeTagStrategy.setAppKey(appKey);
        this.mSubScribeTagStrategy.setStrategyPackageName(packageName);
        this.mSubScribeTagStrategy.setPushId(pushId);
        this.mSubScribeTagStrategy.setSubTagType(1);
        this.mSubScribeTagStrategy.setSubTags(tags);
        return this.mSubScribeTagStrategy.process();
    }

    public boolean unSubScribeAllTags(String appId, String appKey, String packageName, String pushId) {
        this.mSubScribeTagStrategy.setAppId(appId);
        this.mSubScribeTagStrategy.setAppKey(appKey);
        this.mSubScribeTagStrategy.setStrategyPackageName(packageName);
        this.mSubScribeTagStrategy.setPushId(pushId);
        this.mSubScribeTagStrategy.setSubTagType(2);
        return this.mSubScribeTagStrategy.process();
    }

    public boolean checkSubScribeTags(String appId, String appKey, String packageName, String pushId) {
        this.mSubScribeTagStrategy.setAppId(appId);
        this.mSubScribeTagStrategy.setAppKey(appKey);
        this.mSubScribeTagStrategy.setStrategyPackageName(packageName);
        this.mSubScribeTagStrategy.setPushId(pushId);
        this.mSubScribeTagStrategy.setSubTagType(3);
        return this.mSubScribeTagStrategy.process();
    }

    public boolean subScribeAlias(String appId, String appKey, String packageName, String pushId, String alias) {
        this.mSubScribeAliasStrategy.setAppId(appId);
        this.mSubScribeAliasStrategy.setAppKey(appKey);
        this.mSubScribeAliasStrategy.setStrategyPackageName(packageName);
        this.mSubScribeAliasStrategy.setPushId(pushId);
        this.mSubScribeAliasStrategy.setSubAliasType(0);
        this.mSubScribeAliasStrategy.setAlias(alias);
        return this.mSubScribeAliasStrategy.process();
    }

    public boolean unSubScribeAlias(String appId, String appKey, String packageName, String pushId, String alias) {
        this.mSubScribeAliasStrategy.setAppId(appId);
        this.mSubScribeAliasStrategy.setAppKey(appKey);
        this.mSubScribeAliasStrategy.setStrategyPackageName(packageName);
        this.mSubScribeAliasStrategy.setPushId(pushId);
        this.mSubScribeAliasStrategy.setSubAliasType(1);
        this.mSubScribeAliasStrategy.setAlias(alias);
        return this.mSubScribeAliasStrategy.process();
    }

    public boolean checkSubScribeAlias(String appId, String appKey, String packageName, String pushId) {
        this.mSubScribeAliasStrategy.setAppId(appId);
        this.mSubScribeAliasStrategy.setAppKey(appKey);
        this.mSubScribeAliasStrategy.setStrategyPackageName(packageName);
        this.mSubScribeAliasStrategy.setPushId(pushId);
        this.mSubScribeAliasStrategy.setSubAliasType(2);
        return this.mSubScribeAliasStrategy.process();
    }

    public boolean clearNotification(String packageName, int ... notifyId) {
        NotificationClearStrategy notificationClearStrategy = new NotificationClearStrategy(this.mContext, this.mExecutorService, this.mEnableRpc);
        notificationClearStrategy.setNotifyId(notifyId);
        notificationClearStrategy.setStrategyPackageName(packageName);
        notificationClearStrategy.setClearType(1);
        return notificationClearStrategy.process();
    }

    public boolean clearAllNotification(String packageName) {
        NotificationClearStrategy notificationClearStrategy = new NotificationClearStrategy(this.mContext, this.mExecutorService, this.mEnableRpc);
        notificationClearStrategy.setClearType(0);
        notificationClearStrategy.setStrategyPackageName(packageName);
        return notificationClearStrategy.process();
    }

    public boolean clearNotifyKey(String packageName, String notifyKey) {
        NotificationClearStrategy notificationClearStrategy = new NotificationClearStrategy(this.mContext, this.mExecutorService, this.mEnableRpc);
        notificationClearStrategy.setClearType(2);
        notificationClearStrategy.setNotifyKey(notifyKey);
        notificationClearStrategy.setStrategyPackageName(packageName);
        return notificationClearStrategy.process();
    }

    public ANResponse<String> uploadLogFile(String messageId, String deviceId, String errorMsg, File logFile) {
        return this.mPushApi.uploadLogFile(messageId, deviceId, errorMsg, logFile);
    }
}

