/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.message;

import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BasicPushStatus
implements Serializable {
    public static final String TAG = "BasicPushStatus";
    public static final String SUCCESS_CODE = "200";
    public String code;
    public String message;

    public BasicPushStatus() {
    }

    public BasicPushStatus(String json) {
        JSONObject jsonObject = this.parse(json);
        if (jsonObject != null && SUCCESS_CODE.equals(this.code) && !jsonObject.isNull("value")) {
            try {
                this.parseValueData(jsonObject.getJSONObject("value"));
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse value data error " + e.getMessage() + " json " + json);
            }
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public abstract void parseValueData(JSONObject var1) throws JSONException;

    protected JSONObject parse(String message) {
        JSONObject jsonObject = null;
        if (!TextUtils.isEmpty((CharSequence)message)) {
            try {
                jsonObject = new JSONObject(message);
                if (!jsonObject.isNull("code")) {
                    this.setCode(jsonObject.getString("code"));
                }
                if (!jsonObject.isNull("message")) {
                    this.setMessage(jsonObject.getString("message"));
                }
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "covert json error " + e.getMessage());
            }
        }
        return jsonObject;
    }

    public String toString() {
        return "BasicPushStatus{code='" + this.code + '\'' + ", message='" + this.message + '\'' + '}';
    }
}

