/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.message;

import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.platform.message.BasicPushStatus;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StatusSerialize {
    private static final String TAG = "StatusSerialize";

    private static JSONObject addBasicPushStatusJsonValue(JSONObject jsonObject, BasicPushStatus basicPushStatus) throws JSONException {
        if (jsonObject == null || basicPushStatus == null) {
            return null;
        }
        jsonObject.put("code", (Object)basicPushStatus.getCode());
        jsonObject.put("message", (Object)basicPushStatus.getMessage());
        return jsonObject;
    }

    private static BasicPushStatus addBasicPushStatusObjectValue(JSONObject jsonObject, BasicPushStatus basicPushStatus) throws JSONException {
        if (jsonObject == null || basicPushStatus == null) {
            return null;
        }
        if (!jsonObject.isNull("code")) {
            basicPushStatus.setCode(jsonObject.getString("code"));
        }
        if (!jsonObject.isNull("message")) {
            basicPushStatus.setMessage(jsonObject.getString("message"));
        }
        return basicPushStatus;
    }

    public static String registerStatusToString(RegisterStatus statusObj) {
        DebugLogger.i(TAG, "register status serialize registerStatusToString start, RegisterStatus=" + statusObj);
        try {
            JSONObject statusJson = new JSONObject();
            statusJson = StatusSerialize.addBasicPushStatusJsonValue(statusJson, statusObj);
            if (!TextUtils.isEmpty((CharSequence)statusObj.getPushId())) {
                statusJson.put("push_id", (Object)statusObj.getPushId());
            }
            if (statusObj.getExpireTime() > 0) {
                statusJson.put("expire_time", statusObj.getExpireTime());
            }
            String statusText = statusJson.toString();
            DebugLogger.i(TAG, "register status serialize registerStatusToString success, statusText=" + statusText);
            return statusText;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "register status serialize registerStatusToString error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static RegisterStatus stringToRegisterStatus(String statusText) {
        DebugLogger.i(TAG, "register status serialize stringToRegisterStatus start, statusText=" + statusText);
        try {
            RegisterStatus statusObj = new RegisterStatus();
            JSONObject statusJson = new JSONObject(statusText);
            statusObj = (RegisterStatus)StatusSerialize.addBasicPushStatusObjectValue(statusJson, statusObj);
            if (!statusJson.isNull("push_id")) {
                statusObj.setPushId(statusJson.getString("push_id"));
            }
            if (!statusJson.isNull("expire_time")) {
                statusObj.setExpireTime(statusJson.getInt("expire_time"));
            }
            DebugLogger.i(TAG, "register status serialize stringToRegisterStatus success, RegisterStatus=" + statusObj);
            return statusObj;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "register status serialize stringToRegisterStatus error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static String unregisterStatusToString(UnRegisterStatus statusObj) {
        DebugLogger.i(TAG, "register status serialize unregisterStatusToString start, UnRegisterStatus=" + statusObj);
        try {
            JSONObject statusJson = new JSONObject();
            statusJson = StatusSerialize.addBasicPushStatusJsonValue(statusJson, statusObj);
            statusJson.put("is_unregister_success", statusObj.isUnRegisterSuccess());
            String statusText = statusJson.toString();
            DebugLogger.i(TAG, "register status serialize unregisterStatusToString success, statusText=" + statusText);
            return statusText;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "register status serialize unregisterStatusToString error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static UnRegisterStatus stringToUnregisterStatus(String statusText) {
        DebugLogger.i(TAG, "register status serialize stringToUnregisterStatus start, statusText=" + statusText);
        try {
            UnRegisterStatus statusObj = new UnRegisterStatus();
            JSONObject statusJson = new JSONObject(statusText);
            statusObj = (UnRegisterStatus)StatusSerialize.addBasicPushStatusObjectValue(statusJson, statusObj);
            if (!statusJson.isNull("is_unregister_success")) {
                statusObj.setIsUnRegisterSuccess(statusJson.getBoolean("is_unregister_success"));
            }
            DebugLogger.i(TAG, "register status serialize stringToUnregisterStatus success, UnRegisterStatus=" + statusObj);
            return statusObj;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "register status serialize stringToUnregisterStatus error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static String pushSwitchStatusToString(PushSwitchStatus statusObj) {
        DebugLogger.i(TAG, "register status serialize pushSwitchStatusToString start, PushSwitchStatus=" + statusObj);
        try {
            JSONObject statusJson = new JSONObject();
            statusJson = StatusSerialize.addBasicPushStatusJsonValue(statusJson, statusObj);
            if (!TextUtils.isEmpty((CharSequence)statusObj.getPushId())) {
                statusJson.put("push_id", (Object)statusObj.getPushId());
            }
            statusJson.put("is_switch_notification", statusObj.isSwitchNotificationMessage());
            statusJson.put("is_switch_through", statusObj.isSwitchThroughMessage());
            String statusText = statusJson.toString();
            DebugLogger.i(TAG, "register status serialize pushSwitchStatusToString success, statusText=" + statusText);
            return statusText;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "register status serialize pushSwitchStatusToString error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static PushSwitchStatus stringToPushSwitchStatus(String statusText) {
        DebugLogger.i(TAG, "register status serialize stringToPushSwitchStatus start, statusText=" + statusText);
        try {
            PushSwitchStatus statusObj = new PushSwitchStatus();
            JSONObject statusJson = new JSONObject(statusText);
            statusObj = (PushSwitchStatus)StatusSerialize.addBasicPushStatusObjectValue(statusJson, statusObj);
            if (!statusJson.isNull("push_id")) {
                statusObj.setPushId(statusJson.getString("push_id"));
            }
            if (!statusJson.isNull("is_switch_notification")) {
                statusObj.setSwitchNotificationMessage(statusJson.getBoolean("is_switch_notification"));
            }
            if (!statusJson.isNull("is_switch_through")) {
                statusObj.setSwitchThroughMessage(statusJson.getBoolean("is_switch_through"));
            }
            DebugLogger.i(TAG, "register status serialize stringToPushSwitchStatus success, PushSwitchStatus=" + statusObj);
            return statusObj;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "register status serialize stringToPushSwitchStatus error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static String subAliasStatusToString(SubAliasStatus statusObj) {
        DebugLogger.i(TAG, "register status serialize subAliasStatusToString start, SubAliasStatus=" + statusObj);
        try {
            JSONObject statusJson = new JSONObject();
            statusJson = StatusSerialize.addBasicPushStatusJsonValue(statusJson, statusObj);
            if (!TextUtils.isEmpty((CharSequence)statusObj.getPushId())) {
                statusJson.put("push_id", (Object)statusObj.getPushId());
            }
            statusJson.put("alias", (Object)statusObj.getAlias());
            String statusText = statusJson.toString();
            DebugLogger.i(TAG, "register status serialize subAliasStatusToString success, statusText=" + statusText);
            return statusText;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "register status serialize subAliasStatusToString error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static SubAliasStatus stringToSubAliasStatus(String statusText) {
        DebugLogger.i(TAG, "register status serialize stringToSubAliasStatus start, statusText=" + statusText);
        try {
            SubAliasStatus statusObj = new SubAliasStatus();
            JSONObject statusJson = new JSONObject(statusText);
            statusObj = (SubAliasStatus)StatusSerialize.addBasicPushStatusObjectValue(statusJson, statusObj);
            if (!statusJson.isNull("push_id")) {
                statusObj.setPushId(statusJson.getString("push_id"));
            }
            if (!statusJson.isNull("alias")) {
                statusObj.setAlias(statusJson.getString("alias"));
            }
            DebugLogger.i(TAG, "register status serialize stringToSubAliasStatus success, SubAliasStatus=" + statusObj);
            return statusObj;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "register status serialize stringToSubAliasStatus error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static String subTagsStatusToString(SubTagsStatus statusObj) {
        DebugLogger.i(TAG, "register status serialize subTagsStatusToString start, SubTagsStatus=" + statusObj);
        try {
            JSONObject statusJson = new JSONObject();
            statusJson = StatusSerialize.addBasicPushStatusJsonValue(statusJson, statusObj);
            if (!TextUtils.isEmpty((CharSequence)statusObj.getPushId())) {
                statusJson.put("push_id", (Object)statusObj.getPushId());
            }
            if (statusObj.getTagList() != null) {
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < statusObj.getTagList().size(); ++i) {
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("tag_id", statusObj.getTagList().get(i).getTagId());
                    jsonObj.put("tag_name", (Object)statusObj.getTagList().get(i).getTagName());
                    jsonArray.put((Object)jsonObj);
                }
                statusJson.put("tag_list", (Object)jsonArray);
            }
            String statusText = statusJson.toString();
            DebugLogger.i(TAG, "register status serialize subTagsStatusToString success, statusText=" + statusText);
            return statusText;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "register status serialize subTagsStatusToString error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static SubTagsStatus stringToSubTagsStatus(String statusText) {
        DebugLogger.i(TAG, "register status serialize stringToSubTagsStatus start, statusText=" + statusText);
        try {
            SubTagsStatus statusObj = new SubTagsStatus();
            JSONObject statusJson = new JSONObject(statusText);
            statusObj = (SubTagsStatus)StatusSerialize.addBasicPushStatusObjectValue(statusJson, statusObj);
            if (!statusJson.isNull("push_id")) {
                statusObj.setPushId(statusJson.getString("push_id"));
            }
            if (!statusJson.isNull("tag_list")) {
                JSONArray jsonArray = statusJson.getJSONArray("tag_list");
                ArrayList<SubTagsStatus.Tag> tagList = new ArrayList<SubTagsStatus.Tag>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    SubTagsStatus.Tag tagObj = new SubTagsStatus.Tag(statusObj);
                    if (!jsonObject.isNull("tag_id")) {
                        tagObj.setTagId(jsonObject.getInt("tag_id"));
                    }
                    if (!jsonObject.isNull("tag_name")) {
                        tagObj.setTagName(jsonObject.getString("tag_name"));
                    }
                    tagList.add(tagObj);
                }
                statusObj.setTagList(tagList);
            }
            DebugLogger.i(TAG, "register status serialize stringToSubTagsStatus success, SubTagsStatus=" + statusObj);
            return statusObj;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "register status serialize stringToSubTagsStatus error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

