/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.message;

public class StrategyMessage
implements Comparable<StrategyMessage> {
    private String appId;
    private String appKey;
    private String packageName;
    private String pushId;
    private int strategyType;
    private int strategyChildType;
    private String params;
    private final long currentTime;
    private int retryCount = 0;

    public StrategyMessage(String appId, String appKey, String packageName, String pushId, int strategyType, int strategyChildType, String params) {
        this.appId = appId;
        this.appKey = appKey;
        this.packageName = packageName;
        this.pushId = pushId;
        this.strategyType = strategyType;
        this.strategyChildType = strategyChildType;
        this.params = params;
        this.currentTime = System.currentTimeMillis();
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPushId() {
        return this.pushId;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    public int getStrategyType() {
        return this.strategyType;
    }

    public void setStrategyType(int strategyType) {
        this.strategyType = strategyType;
    }

    public int getStrategyChildType() {
        return this.strategyChildType;
    }

    public void setStrategyChildType(int strategyChildType) {
        this.strategyChildType = strategyChildType;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void countDownRetryCount() {
        this.retryCount = 0;
    }

    public boolean isRetry() {
        boolean flag = true;
        if (++this.retryCount > 1) {
            flag = false;
        }
        return flag;
    }

    public boolean needNetWork() {
        return this.strategyType != 64 && this.strategyType != 16;
    }

    @Override
    public int compareTo(StrategyMessage strategyMessage) {
        return (int)(this.currentTime - strategyMessage.currentTime);
    }

    public String toString() {
        return "StrategyMessage{strategyType=" + this.strategyType + ", packageName='" + this.packageName + '\'' + ", appKey='" + this.appKey + '\'' + ", appId='" + this.appId + '\'' + ", pushId='" + this.pushId + '\'' + ", strategyChildType=" + this.strategyChildType + ", params='" + this.params + '\'' + '}';
    }
}

