/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.notification.util.NotificationUtils;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.BasicPushStatus;
import com.meizu.cloud.pushsdk.platform.pushstrategy.Strategy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;
import java.util.concurrent.ScheduledExecutorService;

public class NotificationClearStrategy
extends Strategy {
    private int[] notifyId;
    private int clearType;
    private String notifyKey;
    public static final int CLEAR_ALL = 0;
    public static final int CLEAR_NOTIFY_ID = 1;
    public static final int CLEAR_NOTIFY_KEY = 2;

    public NotificationClearStrategy(Context context, ScheduledExecutorService executorService, boolean enableRpc) {
        this(context, null, null, null, executorService);
        this.enableRpc = enableRpc;
    }

    public NotificationClearStrategy(Context context, String appId, String appKey, PushAPI pushApi, ScheduledExecutorService executorService) {
        super(context, appId, appKey, pushApi, executorService);
        this.isSupportRemoteInvoke = MinSdkChecker.isSupportSetDrawableSmallIcon();
    }

    public void setNotifyId(int ... notifyId) {
        this.notifyId = notifyId;
    }

    public void setClearType(int clearType) {
        this.clearType = clearType;
    }

    public void setNotifyKey(String notifyKey) {
        this.notifyKey = notifyKey;
    }

    @Override
    protected boolean matchCondition() {
        return this.clearType == 0 || this.notifyId != null && this.notifyId.length > 0 && this.clearType == 1 || this.clearType == 2 && !TextUtils.isEmpty((CharSequence)this.notifyKey);
    }

    protected BasicPushStatus feedBackErrorResponse() {
        return null;
    }

    @Override
    protected Intent sendRpcRequest() {
        Intent intent = new Intent();
        intent.putExtra("strategy_package_name", this.context.getPackageName());
        intent.putExtra("strategy_type", this.strategyType());
        intent.putExtra("strategy_child_type", this.clearType);
        if (this.clearType == 2) {
            intent.putExtra("strategy_params", this.notifyKey);
        } else if (this.clearType == 1) {
            intent = null;
        }
        return intent;
    }

    @Override
    protected Intent[] sendRpcRequests() {
        Intent[] intents = null;
        if (this.notifyId != null) {
            intents = new Intent[this.notifyId.length];
            for (int i = 0; i < this.notifyId.length; ++i) {
                DebugLogger.i("Strategy", "send notifyId " + this.notifyId[i] + " to PushManagerService");
                Intent intent = new Intent();
                intent.putExtra("strategy_package_name", this.context.getPackageName());
                intent.putExtra("strategy_type", this.strategyType());
                intent.putExtra("strategy_child_type", this.clearType);
                intent.putExtra("strategy_params", "" + this.notifyId[i]);
                intents[i] = intent;
            }
        }
        return intents;
    }

    protected BasicPushStatus netWorkRequest() {
        switch (this.clearType) {
            case 0: {
                if (!MinSdkChecker.isSupportSetDrawableSmallIcon()) {
                    DebugLogger.e("Strategy", "android 6.0 blow so cancel all by context");
                    NotificationUtils.clearAllNotification(this.context);
                }
                NotificationUtils.clearNotification(this.context, this.strategyPackageName);
                break;
            }
            case 1: {
                if (this.notifyId == null) break;
                for (int id : this.notifyId) {
                    DebugLogger.e("Strategy", "clear notifyId " + id);
                    NotificationUtils.clearNotification(this.context, this.strategyPackageName, id);
                }
                break;
            }
            case 2: {
                NotificationUtils.removeNotifyKey(this.context, this.strategyPackageName, this.notifyKey);
            }
        }
        return null;
    }

    protected BasicPushStatus localResponse() {
        return null;
    }

    protected void sendReceiverMessage(BasicPushStatus message) {
    }

    @Override
    protected int strategyType() {
        return 64;
    }
}

