/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.DeviceUtils;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.PushIdEncryptUtils;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.pushstrategy.Strategy;
import com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Executor;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RegisterStatusStrategy
extends Strategy<RegisterStatus> {
    private static final int SECOND_UNIT_CONVERSION = 1000;
    private Handler mainHandler;
    private ScheduledExecutorService scheduledExecutorService;
    private int deviceIdRetry = 0;

    public RegisterStatusStrategy(Context context, String appId, String appKey, PushAPI pushApi, ScheduledExecutorService executorService) {
        super(context, appId, appKey, pushApi, executorService);
    }

    public RegisterStatusStrategy(Context context, PushAPI pushApi, ScheduledExecutorService executorService) {
        this(context, null, null, pushApi, executorService);
        this.scheduledExecutorService = (ScheduledExecutorService)Executor.getExecutor();
        this.mainHandler = new Handler(context.getMainLooper()){

            public void handleMessage(Message msg) {
                if (msg.what == 0) {
                    RegisterStatusStrategy.this.process();
                }
            }
        };
    }

    public RegisterStatusStrategy(Context context, PushAPI pushApi, ScheduledExecutorService executorService, boolean enableRpc) {
        this(context, pushApi, executorService);
        this.enableRpc = enableRpc;
    }

    @Override
    public boolean matchCondition() {
        DebugLogger.e("Strategy", "isBrandMeizu " + MzSystemUtils.isBrandMeizu(this.context));
        return !TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.appKey);
    }

    @Override
    protected RegisterStatus feedBackErrorResponse() {
        RegisterStatus registerStatus = new RegisterStatus();
        registerStatus.setCode("20001");
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            registerStatus.setMessage("appId not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            registerStatus.setMessage("appKey not empty");
        }
        return registerStatus;
    }

    @Override
    public Intent sendRpcRequest() {
        Intent intent = new Intent();
        intent.putExtra("app_id", this.appId);
        intent.putExtra("app_key", this.appKey);
        intent.putExtra("strategy_package_name", this.context.getPackageName());
        intent.putExtra("strategy_type", this.strategyType());
        return intent;
    }

    @Override
    protected RegisterStatus localResponse() {
        return null;
    }

    @Override
    public RegisterStatus netWorkRequest() {
        int expireTime;
        RegisterStatus registerStatus = new RegisterStatus();
        String pushId = PushPreferencesUtils.getPushId(this.context, this.strategyPackageName);
        if (!this.retryRegister(pushId, expireTime = PushPreferencesUtils.getPushIdExpireTime(this.context, this.strategyPackageName))) {
            registerStatus.setCode("200");
            registerStatus.setMessage("already register PushId,don't register frequently");
            registerStatus.setPushId(pushId);
            registerStatus.setExpireTime((int)((long)expireTime - System.currentTimeMillis() / 1000L));
        } else {
            PushPreferencesUtils.putPushId(this.context, "", this.strategyPackageName);
            String deviceId = DeviceUtils.getDeviceId(this.context);
            if (TextUtils.isEmpty((CharSequence)deviceId) && this.deviceIdRetry < 3) {
                DebugLogger.i("Strategy", "after " + this.deviceIdRetry * 10 + " seconds start register");
                this.executeAfterGetDeviceId(this.deviceIdRetry * 10);
                ++this.deviceIdRetry;
                registerStatus.setCode("20000");
                registerStatus.setMessage("deviceId is empty");
            } else {
                this.deviceIdRetry = 0;
                ANResponse registerStatusAnResponse = this.pushApi.register(this.appId, this.appKey, deviceId);
                if (registerStatusAnResponse.isSuccess()) {
                    registerStatus = new RegisterStatus((String)registerStatusAnResponse.getResult());
                    DebugLogger.e("Strategy", "registerStatus " + registerStatus);
                    if (!TextUtils.isEmpty((CharSequence)registerStatus.getPushId())) {
                        PushPreferencesUtils.putPushId(this.context, registerStatus.getPushId(), this.strategyPackageName);
                        PushPreferencesUtils.putPushIdExpireTime(this.context, (int)(System.currentTimeMillis() / 1000L + (long)registerStatus.getExpireTime()), this.strategyPackageName);
                    }
                } else {
                    ANError error = registerStatusAnResponse.getError();
                    if (error.getResponse() != null) {
                        DebugLogger.e("Strategy", "status code=" + error.getErrorCode() + " data=" + error.getResponse());
                    }
                    registerStatus.setCode(String.valueOf(error.getErrorCode()));
                    registerStatus.setMessage(error.getErrorBody());
                    DebugLogger.e("Strategy", "registerStatus " + registerStatus);
                }
            }
        }
        return registerStatus;
    }

    @Override
    public void sendReceiverMessage(RegisterStatus message) {
        PlatformMessageSender.sendRegisterStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName(), message);
    }

    @Override
    protected int strategyType() {
        return 2;
    }

    protected void executeAfterGetDeviceId(long delay) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                DeviceUtils.getDeviceId(RegisterStatusStrategy.this.context);
                RegisterStatusStrategy.this.mainHandler.sendEmptyMessage(0);
            }
        }, delay, TimeUnit.SECONDS);
    }

    protected boolean retryRegister(String pushId, int expireTime) {
        String deviceId = DeviceUtils.getDeviceId(this.context);
        boolean result = this.isTimeExpires(deviceId, pushId, expireTime);
        if (result) {
            String decryptPushId = PushIdEncryptUtils.decryptPushId(pushId);
            result = this.isTimeExpires(deviceId, decryptPushId, expireTime);
        }
        return result;
    }

    private boolean isTimeExpires(String deviceId, String pushId, int expireTime) {
        if (TextUtils.isEmpty((CharSequence)deviceId) || TextUtils.isEmpty((CharSequence)pushId)) {
            return true;
        }
        if (!pushId.startsWith(deviceId)) {
            return true;
        }
        return System.currentTimeMillis() / 1000L > (long)expireTime;
    }
}

