/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.pushstrategy.Strategy;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public class SubScribeAliasStrategy
extends Strategy<SubAliasStatus> {
    private String pushId;
    private int subAliasType;
    private String alias;
    public static final int SUB_ALIAS = 0;
    public static final int UN_SUB_ALIAS = 1;
    public static final int CHECK_ALIAS = 2;
    private final Map<String, Boolean> aliasStatusMap = new HashMap<String, Boolean>();

    public SubScribeAliasStrategy(Context context, String appId, String appKey, PushAPI pushApi, ScheduledExecutorService executorService) {
        super(context, appId, appKey, pushApi, executorService);
    }

    public SubScribeAliasStrategy(Context context, String appId, String appKey, String pushId, PushAPI pushApi, ScheduledExecutorService executorService) {
        this(context, appId, appKey, pushApi, executorService);
        this.pushId = pushId;
    }

    public SubScribeAliasStrategy(Context context, PushAPI pushApi, ScheduledExecutorService executorService) {
        this(context, null, null, null, pushApi, executorService);
    }

    public SubScribeAliasStrategy(Context context, PushAPI pushApi, ScheduledExecutorService executorService, boolean enableRpc) {
        this(context, pushApi, executorService);
        this.enableRpc = enableRpc;
    }

    public void setSubAliasType(int subAliasType) {
        this.subAliasType = subAliasType;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    @Override
    protected boolean matchCondition() {
        return !TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.appKey) && !TextUtils.isEmpty((CharSequence)this.pushId);
    }

    @Override
    protected SubAliasStatus feedBackErrorResponse() {
        SubAliasStatus subAliasStatus = new SubAliasStatus();
        subAliasStatus.setCode("20001");
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            subAliasStatus.setMessage("appId not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            subAliasStatus.setMessage("appKey not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.pushId)) {
            subAliasStatus.setMessage("pushId not empty");
        }
        return subAliasStatus;
    }

    @Override
    protected Intent sendRpcRequest() {
        Intent intent = null;
        if (this.subAliasType != 2) {
            intent = new Intent();
            intent.putExtra("app_id", this.appId);
            intent.putExtra("app_key", this.appKey);
            intent.putExtra("strategy_package_name", this.context.getPackageName());
            intent.putExtra("push_id", this.pushId);
            intent.putExtra("strategy_type", this.strategyType());
            intent.putExtra("strategy_child_type", this.subAliasType);
            intent.putExtra("strategy_params", this.alias);
        }
        return intent;
    }

    @Override
    protected SubAliasStatus netWorkRequest() {
        SubAliasStatus subAliasStatus = new SubAliasStatus();
        subAliasStatus.setPushId(this.pushId);
        subAliasStatus.setMessage("");
        ANResponse anResponse = null;
        switch (this.subAliasType) {
            case 0: {
                if (this.alias.equals(this.localAlias()) && !this.isSyncAliasStatus()) {
                    subAliasStatus.setCode("200");
                    subAliasStatus.setAlias(this.alias);
                    break;
                }
                this.changeSyncAliasStatus(true);
                if (this.isCacheAlias()) {
                    this.storeAlias(this.alias);
                }
                anResponse = this.pushApi.subScribeAlias(this.appId, this.appKey, this.pushId, this.alias);
                break;
            }
            case 1: {
                if (TextUtils.isEmpty((CharSequence)this.localAlias()) && !this.isSyncAliasStatus()) {
                    subAliasStatus.setCode("200");
                    subAliasStatus.setAlias("");
                    break;
                }
                this.changeSyncAliasStatus(true);
                if (this.isCacheAlias()) {
                    this.storeAlias("");
                }
                anResponse = this.pushApi.unSubScribeAlias(this.appId, this.appKey, this.pushId, this.alias);
                break;
            }
            case 2: {
                subAliasStatus.setAlias(this.localAlias());
                subAliasStatus.setCode("200");
                break;
            }
        }
        if (anResponse != null) {
            if (anResponse.isSuccess()) {
                subAliasStatus = new SubAliasStatus((String)anResponse.getResult());
                DebugLogger.e("Strategy", "network subAliasStatus " + subAliasStatus);
                if ("200".equals(subAliasStatus.getCode())) {
                    this.changeSyncAliasStatus(false);
                }
            } else {
                ANError error = anResponse.getError();
                if (error.getResponse() != null) {
                    DebugLogger.e("Strategy", "status code=" + error.getErrorCode() + " data=" + error.getResponse());
                }
                subAliasStatus.setCode(String.valueOf(error.getErrorCode()));
                subAliasStatus.setMessage(error.getErrorBody());
                DebugLogger.e("Strategy", "subAliasStatus " + subAliasStatus);
            }
        }
        return subAliasStatus;
    }

    @Override
    protected SubAliasStatus localResponse() {
        SubAliasStatus subAliasStatus = null;
        if (this.subAliasType == 2) {
            subAliasStatus = new SubAliasStatus();
            subAliasStatus.setCode("200");
            subAliasStatus.setPushId(this.pushId);
            subAliasStatus.setAlias(this.localAlias());
            subAliasStatus.setMessage("check alias success");
        }
        return subAliasStatus;
    }

    @Override
    protected void sendReceiverMessage(SubAliasStatus message) {
        PlatformMessageSender.sendSubAlias(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName(), message);
    }

    @Override
    protected int strategyType() {
        return 8;
    }

    private void storeAlias(String alias) {
        PushPreferencesUtils.setAlias(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName(), alias);
    }

    private String localAlias() {
        return PushPreferencesUtils.getAlias(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName());
    }

    private void changeSyncAliasStatus(boolean flag) {
        this.aliasStatusMap.put(this.strategyPackageName + "_" + this.subAliasType, flag);
    }

    private boolean isSyncAliasStatus() {
        Boolean aliasStatus = this.aliasStatusMap.get(this.strategyPackageName + "_" + this.subAliasType);
        return aliasStatus == null || aliasStatus != false;
    }

    private boolean isCacheAlias() {
        return !this.isSupportRemoteInvoke && "com.meizu.cloud".equals(this.strategyPackageName);
    }
}

