/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.pushstrategy.Strategy;
import java.util.concurrent.ScheduledExecutorService;

public class SubScribeTagStrategy
extends Strategy<SubTagsStatus> {
    private String pushId;
    public static final int SUB_TAGS = 0;
    public static final int UN_SUB_TAGS = 1;
    public static final int UN_SUB_ALL_TAGS = 2;
    public static final int CHECK_SUB_TAGS = 3;
    private int subTagType = 3;
    private String tags;

    public SubScribeTagStrategy(Context context, String appId, String appKey, PushAPI pushApi, ScheduledExecutorService executorService) {
        super(context, appId, appKey, pushApi, executorService);
    }

    public SubScribeTagStrategy(Context context, String appId, String appKey, String pushId, PushAPI pushApi, ScheduledExecutorService executorService) {
        this(context, appId, appKey, pushApi, executorService);
        this.pushId = pushId;
    }

    public SubScribeTagStrategy(Context context, PushAPI pushApi, ScheduledExecutorService executorService) {
        this(context, null, null, null, pushApi, executorService);
    }

    public SubScribeTagStrategy(Context context, PushAPI pushApi, ScheduledExecutorService executorService, boolean enableRpc) {
        this(context, pushApi, executorService);
        this.enableRpc = enableRpc;
    }

    public void setSubTagType(int subTagType) {
        this.subTagType = subTagType;
    }

    public void setSubTags(String tags) {
        this.tags = tags;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    @Override
    protected boolean matchCondition() {
        return !TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.appKey) && !TextUtils.isEmpty((CharSequence)this.pushId);
    }

    @Override
    protected SubTagsStatus feedBackErrorResponse() {
        SubTagsStatus subTagsStatus = new SubTagsStatus();
        subTagsStatus.setCode("20001");
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            subTagsStatus.setMessage("appId not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            subTagsStatus.setMessage("appKey not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.pushId)) {
            subTagsStatus.setMessage("pushId not empty");
        }
        return subTagsStatus;
    }

    @Override
    protected Intent sendRpcRequest() {
        Intent intent = new Intent();
        intent.putExtra("app_id", this.appId);
        intent.putExtra("app_key", this.appKey);
        intent.putExtra("strategy_package_name", this.context.getPackageName());
        intent.putExtra("push_id", this.pushId);
        intent.putExtra("strategy_type", this.strategyType());
        intent.putExtra("strategy_child_type", this.subTagType);
        intent.putExtra("strategy_params", this.tags);
        return intent;
    }

    @Override
    protected SubTagsStatus netWorkRequest() {
        SubTagsStatus subTagsStatus = new SubTagsStatus();
        ANResponse anResponse = null;
        switch (this.subTagType) {
            case 0: {
                anResponse = this.pushApi.subScribeTags(this.appId, this.appKey, this.pushId, this.tags);
                break;
            }
            case 1: {
                anResponse = this.pushApi.unSubScribeTags(this.appId, this.appKey, this.pushId, this.tags);
                break;
            }
            case 2: {
                anResponse = this.pushApi.unSubAllScribeTags(this.appId, this.appKey, this.pushId);
                break;
            }
            case 3: {
                anResponse = this.pushApi.checkSubScribeTags(this.appId, this.appKey, this.pushId);
                break;
            }
        }
        if (anResponse == null) {
            DebugLogger.e("Strategy", "network anResponse is null");
            return null;
        }
        if (anResponse.isSuccess()) {
            subTagsStatus = new SubTagsStatus((String)anResponse.getResult());
            DebugLogger.e("Strategy", "network subTagsStatus " + subTagsStatus);
        } else {
            ANError error = anResponse.getError();
            if (error.getResponse() != null) {
                DebugLogger.e("Strategy", "status code=" + error.getErrorCode() + " data=" + error.getResponse());
            }
            subTagsStatus.setCode(String.valueOf(error.getErrorCode()));
            subTagsStatus.setMessage(error.getErrorBody());
            DebugLogger.e("Strategy", "subTagsStatus " + subTagsStatus);
        }
        return subTagsStatus;
    }

    @Override
    protected SubTagsStatus localResponse() {
        return null;
    }

    @Override
    protected void sendReceiverMessage(SubTagsStatus message) {
        PlatformMessageSender.sendSubTags(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName(), message);
    }

    @Override
    protected int strategyType() {
        return 4;
    }
}

