/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.pushstrategy.Strategy;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public class SwitchStatusStrategy
extends Strategy<PushSwitchStatus> {
    private String pushId;
    private int switchType = 0;
    private boolean switcher;
    public static final int CHECK_PUSH = 2;
    public static final int SWITCH_ALL = 3;
    public static final int SWITCH_NOTIFICATION = 0;
    public static final int SWITCH_THROUGH_MESSAGE = 1;
    private final Map<String, Boolean> pushStatusMap = new HashMap<String, Boolean>();

    public SwitchStatusStrategy(Context context, String appId, String appKey, PushAPI pushApi, ScheduledExecutorService executorService) {
        super(context, appId, appKey, pushApi, executorService);
    }

    public SwitchStatusStrategy(Context context, String appId, String appKey, String pushId, PushAPI pushApi, ScheduledExecutorService executorService) {
        this(context, appId, appKey, pushApi, executorService);
        this.pushId = pushId;
    }

    public SwitchStatusStrategy(Context context, PushAPI pushApi, ScheduledExecutorService executorService) {
        this(context, null, null, null, pushApi, executorService);
    }

    public SwitchStatusStrategy(Context context, PushAPI pushApi, ScheduledExecutorService executorService, boolean enableRpc) {
        this(context, pushApi, executorService);
        this.enableRpc = enableRpc;
    }

    public void setSwitcher(boolean switcher) {
        this.switcher = switcher;
    }

    public void setSwitchType(int switchType) {
        this.switchType = switchType;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    @Override
    protected boolean matchCondition() {
        return !TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.appKey) && !TextUtils.isEmpty((CharSequence)this.pushId);
    }

    @Override
    protected PushSwitchStatus feedBackErrorResponse() {
        PushSwitchStatus pushSwitchStatus = new PushSwitchStatus();
        pushSwitchStatus.setCode("20001");
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            pushSwitchStatus.setMessage("appId not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            pushSwitchStatus.setMessage("appKey not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.pushId)) {
            pushSwitchStatus.setMessage("pushId not empty");
        }
        return pushSwitchStatus;
    }

    @Override
    protected Intent sendRpcRequest() {
        Intent intent = new Intent();
        intent.putExtra("app_id", this.appId);
        intent.putExtra("app_key", this.appKey);
        intent.putExtra("strategy_package_name", this.context.getPackageName());
        intent.putExtra("push_id", this.pushId);
        intent.putExtra("strategy_type", this.strategyType());
        intent.putExtra("strategy_child_type", this.switchType);
        intent.putExtra("strategy_params", this.switcher ? "1" : "0");
        return intent;
    }

    @Override
    protected PushSwitchStatus netWorkRequest() {
        PushSwitchStatus pushSwitchStatus = new PushSwitchStatus();
        pushSwitchStatus.setPushId(this.pushId);
        pushSwitchStatus.setCode("200");
        ANResponse<String> anResponse = this.getANResponse(pushSwitchStatus);
        if (anResponse != null) {
            if (anResponse.isSuccess()) {
                PushSwitchStatus networkPushSwitchStatus = new PushSwitchStatus(anResponse.getResult());
                DebugLogger.e("Strategy", "network pushSwitchStatus " + networkPushSwitchStatus);
                if ("200".equals(pushSwitchStatus.getCode())) {
                    this.changeSyncPushStatus(false);
                    DebugLogger.e("Strategy", "update local switch preference");
                    pushSwitchStatus.setSwitchNotificationMessage(networkPushSwitchStatus.isSwitchNotificationMessage());
                    pushSwitchStatus.setSwitchThroughMessage(networkPushSwitchStatus.isSwitchThroughMessage());
                    this.switchNotification(networkPushSwitchStatus.isSwitchNotificationMessage());
                    this.switchThroughMessage(networkPushSwitchStatus.isSwitchThroughMessage());
                }
            } else {
                ANError error = anResponse.getError();
                if (error.getResponse() != null) {
                    DebugLogger.e("Strategy", "status code=" + error.getErrorCode() + " data=" + error.getResponse());
                }
                pushSwitchStatus.setCode(String.valueOf(error.getErrorCode()));
                pushSwitchStatus.setMessage(error.getErrorBody());
                DebugLogger.e("Strategy", "pushSwitchStatus " + pushSwitchStatus);
            }
        }
        DebugLogger.e("Strategy", "enableRpc " + this.enableRpc + " isSupportRemoteInvoke " + this.isSupportRemoteInvoke);
        if (this.enableRpc && !this.isSupportRemoteInvoke) {
            this.switchPushMessageSetting();
        }
        return pushSwitchStatus;
    }

    private ANResponse<String> getANResponse(PushSwitchStatus pushSwitchStatus) {
        ANResponse anResponse = null;
        switch (this.switchType) {
            case 2: {
                pushSwitchStatus.setMessage("CHECK_PUSH");
                if (this.hasNotificationSwitch() && this.hasThroughMessageSwitch() && !this.isSyncPushStatus()) {
                    pushSwitchStatus.setSwitchNotificationMessage(this.notificationSwitch());
                    pushSwitchStatus.setSwitchThroughMessage(this.throughMessageSwitch());
                    break;
                }
                this.changeSyncPushStatus(true);
                anResponse = this.pushApi.checkPush(this.appId, this.appKey, this.pushId);
                break;
            }
            case 3: {
                pushSwitchStatus.setMessage("SWITCH_ALL");
                if (this.notificationSwitch() == this.switcher && this.throughMessageSwitch() == this.switcher && !this.isSyncPushStatus()) {
                    pushSwitchStatus.setSwitchNotificationMessage(this.switcher);
                    pushSwitchStatus.setSwitchThroughMessage(this.switcher);
                    break;
                }
                this.changeSyncPushStatus(true);
                this.switchAll(this.switcher);
                anResponse = this.pushApi.switchPush(this.appId, this.appKey, this.pushId, this.switcher);
                break;
            }
            case 0: {
                pushSwitchStatus.setMessage("SWITCH_NOTIFICATION");
                if (this.notificationSwitch() == this.switcher && !this.isSyncPushStatus()) {
                    pushSwitchStatus.setSwitchNotificationMessage(this.switcher);
                    pushSwitchStatus.setSwitchThroughMessage(this.throughMessageSwitch());
                    break;
                }
                this.changeSyncPushStatus(true);
                this.switchNotification(this.switcher);
                anResponse = this.pushApi.switchPush(this.appId, this.appKey, this.pushId, this.switchType, this.switcher);
                break;
            }
            case 1: {
                pushSwitchStatus.setMessage("SWITCH_THROUGH_MESSAGE");
                if (this.throughMessageSwitch() == this.switcher && !this.isSyncPushStatus()) {
                    pushSwitchStatus.setSwitchNotificationMessage(this.notificationSwitch());
                    pushSwitchStatus.setSwitchThroughMessage(this.switcher);
                    break;
                }
                this.changeSyncPushStatus(true);
                this.switchThroughMessage(this.switcher);
                anResponse = this.pushApi.switchPush(this.appId, this.appKey, this.pushId, this.switchType, this.switcher);
                break;
            }
        }
        return anResponse;
    }

    private void switchPushMessageSetting() {
        switch (this.switchType) {
            case 0: 
            case 1: {
                PlatformMessageSender.switchPushMessageSetting(this.context, this.switchType, this.switcher, this.strategyPackageName);
                break;
            }
            case 3: {
                PlatformMessageSender.switchPushMessageSetting(this.context, 0, this.switcher, this.strategyPackageName);
                PlatformMessageSender.switchPushMessageSetting(this.context, 1, this.switcher, this.strategyPackageName);
                break;
            }
        }
    }

    @Override
    protected PushSwitchStatus localResponse() {
        switch (this.switchType) {
            case 2: 
            case 3: {
                this.switchAll(this.switcher);
                break;
            }
            case 0: {
                this.switchNotification(this.switcher);
                break;
            }
            case 1: {
                this.switchThroughMessage(this.switcher);
                break;
            }
        }
        return null;
    }

    @Override
    protected void sendReceiverMessage(PushSwitchStatus message) {
        PlatformMessageSender.sendPushStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName(), message);
    }

    @Override
    protected int strategyType() {
        return 16;
    }

    private void switchNotification(boolean switcher) {
        PushPreferencesUtils.setNotificationMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName(), switcher);
    }

    private void switchThroughMessage(boolean switcher) {
        PushPreferencesUtils.setThroughMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName(), switcher);
    }

    private void switchAll(boolean switcher) {
        PushPreferencesUtils.setNotificationMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName(), switcher);
        PushPreferencesUtils.setThroughMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName(), switcher);
    }

    private boolean notificationSwitch() {
        return PushPreferencesUtils.getNotificationMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName());
    }

    private boolean hasNotificationSwitch() {
        return PushPreferencesUtils.hasNotificationSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName());
    }

    private boolean throughMessageSwitch() {
        return PushPreferencesUtils.getThroughMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName());
    }

    private boolean hasThroughMessageSwitch() {
        return PushPreferencesUtils.hasThroughMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageName) ? this.strategyPackageName : this.context.getPackageName());
    }

    private void changeSyncPushStatus(boolean flag) {
        this.pushStatusMap.put(this.strategyPackageName + "_" + this.switchType, flag);
    }

    private boolean isSyncPushStatus() {
        Boolean pushStatus = this.pushStatusMap.get(this.strategyPackageName + "_" + this.switchType);
        boolean flag = pushStatus == null || pushStatus != false;
        DebugLogger.e("Strategy", "isSyncPushStatus " + this.strategyPackageName + " switch type->" + this.switchType + " flag->" + flag);
        return flag;
    }
}

