/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.http.Call;
import com.meizu.cloud.pushsdk.pushtracer.emitter.BaseEmitter;
import com.meizu.cloud.pushsdk.pushtracer.emitter.BufferOption;
import com.meizu.cloud.pushsdk.pushtracer.emitter.RequestCallback;
import com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Emitter;
import com.meizu.cloud.pushsdk.pushtracer.tracker.BaseTracker;
import com.meizu.cloud.pushsdk.pushtracer.tracker.Subject;
import com.meizu.cloud.pushsdk.pushtracer.tracker.classic.Tracker;
import com.meizu.cloud.pushsdk.pushtracer.utils.LogLevel;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;

public class QuickTracker {
    private static final String NAMESPACE = "PushAndroidTracker";
    private static BaseTracker tracker;
    private static BroadcastReceiver networkBroadCastReceiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static BaseTracker init(Context context, boolean isUpload) {
        if (tracker == null) {
            Class<QuickTracker> clazz = QuickTracker.class;
            // MONITORENTER : com.meizu.cloud.pushsdk.pushtracer.QuickTracker.class
            if (tracker == null) {
                BaseEmitter emitter = QuickTracker.getEmitterClassic(context, null, null);
                tracker = QuickTracker.getTrackerClassic(emitter, null, context);
            }
            // MONITOREXIT : clazz
        }
        DebugLogger.i(NAMESPACE, "can upload subject " + isUpload);
        if (!isUpload) return tracker;
        Subject subject = QuickTracker.getSubject(context);
        tracker.setSubject(subject);
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BaseTracker getAndroidTrackerClassic(Context context, Call call, RequestCallback callback) {
        if (tracker != null) return tracker;
        Class<QuickTracker> clazz = QuickTracker.class;
        synchronized (QuickTracker.class) {
            if (tracker != null) return tracker;
            BaseEmitter emitter = QuickTracker.getEmitterClassic(context, call, callback);
            tracker = QuickTracker.getTrackerClassic(emitter, null, context);
            QuickTracker.registerNetworkReceiver(context, tracker);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return tracker;
        }
    }

    private static BaseTracker getTrackerClassic(BaseEmitter emitter, Subject subject, Context context) {
        return new Tracker(new BaseTracker.TrackerBuilder(emitter, NAMESPACE, context.getPackageCodePath(), context, Tracker.class).level(LogLevel.VERBOSE).base64(false).subject(subject).threadCount(4));
    }

    private static BaseEmitter getEmitterClassic(Context context, Call call, RequestCallback callback) {
        return new Emitter(new BaseEmitter.EmitterBuilder(QuickTracker.getStaticsDomain(), context, Emitter.class).callback(callback).call(call).tick(1).option(BufferOption.DefaultGroup).sendLimit(BufferOption.DefaultGroup.getCode()).emptyLimit(2));
    }

    private static Subject getSubject(Context context) {
        return new Subject.SubjectBuilder().context(context).build();
    }

    private static void registerNetworkReceiver(Context context, final BaseTracker tracker) {
        if (networkBroadCastReceiver != null) {
            return;
        }
        networkBroadCastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (Util.isOnline(context)) {
                    Logger.e("QuickTracker", "restart track event: %s", "online true");
                    tracker.restartEventTracking();
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(networkBroadCastReceiver, filter);
    }

    private static void unRegisterNetworkReceiver(Context context) {
        if (networkBroadCastReceiver == null) {
            return;
        }
        try {
            context.unregisterReceiver(networkBroadCastReceiver);
            networkBroadCastReceiver = null;
        }
        catch (Exception e) {
            DebugLogger.e(NAMESPACE, "unRegisterReceiver exception " + e);
        }
    }

    public static void destroyTracker(Context context) {
        QuickTracker.unRegisterNetworkReceiver(context);
    }

    private static String getStaticsDomain() {
        String staticsDomain = "push-statics.meizu.com";
        if (MzSystemUtils.isOverseas()) {
            staticsDomain = "push-statics.in.meizu.com";
        }
        DebugLogger.e("QuickTracker", "current statics domain is " + staticsDomain);
        return staticsDomain;
    }
}

