/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.dataload;

import com.meizu.cloud.pushsdk.pushtracer.dataload.DataLoad;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import java.util.HashMap;
import java.util.Map;

public class TrackerDataload
implements DataLoad {
    private final String TAG = TrackerDataload.class.getSimpleName();
    private final HashMap<String, Object> dataload = new HashMap();

    @Override
    public void add(String key, String value) {
        if (value == null || value.isEmpty()) {
            Logger.i(this.TAG, "The keys value is empty, returning without adding key: " + key, new Object[0]);
            return;
        }
        this.dataload.put(key, value);
    }

    @Override
    public void add(String key, Object value) {
        if (value == null) {
            Logger.i(this.TAG, "The keys value is empty, returning without adding key: " + key, new Object[0]);
            return;
        }
        this.dataload.put(key, value);
    }

    @Override
    public void addMap(Map<String, Object> map) {
        if (map == null) {
            Logger.i(this.TAG, "Map passed in is null, returning without adding map.", new Object[0]);
            return;
        }
        this.dataload.putAll(map);
    }

    @Override
    public void addMap(Map map, Boolean base64Encoded, String typeEncoded, String typeNoEncoded) {
        if (map == null) {
            Logger.i(this.TAG, "Map passed in is null, returning nothing.", new Object[0]);
            return;
        }
        String mapString = Util.mapToJsonObject(map).toString();
        Logger.i(this.TAG, "Adding new map: " + mapString, new Object[0]);
        if (base64Encoded.booleanValue()) {
            this.add(typeEncoded, Util.base64Encode(mapString));
        } else {
            this.add(typeNoEncoded, mapString);
        }
    }

    @Override
    public Map getMap() {
        return this.dataload;
    }

    @Override
    public String toString() {
        return Util.mapToJsonObject(this.dataload).toString();
    }

    @Override
    public long getByteSize() {
        return Util.getUtf8Length(this.toString());
    }
}

