/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.emitter;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import com.meizu.cloud.pushsdk.networking.http.Call;
import com.meizu.cloud.pushsdk.networking.http.HttpURLConnectionCall;
import com.meizu.cloud.pushsdk.networking.http.MediaType;
import com.meizu.cloud.pushsdk.networking.http.Request;
import com.meizu.cloud.pushsdk.networking.http.RequestBody;
import com.meizu.cloud.pushsdk.networking.http.Response;
import com.meizu.cloud.pushsdk.pushtracer.dataload.DataLoad;
import com.meizu.cloud.pushsdk.pushtracer.dataload.SelfDescribingJson;
import com.meizu.cloud.pushsdk.pushtracer.emitter.BufferOption;
import com.meizu.cloud.pushsdk.pushtracer.emitter.EmittableEvents;
import com.meizu.cloud.pushsdk.pushtracer.emitter.HttpMethod;
import com.meizu.cloud.pushsdk.pushtracer.emitter.ReadyRequest;
import com.meizu.cloud.pushsdk.pushtracer.emitter.RequestCallback;
import com.meizu.cloud.pushsdk.pushtracer.emitter.RequestResult;
import com.meizu.cloud.pushsdk.pushtracer.emitter.RequestSecurity;
import com.meizu.cloud.pushsdk.pushtracer.storage.Store;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public abstract class BaseEmitter {
    private static final int POST_WRAPPER_BYTES = 88;
    private static final int POST_STM_BYTES = 22;
    private final String TAG = BaseEmitter.class.getSimpleName();
    private final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
    protected final Context context;
    private Uri.Builder uriBuilder;
    protected final RequestCallback requestCallback;
    private HttpMethod httpMethod;
    private BufferOption bufferOption;
    private RequestSecurity requestSecurity;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;
    private String uri;
    protected final int emitterTick;
    protected final int emptyLimit;
    protected final int sendLimit;
    private final long byteLimitGet;
    private final long byteLimitPost;
    protected final TimeUnit timeUnit;
    private final Call call;
    protected final AtomicBoolean isRunning = new AtomicBoolean(false);

    public BaseEmitter(EmitterBuilder builder) {
        this.httpMethod = builder.httpMethod;
        this.requestCallback = builder.requestCallback;
        this.context = builder.context;
        this.bufferOption = builder.bufferOption;
        this.requestSecurity = builder.requestSecurity;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.emitterTick = builder.emitterTick;
        this.emptyLimit = builder.emptyLimit;
        this.sendLimit = builder.sendLimit;
        this.byteLimitGet = builder.byteLimitGet;
        this.byteLimitPost = builder.byteLimitPost;
        this.uri = builder.uri;
        this.timeUnit = builder.timeUnit;
        this.call = builder.call;
        this.buildEmitterUri();
        Logger.i(this.TAG, "Emitter created successfully!", new Object[0]);
    }

    private void buildEmitterUri() {
        Logger.e(this.TAG, "security " + (Object)((Object)this.requestSecurity), new Object[0]);
        this.uriBuilder = this.requestSecurity == RequestSecurity.HTTP ? Uri.parse((String)("http://" + this.uri)).buildUpon() : Uri.parse((String)("https://" + this.uri)).buildUpon();
        if (this.httpMethod == HttpMethod.GET) {
            this.uriBuilder.appendPath("i");
        } else {
            this.uriBuilder.appendEncodedPath("push_data_report/mobile");
        }
    }

    private void buildHttpsSecurity() {
        if (this.requestSecurity == RequestSecurity.HTTPS) {
            if (this.sslSocketFactory == null) {
                Logger.e(this.TAG, "Https Ensure you have set SSLSocketFactory", new Object[0]);
            }
            if (this.hostnameVerifier == null) {
                Logger.e(this.TAG, "Https Ensure you have set HostnameVerifier", new Object[0]);
            }
        }
    }

    public abstract void add(DataLoad var1);

    public abstract void add(DataLoad var1, boolean var2);

    public abstract void shutdown();

    public abstract void flush();

    protected LinkedList<RequestResult> performSyncEmit(LinkedList<ReadyRequest> requests) {
        LinkedList<RequestResult> results = new LinkedList<RequestResult>();
        for (ReadyRequest request : requests) {
            int code = this.requestSender(request.getRequest());
            if (request.isOversize()) {
                results.add(new RequestResult(true, request.getEventIds()));
                continue;
            }
            results.add(new RequestResult(this.isSuccessfulSend(code), request.getEventIds()));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int requestSender(Request request) {
        Response response = null;
        try {
            Logger.d(this.TAG, "Sending request: %s", request);
            response = this.call.execute(request);
            int n = response.code();
            this.close(response);
            return n;
        }
        catch (IOException e) {
            try {
                Logger.e(this.TAG, "Request sending failed: %s", Log.getStackTraceString((Throwable)e));
                int n = -1;
                this.close(response);
                return n;
            }
            catch (Throwable throwable) {
                this.close(response);
                throw throwable;
            }
        }
    }

    private void close(Response response) {
        try {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
        catch (Exception e) {
            Logger.d(this.TAG, "Unable to close source data", new Object[0]);
        }
    }

    protected LinkedList<ReadyRequest> buildRequests(EmittableEvents events) {
        int dataLoadCount = events.getEvents().size();
        LinkedList<Long> eventIds = events.getEventIds();
        LinkedList<ReadyRequest> requests = new LinkedList<ReadyRequest>();
        if (this.httpMethod == HttpMethod.GET) {
            for (int i = 0; i < dataLoadCount; ++i) {
                LinkedList<Long> reqEventId = new LinkedList<Long>();
                reqEventId.add(eventIds.get(i));
                DataLoad dataLoad = events.getEvents().get(i);
                boolean oversize = dataLoad.getByteSize() + 22L > this.byteLimitGet;
                Request request = this.requestBuilderGet(dataLoad);
                requests.add(new ReadyRequest(oversize, request, reqEventId));
            }
        } else {
            for (int i = 0; i < dataLoadCount; i += this.bufferOption.getCode()) {
                LinkedList<Long> reqEventIds = new LinkedList<Long>();
                ArrayList<DataLoad> postDataLoadMaps = new ArrayList<DataLoad>();
                long totalByteSize = 0L;
                for (int j = i; j < i + this.bufferOption.getCode() && j < dataLoadCount; ++j) {
                    DataLoad dataLoad = events.getEvents().get(j);
                    long payloadByteSize = dataLoad.getByteSize() + 22L;
                    if (payloadByteSize + 88L > this.byteLimitPost) {
                        ArrayList<DataLoad> singlePayloadMap = new ArrayList<DataLoad>();
                        LinkedList<Long> reqEventId = new LinkedList<Long>();
                        singlePayloadMap.add(dataLoad);
                        reqEventId.add(eventIds.get(j));
                        Request request = this.requestBuilderPost(singlePayloadMap);
                        requests.add(new ReadyRequest(true, request, reqEventId));
                        continue;
                    }
                    if (totalByteSize + payloadByteSize + 88L + (long)(postDataLoadMaps.size() - 1) > this.byteLimitPost) {
                        Request request = this.requestBuilderPost(postDataLoadMaps);
                        requests.add(new ReadyRequest(false, request, reqEventIds));
                        postDataLoadMaps = new ArrayList();
                        reqEventIds = new LinkedList();
                        postDataLoadMaps.add(dataLoad);
                        reqEventIds.add(eventIds.get(j));
                        totalByteSize = payloadByteSize;
                        continue;
                    }
                    totalByteSize += payloadByteSize;
                    postDataLoadMaps.add(dataLoad);
                    reqEventIds.add(eventIds.get(j));
                }
                if (postDataLoadMaps.isEmpty()) continue;
                Request request = this.requestBuilderPost(postDataLoadMaps);
                requests.add(new ReadyRequest(false, request, reqEventIds));
            }
        }
        return requests;
    }

    private Request requestBuilderGet(DataLoad dataLoad) {
        this.addStmToEvent(dataLoad, "");
        this.uriBuilder.clearQuery();
        HashMap hashMap = (HashMap)dataLoad.getMap();
        for (String key : hashMap.keySet()) {
            String value = (String)hashMap.get(key);
            this.uriBuilder.appendQueryParameter(key, value);
        }
        String reqUrl = this.uriBuilder.build().toString();
        return new Request.Builder().url(reqUrl).get().build();
    }

    private Request requestBuilderPost(ArrayList<DataLoad> dataLoads) {
        ArrayList<Map> finalPayloads = new ArrayList<Map>();
        for (DataLoad payload : dataLoads) {
            finalPayloads.add(payload.getMap());
        }
        SelfDescribingJson postPayload = new SelfDescribingJson("push_group_data", finalPayloads);
        Logger.d(this.TAG, "final SelfDescribingJson " + postPayload, new Object[0]);
        String reqUrl = this.uriBuilder.build().toString();
        RequestBody reqBody = RequestBody.create(this.JSON, postPayload.toString());
        return new Request.Builder().url(reqUrl).post(reqBody).build();
    }

    private void addStmToEvent(DataLoad dataLoad, String timestamp) {
        dataLoad.add("stm", "".equals(timestamp) ? Util.getTimestamp() : timestamp);
    }

    public abstract Store getEventStore();

    public abstract boolean getEmitterStatus();

    protected boolean isSuccessfulSend(int code) {
        return code >= 200 && code < 300;
    }

    public void setBufferOption(BufferOption option) {
        if (!this.isRunning.get()) {
            this.bufferOption = option;
        }
    }

    public void setHttpMethod(HttpMethod method) {
        if (!this.isRunning.get()) {
            this.httpMethod = method;
            this.buildEmitterUri();
        }
    }

    public void setRequestSecurity(RequestSecurity security) {
        if (!this.isRunning.get()) {
            this.requestSecurity = security;
            this.buildEmitterUri();
        }
    }

    public void setEmitterUri(String uri) {
        if (!this.isRunning.get()) {
            this.uri = uri;
            this.buildEmitterUri();
        }
    }

    public String getEmitterUri() {
        return this.uriBuilder.clearQuery().build().toString();
    }

    public RequestCallback getRequestCallback() {
        return this.requestCallback;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public BufferOption getBufferOption() {
        return this.bufferOption;
    }

    public RequestSecurity getRequestSecurity() {
        return this.requestSecurity;
    }

    public int getEmitterTick() {
        return this.emitterTick;
    }

    public int getEmptyLimit() {
        return this.emptyLimit;
    }

    public int getSendLimit() {
        return this.sendLimit;
    }

    public long getByteLimitGet() {
        return this.byteLimitGet;
    }

    public long getByteLimitPost() {
        return this.byteLimitPost;
    }

    public static class EmitterBuilder {
        protected static Class<? extends BaseEmitter> defaultEmitterClass;
        protected final String uri;
        protected final Context context;
        protected RequestCallback requestCallback = null;
        protected HttpMethod httpMethod = HttpMethod.POST;
        protected BufferOption bufferOption = BufferOption.Single;
        protected RequestSecurity requestSecurity = RequestSecurity.HTTPS;
        protected int emitterTick = 5;
        protected int sendLimit = 250;
        protected int emptyLimit = 5;
        protected long byteLimitGet = 40000L;
        protected long byteLimitPost = 40000L;
        protected TimeUnit timeUnit = TimeUnit.SECONDS;
        protected SSLSocketFactory sslSocketFactory;
        protected HostnameVerifier hostnameVerifier;
        protected Call call = new HttpURLConnectionCall();

        public EmitterBuilder(String uri, Context context) {
            this(uri, context, defaultEmitterClass);
        }

        public EmitterBuilder(String uri, Context context, Class<? extends BaseEmitter> emitterClass) {
            this.uri = uri;
            this.context = context;
        }

        public EmitterBuilder method(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public EmitterBuilder option(BufferOption option) {
            this.bufferOption = option;
            return this;
        }

        public EmitterBuilder security(RequestSecurity requestSecurity) {
            this.requestSecurity = requestSecurity;
            return this;
        }

        public EmitterBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public EmitterBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public EmitterBuilder callback(RequestCallback requestCallback) {
            this.requestCallback = requestCallback;
            return this;
        }

        public EmitterBuilder tick(int emitterTick) {
            this.emitterTick = emitterTick;
            return this;
        }

        public EmitterBuilder sendLimit(int sendLimit) {
            this.sendLimit = sendLimit;
            return this;
        }

        public EmitterBuilder emptyLimit(int emptyLimit) {
            this.emptyLimit = emptyLimit;
            return this;
        }

        public EmitterBuilder byteLimitGet(long byteLimitGet) {
            this.byteLimitGet = byteLimitGet;
            return this;
        }

        public EmitterBuilder byteLimitPost(long byteLimitPost) {
            this.byteLimitPost = byteLimitPost;
            return this;
        }

        public EmitterBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public EmitterBuilder call(Call call) {
            if (call != null) {
                this.call = call;
                Logger.i(EmitterBuilder.class.getSimpleName(), "set new call " + call, new Object[0]);
            }
            return this;
        }

        public EmitterBuilder call(Class<Call> clazz) {
            try {
                this.call = clazz.newInstance();
                Logger.i(EmitterBuilder.class.getSimpleName(), "set new call " + this.call, new Object[0]);
            }
            catch (Exception e) {
                Logger.i(EmitterBuilder.class.getSimpleName(), "error new call " + e, new Object[0]);
            }
            return this;
        }
    }
}

