/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.emitter.classic;

import com.meizu.cloud.pushsdk.networking.http.Request;
import com.meizu.cloud.pushsdk.pushtracer.dataload.DataLoad;
import com.meizu.cloud.pushsdk.pushtracer.emitter.BaseEmitter;
import com.meizu.cloud.pushsdk.pushtracer.emitter.EmittableEvents;
import com.meizu.cloud.pushsdk.pushtracer.emitter.ReadyRequest;
import com.meizu.cloud.pushsdk.pushtracer.emitter.RequestResult;
import com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Executor;
import com.meizu.cloud.pushsdk.pushtracer.storage.EventStore;
import com.meizu.cloud.pushsdk.pushtracer.storage.MemoryStore;
import com.meizu.cloud.pushsdk.pushtracer.storage.Store;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Emitter
extends BaseEmitter {
    private final String TAG = Emitter.class.getSimpleName();
    private Store eventStore = new EventStore(this.context, this.sendLimit);
    private int emptyCount;

    public Emitter(BaseEmitter.EmitterBuilder builder) {
        super(builder);
        if (!this.eventStore.isOpen()) {
            this.eventStore = new MemoryStore(this.sendLimit);
            Logger.e(this.TAG, "init memory store", new Object[0]);
        }
    }

    @Override
    public void add(DataLoad payload) {
        this.eventStore.add(payload);
        Logger.e(this.TAG, "isRunning " + this.isRunning, new Object[0]);
        if (this.isRunning.compareAndSet(false, true)) {
            this.attemptEmit();
        }
    }

    @Override
    public void add(DataLoad payload, boolean attemptEmit) {
        this.eventStore.add(payload);
        Logger.e(this.TAG, "isRunning " + this.isRunning + " attemptEmit " + attemptEmit, new Object[0]);
        if (!attemptEmit) {
            try {
                this.timeUnit.sleep(1L);
            }
            catch (InterruptedException e) {
                Logger.e(this.TAG, "Emitter add thread sleep interrupted: " + e.toString(), new Object[0]);
            }
        }
        if (this.isRunning.compareAndSet(false, true)) {
            this.attemptEmit();
        }
    }

    @Override
    public void flush() {
        Executor.execute(new Runnable(){

            @Override
            public void run() {
                if (Emitter.this.isRunning.compareAndSet(false, true)) {
                    Emitter.this.attemptEmit();
                }
            }
        });
    }

    private void attemptEmit() {
        if (Util.isOnline(this.context)) {
            if (this.eventStore.getSize() > 0L) {
                this.emptyCount = 0;
                EmittableEvents events = this.eventStore.getEmittableEvents();
                LinkedList<ReadyRequest> requests = this.buildRequests(events);
                LinkedList<RequestResult> results = this.performAsyncEmit(requests);
                Logger.i(this.TAG, "Processing emitter results.", new Object[0]);
                int successCount = 0;
                int failureCount = 0;
                LinkedList<Long> removableEvents = new LinkedList<Long>();
                for (RequestResult res : results) {
                    if (res.getSuccess()) {
                        removableEvents.addAll(res.getEventIds());
                        successCount += res.getEventIds().size();
                        continue;
                    }
                    failureCount += res.getEventIds().size();
                    Logger.e(this.TAG, "Request sending failed but we will retry later.", new Object[0]);
                }
                this.performAsyncEventRemoval(removableEvents);
                Logger.d(this.TAG, "Success Count: %s", successCount);
                Logger.d(this.TAG, "Failure Count: %s", failureCount);
                if (this.requestCallback != null) {
                    if (failureCount != 0) {
                        this.requestCallback.onFailure(successCount, failureCount);
                    } else {
                        this.requestCallback.onSuccess(successCount);
                    }
                }
                if (failureCount > 0 && successCount == 0) {
                    if (Util.isOnline(this.context)) {
                        Logger.e(this.TAG, "Ensure collector path is valid: %s", this.getEmitterUri());
                    }
                    Logger.e(this.TAG, "Emitter loop stopping: failures.", new Object[0]);
                    this.isRunning.compareAndSet(true, false);
                } else {
                    this.attemptEmit();
                }
            } else if (this.emptyCount >= this.emptyLimit) {
                Logger.e(this.TAG, "Emitter loop stopping: empty limit reached.", new Object[0]);
                this.isRunning.compareAndSet(true, false);
                if (this.requestCallback != null) {
                    this.requestCallback.isEmpty(true);
                }
            } else {
                ++this.emptyCount;
                Logger.e(this.TAG, "Emitter database empty: " + this.emptyCount, new Object[0]);
                try {
                    this.timeUnit.sleep(this.emitterTick);
                }
                catch (InterruptedException e) {
                    Logger.e(this.TAG, "Emitter thread sleep interrupted: " + e.toString(), new Object[0]);
                }
                this.attemptEmit();
            }
        } else {
            Logger.e(this.TAG, "Emitter loop stopping: emitter offline.", new Object[0]);
            this.isRunning.compareAndSet(true, false);
        }
    }

    private LinkedList<RequestResult> performAsyncEmit(LinkedList<ReadyRequest> requests) {
        LinkedList<RequestResult> results = new LinkedList<RequestResult>();
        LinkedList<Future> futures = new LinkedList<Future>();
        for (ReadyRequest request : requests) {
            futures.add(Executor.futureCallable(this.getRequestCallable(request.getRequest())));
        }
        Logger.d(this.TAG, "Request Futures: %s", futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            int code = -1;
            try {
                code = (Integer)((Future)futures.get(i)).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                Logger.e(this.TAG, "Request Future was interrupted: %s", ie.getMessage());
            }
            catch (ExecutionException ee) {
                Logger.e(this.TAG, "Request Future failed: %s", ee.getMessage());
            }
            catch (TimeoutException te) {
                Logger.e(this.TAG, "Request Future had a timeout: %s", te.getMessage());
            }
            if (requests.get(i).isOversize()) {
                results.add(new RequestResult(true, requests.get(i).getEventIds()));
                continue;
            }
            results.add(new RequestResult(this.isSuccessfulSend(code), requests.get(i).getEventIds()));
        }
        return results;
    }

    private LinkedList<Boolean> performAsyncEventRemoval(LinkedList<Long> eventIds) {
        LinkedList<Boolean> results = new LinkedList<Boolean>();
        LinkedList<Future> futures = new LinkedList<Future>();
        for (Long id : eventIds) {
            futures.add(Executor.futureCallable(this.getRemoveCallable(id)));
        }
        Logger.d(this.TAG, "Removal Futures: %s", futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            boolean result = false;
            try {
                result = (Boolean)((Future)futures.get(i)).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                Logger.e(this.TAG, "Removal Future was interrupted: %s", ie.getMessage());
            }
            catch (ExecutionException ee) {
                Logger.e(this.TAG, "Removal Future failed: %s", ee.getMessage());
            }
            catch (TimeoutException te) {
                Logger.e(this.TAG, "Removal Future had a timeout: %s", te.getMessage());
            }
            results.add(result);
        }
        return results;
    }

    private Callable<Integer> getRequestCallable(final Request request) {
        return new Callable<Integer>(){

            @Override
            public Integer call() {
                return Emitter.this.requestSender(request);
            }
        };
    }

    private Callable<Boolean> getRemoveCallable(final Long eventId) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return Emitter.this.eventStore.removeEvent(eventId);
            }
        };
    }

    @Override
    public void shutdown() {
        Logger.d(this.TAG, "Shutting down emitter.", new Object[0]);
        this.isRunning.compareAndSet(true, false);
        Executor.shutdown();
    }

    @Override
    public Store getEventStore() {
        return this.eventStore;
    }

    @Override
    public boolean getEmitterStatus() {
        return this.isRunning.get();
    }
}

