/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.event;

import com.meizu.cloud.pushsdk.pushtracer.dataload.SelfDescribingJson;
import com.meizu.cloud.pushsdk.pushtracer.dataload.TrackerDataload;
import com.meizu.cloud.pushsdk.pushtracer.utils.Preconditions;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Event {
    private final List<SelfDescribingJson> selfDescribingJsonList;
    private final long timestamp;
    private final String eventId;

    public static Builder<?> builder() {
        return new Builder2();
    }

    protected Event(Builder<?> builder) {
        Preconditions.checkNotNull(((Builder)builder).selfDescribingJsonList);
        Preconditions.checkNotNull(((Builder)builder).eventId);
        Preconditions.checkArgument(!((Builder)builder).eventId.isEmpty(), "eventId cannot be empty");
        this.selfDescribingJsonList = ((Builder)builder).selfDescribingJsonList;
        this.timestamp = ((Builder)builder).timestamp;
        this.eventId = ((Builder)builder).eventId;
    }

    public List<SelfDescribingJson> getSelfDescribingJson() {
        return new ArrayList<SelfDescribingJson>(this.selfDescribingJsonList);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getEventId() {
        return this.eventId;
    }

    protected TrackerDataload putDefaultParams(TrackerDataload payload) {
        payload.add("ei", this.getEventId());
        payload.add("ts", Long.toString(this.getTimestamp()));
        return payload;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private List<SelfDescribingJson> selfDescribingJsonList = new LinkedList<SelfDescribingJson>();
        private long timestamp = System.currentTimeMillis();
        private String eventId = Util.getEventId();

        protected abstract T self();

        public T customContext(List<SelfDescribingJson> context) {
            this.selfDescribingJsonList = context;
            return this.self();
        }

        public T timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this.self();
        }

        public T eventId(String eventId) {
            this.eventId = eventId;
            return this.self();
        }

        public Event build() {
            return new Event(this);
        }
    }
}

