/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.tracker;

import android.content.Context;
import com.meizu.cloud.pushsdk.pushtracer.dataload.SelfDescribingJson;
import com.meizu.cloud.pushsdk.pushtracer.utils.FileStore;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Session {
    private static final String TAG = Session.class.getSimpleName();
    private static final int SESSION_VALUES_MAP_SIZE = 8;
    private String userId;
    private String currentSessionId = null;
    private String previousSessionId;
    private int sessionIndex = 0;
    private final String sessionStorage = "SQLITE";
    private final AtomicBoolean isBackground = new AtomicBoolean(false);
    private long accessedLast;
    private final long foregroundTimeout;
    private final long backgroundTimeout;
    private final Context context;

    public Session(long foregroundTimeout, long backgroundTimeout, TimeUnit timeUnit, Context context) {
        this.foregroundTimeout = timeUnit.toMillis(foregroundTimeout);
        this.backgroundTimeout = timeUnit.toMillis(backgroundTimeout);
        this.context = context;
        Map sessionInfo = this.getSessionFromFile();
        if (sessionInfo == null) {
            this.userId = Util.getEventId();
        } else {
            try {
                String uid = sessionInfo.get("userId").toString();
                String sid = sessionInfo.get("sessionId").toString();
                int si = (Integer)sessionInfo.get("sessionIndex");
                this.userId = uid;
                this.sessionIndex = si;
                this.currentSessionId = sid;
            }
            catch (Exception e) {
                Logger.e(TAG, "Exception occurred retrieving session info from file: %s", e.getMessage());
                this.userId = Util.getEventId();
            }
        }
        this.updateSessionInfo();
        this.updateAccessedTime();
        Logger.i(TAG, "Tracker Session Object created.", new Object[0]);
    }

    public SelfDescribingJson getSessionContext() {
        Logger.i(TAG, "Getting session context...", new Object[0]);
        this.updateAccessedTime();
        return new SelfDescribingJson("client_session", this.getSessionValues());
    }

    public void checkAndUpdateSession() {
        Logger.d(TAG, "Checking and updating session information.", new Object[0]);
        long checkTime = System.currentTimeMillis();
        long range = this.isBackground.get() ? this.backgroundTimeout : this.foregroundTimeout;
        if (!Util.isTimeInRange(this.accessedLast, checkTime, range)) {
            this.updateSessionInfo();
            this.updateAccessedTime();
        }
    }

    public void setIsBackground(boolean isBackground) {
        Logger.d(TAG, "Application is in the background: %s", isBackground);
        this.isBackground.set(isBackground);
    }

    public Map getSessionValues() {
        HashMap<String, Object> sessionValues = new HashMap<String, Object>(8);
        sessionValues.put("userId", this.userId);
        sessionValues.put("sessionId", this.currentSessionId);
        sessionValues.put("previousSessionId", this.previousSessionId);
        sessionValues.put("sessionIndex", this.sessionIndex);
        sessionValues.put("storageMechanism", this.sessionStorage);
        return sessionValues;
    }

    private void updateSessionInfo() {
        this.previousSessionId = this.currentSessionId;
        this.currentSessionId = Util.getEventId();
        ++this.sessionIndex;
        Logger.d(TAG, "Session information is updated:", new Object[0]);
        Logger.d(TAG, " + Session ID: %s", this.currentSessionId);
        Logger.d(TAG, " + Previous Session ID: %s", this.previousSessionId);
        Logger.d(TAG, " + Session Index: %s", this.sessionIndex);
        this.saveSessionToFile();
    }

    private boolean saveSessionToFile() {
        return FileStore.saveMapToFile("snowplow_session_vars", this.getSessionValues(), this.context);
    }

    private Map getSessionFromFile() {
        return FileStore.getMapFromFile("snowplow_session_vars", this.context);
    }

    private void updateAccessedTime() {
        this.accessedLast = System.currentTimeMillis();
    }

    public int getSessionIndex() {
        return this.sessionIndex;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCurrentSessionId() {
        return this.currentSessionId;
    }

    public String getPreviousSessionId() {
        return this.previousSessionId;
    }

    public String getSessionStorage() {
        return this.sessionStorage;
    }

    public long getForegroundTimeout() {
        return this.foregroundTimeout;
    }

    public long getBackgroundTimeout() {
        return this.backgroundTimeout;
    }
}

