/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.tracker;

import android.content.Context;
import android.os.Build;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import java.util.HashMap;
import java.util.Map;

public class Subject {
    private static final String TAG = Subject.class.getSimpleName();
    private final HashMap<String, String> standardPairs = new HashMap();
    private final HashMap<String, Object> geoLocationPairs = new HashMap();
    private final HashMap<String, String> mobilePairs = new HashMap();

    private Subject(SubjectBuilder builder) {
        this.setOsType();
        this.setOsVersion();
        this.setDeviceModel();
        this.setDeviceVendor();
        if (builder.context != null) {
            this.setContextualParams(builder.context);
        }
        Logger.i(TAG, "Subject created successfully.", new Object[0]);
    }

    public void setContextualParams(Context context) {
        this.setCarrier(context);
    }

    private void addToMobileContext(String key, String value) {
        if (key != null && value != null && !key.isEmpty() && !value.isEmpty()) {
            this.mobilePairs.put(key, value);
        }
    }

    private void setOsType() {
        this.addToMobileContext("ot", "android-" + Build.VERSION.RELEASE);
    }

    private void setOsVersion() {
        this.addToMobileContext("ov", Build.DISPLAY);
    }

    private void setDeviceModel() {
        this.addToMobileContext("dm", Build.MODEL);
    }

    private void setDeviceVendor() {
        this.addToMobileContext("df", Build.MANUFACTURER);
    }

    public void setCarrier(Context context) {
        String carrier = Util.getCarrier(context);
        if (carrier != null) {
            this.addToMobileContext("ca", carrier);
        }
    }

    public void setUserId(String userId) {
        this.standardPairs.put("uid", userId);
    }

    public void setScreenResolution(int width, int height) {
        String res = width + "x" + height;
        this.standardPairs.put("res", res);
    }

    public void setViewPort(int width, int height) {
        String res = width + "x" + height;
        this.standardPairs.put("vp", res);
    }

    public void setColorDepth(int depth) {
        this.standardPairs.put("cd", Integer.toString(depth));
    }

    public void setTimezone(String timezone) {
        this.standardPairs.put("tz", timezone);
    }

    public void setLanguage(String language) {
        this.standardPairs.put("lang", language);
    }

    public void setIpAddress(String ipAddress) {
        this.standardPairs.put("ip", ipAddress);
    }

    public void setUserAgent(String userAgent) {
        this.standardPairs.put("ua", userAgent);
    }

    public void setNetworkUserId(String networkUserId) {
        this.standardPairs.put("tnuid", networkUserId);
    }

    public void setDomainUserId(String domainUserId) {
        this.standardPairs.put("duid", domainUserId);
    }

    public Map<String, Object> getSubjectLocation() {
        return this.geoLocationPairs;
    }

    public Map<String, String> getSubjectMobile() {
        return this.mobilePairs;
    }

    public Map<String, String> getSubject() {
        return this.standardPairs;
    }

    public static class SubjectBuilder {
        private Context context = null;

        public SubjectBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public Subject build() {
            return new Subject(this);
        }
    }
}

