/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Base64;
import android.view.Display;
import android.view.WindowManager;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Util {
    private static final String TAG = Util.class.getSimpleName();

    public static JSONObject mapToJsonObject(Map map) {
        if (Build.VERSION.SDK_INT >= 19) {
            return new JSONObject(map);
        }
        JSONObject retObject = new JSONObject();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = Util.getJsonSafeObject(entry.getValue());
            try {
                retObject.put(key, value);
            }
            catch (JSONException e) {
                Logger.e(TAG, "Could not put key '%s' and value '%s' into new JSONObject: %s", new Object[]{key, value, e});
                e.printStackTrace();
            }
        }
        return retObject;
    }

    private static Object getJsonSafeObject(Object o) {
        if (Build.VERSION.SDK_INT >= 19) {
            return o;
        }
        if (o == null) {
            return JSONObject.NULL;
        }
        if (o instanceof JSONObject || o instanceof JSONArray) {
            return o;
        }
        if (o instanceof Collection) {
            JSONArray retArray = new JSONArray();
            for (Object entry : (Collection)o) {
                retArray.put(Util.getJsonSafeObject(entry));
            }
            return retArray;
        }
        if (o.getClass().isArray()) {
            JSONArray retArray = new JSONArray();
            int length = Array.getLength(o);
            for (int i = 0; i < length; ++i) {
                retArray.put(Util.getJsonSafeObject(Array.get(o, i)));
            }
            return retArray;
        }
        if (o instanceof Map) {
            return Util.mapToJsonObject((Map)o);
        }
        if (o instanceof Boolean || o instanceof Byte || o instanceof Character || o instanceof Double || o instanceof Float || o instanceof Integer || o instanceof Long || o instanceof Short || o instanceof String) {
            return o;
        }
        if (o.getClass().getPackage().getName().startsWith("java.")) {
            return o.toString();
        }
        return null;
    }

    public static long getUtf8Length(String s) {
        long len = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char code = s.charAt(i);
            if (code <= '\u007f') {
                ++len;
                continue;
            }
            if (code <= '\u07ff') {
                len += 2L;
                continue;
            }
            if (code >= '\ud800' && code <= '\udfff') {
                len += 4L;
                ++i;
                continue;
            }
            if (code < '\uffff') {
                len += 3L;
                continue;
            }
            len += 4L;
        }
        return len;
    }

    public static String base64Encode(String string) {
        return Base64.encodeToString((byte[])string.getBytes(), (int)2);
    }

    public static String getTimestamp() {
        return Long.toString(System.currentTimeMillis());
    }

    public static boolean isOnline(Context context) {
        try {
            Logger.i(TAG, "Checking tracker internet connectivity.", new Object[0]);
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return false;
            }
            NetworkInfo ni = cm.getActiveNetworkInfo();
            boolean connected = ni != null && ni.isConnected();
            Logger.d(TAG, "Tracker connection online: %s", connected);
            return connected;
        }
        catch (Exception e) {
            Logger.e(TAG, "Security exception checking connection: %s", e.toString());
            return true;
        }
    }

    public static String getCarrier(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                return telephonyManager.getNetworkOperatorName();
            }
        }
        catch (Exception e) {
            Logger.e(TAG, "getCarrier: %s", e.toString());
        }
        return null;
    }

    public static String getOperator(Context context) {
        String simOperator = null;
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null) {
                simOperator = tm.getSimOperator();
            }
        }
        catch (Exception e) {
            Logger.e(TAG, "getOperator error " + e.getMessage(), new Object[0]);
        }
        return simOperator;
    }

    public static boolean isTimeInRange(long startTime, long checkTime, long range) {
        return startTime > checkTime - range;
    }

    public static String getEventId() {
        return UUID.randomUUID().toString();
    }

    @TargetApi(value=19)
    public static Point getDefaultScreenResolution(Context context) {
        Display display = null;
        Point size = new Point();
        try {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            if (windowManager == null) {
                return null;
            }
            display = windowManager.getDefaultDisplay();
            Class[] parTypes = new Class[]{Point.class};
            Display.class.getMethod("getSize", parTypes);
            display.getSize(size);
        }
        catch (Exception e) {
            Logger.e(TAG, "Display.getSize isn't available on older devices.", new Object[0]);
            if (display != null) {
                size.x = display.getWidth();
                size.y = display.getHeight();
            }
            Logger.e(TAG, "error get display", new Object[0]);
        }
        return size;
    }
}

