/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class Connectivity {
    public static NetworkInfo getNetworkInfo(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return null;
            }
            return cm.getActiveNetworkInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isConnected(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected();
    }

    public static boolean isConnectedWifi(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected() && info.getType() == 1;
    }

    public static boolean isConnectedMobile(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected() && info.getType() == 0;
    }

    public static boolean isConnectedFast(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected() && Connectivity.isConnectionFast(info.getType(), info.getSubtype());
    }

    private static boolean isConnectionFast(int type, int subType) {
        if (type == 1) {
            return true;
        }
        if (type == 0) {
            switch (subType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: {
                    return false;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    return true;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

