/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.analytics.FastTracker;
import com.meizu.cloud.pushsdk.base.BuildExt;
import com.meizu.cloud.pushsdk.base.SystemProperties;
import com.meizu.cloud.pushsdk.base.reflect.ReflectResult;
import java.io.File;
import java.util.List;
import java.util.Locale;

public class MzSystemUtils {
    private static final String TAG = "MzSystemUtils";
    private static final String PUSH_SERVICE_PROCESS_NAME = "mzservice_v1";
    private static int flymeVersion = -1;
    private static String sCharacteristics;

    private static String getServicesByPackageName(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        ServiceInfo[] serviceInfo = null;
        try {
            serviceInfo = packageManager.getPackageInfo((String)packageName, (int)4).services;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serviceInfo == null) {
            return null;
        }
        for (ServiceInfo info : serviceInfo) {
            if (!"com.meizu.cloud.pushsdk.pushservice.MzPushService".equals(info.name)) continue;
            return info.processName;
        }
        return null;
    }

    public static String getMzPushServicePackageName(Context context) {
        String packageName = context.getPackageName();
        try {
            String pushPackageName = MzSystemUtils.isWatch() ? "com.meizu.wearable.cloud" : "com.meizu.cloud";
            String mzPushserviceProcessName = MzSystemUtils.getServicesByPackageName(context, pushPackageName);
            if (!TextUtils.isEmpty((CharSequence)mzPushserviceProcessName) && mzPushserviceProcessName.contains(PUSH_SERVICE_PROCESS_NAME)) {
                packageName = pushPackageName;
                return packageName;
            }
        }
        catch (Exception var8) {
            var8.printStackTrace();
        }
        DebugLogger.i(TAG, "start service package name " + packageName);
        return packageName;
    }

    public static String getAppVersionName(Context context, String packageName) {
        String versionName;
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            versionName = pi.versionName;
            if (versionName == null || versionName.length() <= 0) {
                return "";
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "Exception message " + e.getMessage());
            return "";
        }
        return versionName;
    }

    public static boolean compareVersion(String version1, String version2) {
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0 && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        return diff >= 0;
    }

    public static void sendMessageFromBroadcast(Context paramContext, Intent paramIntent, String action, String packageName) {
        String name;
        if (!TextUtils.isEmpty((CharSequence)action)) {
            paramIntent.setAction(action);
        }
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            paramIntent.setPackage(packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)(name = MzSystemUtils.findReceiver(paramContext, action, packageName)))) {
            paramIntent.setClassName(packageName, name);
        }
        paramContext.sendBroadcast(paramIntent);
    }

    public static String findReceiver(Context paramContext, String action, String packageName) {
        if (TextUtils.isEmpty((CharSequence)action) || TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        try {
            Intent localIntent = new Intent(action);
            localIntent.setPackage(packageName);
            List localList = paramContext.getPackageManager().queryBroadcastReceivers(localIntent, 0);
            if (localList != null && localList.size() > 0) {
                return ((ResolveInfo)localList.get((int)0)).activityInfo.name;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isBrandMeizu(Context context) {
        boolean isMeizu;
        String model = SystemProperties.get("ro.meizu.product.model");
        boolean bl = isMeizu = !TextUtils.isEmpty((CharSequence)model) || "meizu".equalsIgnoreCase(Build.BRAND) || "22c4185e".equalsIgnoreCase(Build.BRAND);
        if (!isMeizu) {
            model = SystemProperties.get("ro.product.other.brand");
            isMeizu = model.equalsIgnoreCase("Unisoc");
        }
        if (!isMeizu) {
            FastTracker.uploadData(context.getApplicationContext());
        }
        return isMeizu;
    }

    public static boolean isMeizu(Context context) {
        return MzSystemUtils.isBrandMeizu(context);
    }

    public static boolean isWatch() {
        if (TextUtils.isEmpty((CharSequence)sCharacteristics)) {
            sCharacteristics = SystemProperties.get("ro.build.characteristics");
        }
        if (TextUtils.isEmpty((CharSequence)sCharacteristics)) {
            sCharacteristics = "phone";
            return false;
        }
        return sCharacteristics.contains("watch");
    }

    public static boolean isHuaWei() {
        String emui = SystemProperties.get("ro.build.version.emui");
        DebugLogger.e(TAG, "huawei eui " + emui);
        return !TextUtils.isEmpty((CharSequence)emui);
    }

    public static boolean isXiaoMi() {
        return "Xiaomi".equals(Build.MODEL) || "Xiaomi".equals(Build.MANUFACTURER);
    }

    public static boolean isOverseas() {
        return MzSystemUtils.isInternational() || MzSystemUtils.isIndiaLocal();
    }

    public static boolean isInternational() {
        return BuildExt.isInternational().ok ? (Boolean)BuildExt.isInternational().value : false;
    }

    public static boolean isIndiaLocal() {
        String result = SystemProperties.get("ro.meizu.locale.region");
        return "india".equals(result);
    }

    public static boolean isMeizuAndFlyme() {
        ReflectResult<Boolean> result = BuildExt.isRom();
        if (result.ok) {
            return (Boolean)result.value == false;
        }
        return false;
    }

    public static String getNetWorkType(Context context) {
        String netWorkType = "";
        try {
            NetworkInfo ni;
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = ni = cm != null ? cm.getActiveNetworkInfo() : null;
            if (ni != null) {
                int type = ni.getType();
                block1 : switch (type) {
                    case 1: {
                        netWorkType = "WIFI";
                        break;
                    }
                    case 9: {
                        netWorkType = "ETHERNET";
                        break;
                    }
                    case 7: {
                        netWorkType = "BLUETOOTH";
                        break;
                    }
                    case 0: {
                        switch (ni.getSubtype()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 7: 
                            case 11: {
                                netWorkType = "MOBILE_2G";
                                break block1;
                            }
                            case 3: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 12: 
                            case 14: 
                            case 15: {
                                netWorkType = "MOBILE_3G";
                                break block1;
                            }
                            case 13: 
                            case 18: {
                                netWorkType = "MOBILE_4G";
                                break block1;
                            }
                            case 20: {
                                return "MOBILE_5G";
                            }
                        }
                        netWorkType = "MOBILE_XG";
                        break;
                    }
                    default: {
                        netWorkType = "OTHER";
                    }
                }
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "Security exception checking connection: " + e.getMessage());
        }
        return netWorkType;
    }

    public static String getCurrentLanguage() {
        try {
            return Locale.getDefault().getLanguage();
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "getCurrentLanguage error " + e.getMessage());
            return null;
        }
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int getAppVersionCode(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            return info.versionCode;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isPackageInstalled(Context context, String packageName) {
        try {
            context.getPackageManager().getPackageInfo(packageName, 0);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isRunningProcess(Context context, String packageName) {
        boolean running = false;
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            if (am == null) {
                return false;
            }
            List processInfoList = am.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo info : processInfoList) {
                running = info.processName.contains(packageName);
                if (!running) continue;
                break;
            }
            DebugLogger.i(TAG, packageName + " is running " + running);
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "can not get running process info so set running true");
            running = true;
        }
        return running;
    }

    public static String getProcessName(Context context) {
        try {
            int pid = Process.myPid();
            String processName = "";
            ActivityManager manager = (ActivityManager)context.getApplicationContext().getSystemService("activity");
            if (manager == null) {
                return null;
            }
            for (ActivityManager.RunningAppProcessInfo process : manager.getRunningAppProcesses()) {
                DebugLogger.i(TAG, "processName " + process.processName);
                if (process.pid != pid) continue;
                processName = process.processName;
                break;
            }
            return processName;
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "getProcessName error " + e.getMessage());
            return null;
        }
    }

    public static boolean isExistReceiver(Context context, String packageName, String action) {
        String receiverName;
        if (TextUtils.isEmpty((CharSequence)action) || TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        boolean flag = false;
        Intent localIntent = new Intent(action);
        localIntent.setPackage(packageName);
        List localList = context.getPackageManager().queryBroadcastReceivers(localIntent, 0);
        if (localList != null && localList.size() > 0 && !TextUtils.isEmpty((CharSequence)(receiverName = ((ResolveInfo)localList.get((int)0)).activityInfo.name))) {
            flag = true;
        }
        return flag;
    }

    public static boolean isInteractive(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return true;
        }
        try {
            return Build.VERSION.SDK_INT >= 20 ? powerManager.isInteractive() : powerManager.isScreenOn();
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "isScreenOn error " + e.getMessage());
            return true;
        }
    }

    public static String getDocumentsPath(Context context) {
        File file = context.getExternalFilesDir(Build.VERSION.SDK_INT >= 19 ? Environment.DIRECTORY_DOCUMENTS : "Documents");
        if (file != null) {
            return file.getPath();
        }
        return "/storage/emulated/0/Android/data/" + context.getPackageName() + "/files/Documents";
    }

    public static int getFlymeVersion() {
        if (flymeVersion > 0) {
            return flymeVersion;
        }
        try {
            String fullVersion = SystemProperties.get("ro.build.flyme.version");
            try {
                flymeVersion = Integer.parseInt(fullVersion);
                return flymeVersion;
            }
            catch (Exception e) {
                fullVersion = SystemProperties.get("ro.flyme.version.id");
                if (TextUtils.isEmpty((CharSequence)fullVersion)) {
                    fullVersion = SystemProperties.get("ro.build.display.id");
                }
                fullVersion = fullVersion.replace("Flyme", "").replace(" ", "");
                String version = fullVersion.substring(0, 1);
                flymeVersion = Integer.valueOf(version);
                return flymeVersion;
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "getFlymeVersion error " + e.getMessage());
            return -1;
        }
    }
}

