/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.content.Context;
import android.content.SharedPreferences;
import com.meizu.cloud.pushinternal.DebugLogger;
import java.util.Set;

public class PushPreferencesUtils {
    public static final String MZ_PUSH_PREFERENCE = "mz_push_preference";
    public static final String MZ_PUSH_PREFERENCE_NEW = "mz_push_preference_new";
    private static final String MZ_PUSH_PREFIX_NOTIFICATION_ID = ".notification_id";
    private static final String MZ_PUSH_PREFIX_PUSH_TASK_ID = ".notification_push_task_id";
    private static final String MZ_PUSH_PREFIX_MESSAGE_SEQ = ".message_seq";
    private static final String MZ_PUSH_PREFIX_NOTIFY_ID = ".notify_id";
    private static final String MZ_PUSH_PREFIX_ENCRYPTION_PUBLIC_KEY = ".encryption_public_key";
    private static final String MZ_PUSH_PREFIX_ENCRYPTION_PUBLIC_KEY_EXPIRE_TIME = ".encryption_public_key_expire_time";
    private static final String MZ_PUSH_FIRST_REQUEST_PUBLIC_KEY = ".first_request_publicKey";
    private static final String MZ_PUSH_AD_LAST_CLOSE_TIME = ".ad_last_close_time";

    private static SharedPreferences getSharePreferenceByName(Context context, String name) {
        return context.getSharedPreferences(name, 0);
    }

    public static void putStringByKey(Context context, String preferenceName, String key, String value) {
        SharedPreferences sharedPreferences = PushPreferencesUtils.getSharePreferenceByName(context, preferenceName);
        sharedPreferences.edit().putString(key, value).apply();
    }

    public static String getStringByKey(Context context, String preferenceName, String key) {
        return PushPreferencesUtils.getSharePreferenceByName(context, preferenceName).getString(key, "");
    }

    public static Set<String> getStringSetByKey(Context context, String preferenceName, String key) {
        return PushPreferencesUtils.getSharePreferenceByName(context, preferenceName).getStringSet(key, null);
    }

    public static void putStringSetByKey(Context context, String preferenceName, String key, Set<String> stringSet) {
        PushPreferencesUtils.getSharePreferenceByName(context, preferenceName).edit().putStringSet(key, stringSet).commit();
    }

    public static void putIntByKey(Context context, String preferenceName, String key, int value) {
        SharedPreferences sharedPreferences = PushPreferencesUtils.getSharePreferenceByName(context, preferenceName);
        sharedPreferences.edit().putInt(key, value).apply();
    }

    public static int getIntByKey(Context context, String preferenceName, String key) {
        return PushPreferencesUtils.getSharePreferenceByName(context, preferenceName).getInt(key, 0);
    }

    public static void putLongByKey(Context context, String preferenceName, String key, long value) {
        SharedPreferences sharedPreferences = PushPreferencesUtils.getSharePreferenceByName(context, preferenceName);
        sharedPreferences.edit().putLong(key, value).apply();
    }

    public static long getLongByKey(Context context, String preferenceName, String key) {
        return PushPreferencesUtils.getSharePreferenceByName(context, preferenceName).getLong(key, 0L);
    }

    public static void putBooleanByKey(Context context, String preferenceName, String key, boolean value) {
        SharedPreferences sharedPreferences = PushPreferencesUtils.getSharePreferenceByName(context, preferenceName);
        sharedPreferences.edit().putBoolean(key, value).apply();
    }

    public static void putBooleanByKey(Context context, String preferenceName, String key, boolean value, boolean commit) {
        if (!commit) {
            PushPreferencesUtils.putBooleanByKey(context, preferenceName, key, value);
            return;
        }
        SharedPreferences sharedPreferences = PushPreferencesUtils.getSharePreferenceByName(context, preferenceName);
        sharedPreferences.edit().putBoolean(key, value).commit();
    }

    public static boolean getBooleanByKey(Context context, String preferenceName, String key) {
        return PushPreferencesUtils.getSharePreferenceByName(context, preferenceName).getBoolean(key, true);
    }

    public static boolean getBooleanByKey(Context context, String preferenceName, String key, boolean defValue) {
        return PushPreferencesUtils.getSharePreferenceByName(context, preferenceName).getBoolean(key, defValue);
    }

    public static boolean remove(Context context, String preferenceName, String key) {
        return PushPreferencesUtils.getSharePreferenceByName(context, preferenceName).edit().remove(key).commit();
    }

    public static boolean hasKey(Context context, String preferenceName, String key) {
        return PushPreferencesUtils.getSharePreferenceByName(context, preferenceName).contains(key);
    }

    public static String getPushId(Context context, String pkg) {
        return PushPreferencesUtils.getStringByKey(context, "com.meizu.flyme.push", pkg + "_" + "pushId");
    }

    public static void putPushId(Context context, String pushId, String pkg) {
        PushPreferencesUtils.putStringByKey(context, "com.meizu.flyme.push", pkg + "_" + "pushId", pushId);
    }

    public static void putPushIdExpireTime(Context context, int expireTime, String pkg) {
        PushPreferencesUtils.putIntByKey(context, "com.meizu.flyme.push", pkg + "_" + "pushId_expire_time", expireTime);
    }

    public static int getPushIdExpireTime(Context context, String pkg) {
        return PushPreferencesUtils.getIntByKey(context, "com.meizu.flyme.push", pkg + "_" + "pushId_expire_time");
    }

    public static String getDeviceId(Context context) {
        return PushPreferencesUtils.getSharePreferenceByName(context, MZ_PUSH_PREFERENCE).getString("statistics_imei_key", null);
    }

    public static void putDeviceId(Context context, String deviceId) {
        PushPreferencesUtils.putStringByKey(context, MZ_PUSH_PREFERENCE, "statistics_imei_key", deviceId);
    }

    public static void putDiscardNotificationIdByPackageName(Context context, String pkg, int notificationId) {
        PushPreferencesUtils.putIntByKey(context, MZ_PUSH_PREFERENCE, pkg + MZ_PUSH_PREFIX_NOTIFICATION_ID, notificationId);
    }

    public static int getDiscardNotificationId(Context context, String pkg) {
        return PushPreferencesUtils.getSharePreferenceByName(context, MZ_PUSH_PREFERENCE).getInt(pkg + MZ_PUSH_PREFIX_NOTIFICATION_ID, 0);
    }

    public static void putDiscardNotificationTaskId(Context context, String pkg, int taskId) {
        PushPreferencesUtils.putIntByKey(context, MZ_PUSH_PREFERENCE, pkg + MZ_PUSH_PREFIX_PUSH_TASK_ID, taskId);
    }

    public static int getDiscardNotificationTaskId(Context context, String pkg) {
        return PushPreferencesUtils.getSharePreferenceByName(context, MZ_PUSH_PREFERENCE).getInt(pkg + MZ_PUSH_PREFIX_PUSH_TASK_ID, 0);
    }

    public static void setNotificationMessageSwitchStatus(Context context, String desPackageName, boolean switcher) {
        PushPreferencesUtils.putBooleanByKey(context, MZ_PUSH_PREFERENCE, "switch_notification_message_" + desPackageName, switcher);
    }

    public static boolean getNotificationMessageSwitchStatus(Context context, String desPackageName) {
        return PushPreferencesUtils.getBooleanByKey(context, MZ_PUSH_PREFERENCE, "switch_notification_message_" + desPackageName);
    }

    public static boolean hasNotificationSwitchStatus(Context context, String desPackageName) {
        return PushPreferencesUtils.hasKey(context, MZ_PUSH_PREFERENCE, "switch_notification_message_" + desPackageName);
    }

    public static void setAlias(Context context, String desPackageName, String alias) {
        PushPreferencesUtils.putStringByKey(context, MZ_PUSH_PREFERENCE, "push_alias_" + desPackageName, alias);
    }

    public static String getAlias(Context context, String desPackageName) {
        return PushPreferencesUtils.getStringByKey(context, MZ_PUSH_PREFERENCE, "push_alias_" + desPackageName);
    }

    public static void setThroughMessageSwitchStatus(Context context, String desPackageName, boolean switcher) {
        PushPreferencesUtils.putBooleanByKey(context, MZ_PUSH_PREFERENCE, "switch_through_message_" + desPackageName, switcher);
    }

    public static boolean getThroughMessageSwitchStatus(Context context, String desPackageName) {
        return PushPreferencesUtils.getBooleanByKey(context, MZ_PUSH_PREFERENCE, "switch_through_message_" + desPackageName);
    }

    public static boolean hasThroughMessageSwitchStatus(Context context, String desPackageName) {
        return PushPreferencesUtils.hasKey(context, MZ_PUSH_PREFERENCE, "switch_through_message_" + desPackageName);
    }

    public static void putMessageSeq(Context context, String packageName, int messageSeq) {
        PushPreferencesUtils.putIntByKey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_PREFIX_MESSAGE_SEQ, messageSeq);
    }

    public static int getMessageSeqInCrease(Context context, String packageName) {
        int messageSeq = PushPreferencesUtils.getIntByKey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_PREFIX_MESSAGE_SEQ);
        PushPreferencesUtils.putMessageSeq(context, packageName, ++messageSeq);
        DebugLogger.e(MZ_PUSH_PREFERENCE, "current messageSeq " + messageSeq);
        return messageSeq;
    }

    public static void putNotifyIdByPackageName(Context context, String packageName, Set<String> notify) {
        PushPreferencesUtils.putStringSetByKey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_PREFIX_NOTIFY_ID, notify);
    }

    public static Set<String> getNotifyIdByPackageName(Context context, String packageName) {
        return PushPreferencesUtils.getStringSetByKey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_PREFIX_NOTIFY_ID);
    }

    public static void putNotifyIdByNotifyKey(Context context, String packageName, String notifyKey, int notifyId) {
        PushPreferencesUtils.putIntByKey(context, MZ_PUSH_PREFERENCE, packageName + "." + notifyKey, notifyId);
    }

    public static int getNotifyIdByNotifyKey(Context context, String packageName, String notifyKey) {
        return PushPreferencesUtils.getIntByKey(context, MZ_PUSH_PREFERENCE, packageName + "." + notifyKey);
    }

    public static boolean removeNotifyKey(Context context, String packageName, String notifyKey) {
        return PushPreferencesUtils.remove(context, MZ_PUSH_PREFERENCE, packageName + "." + notifyKey);
    }

    public static void putPublicKeyByPackageName(Context context, String packageName, String publicKey) {
        PushPreferencesUtils.putStringByKey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_PREFIX_ENCRYPTION_PUBLIC_KEY, publicKey);
    }

    public static String getPublicKeyByPackageName(Context context, String packageName) {
        return PushPreferencesUtils.getStringByKey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_PREFIX_ENCRYPTION_PUBLIC_KEY);
    }

    public static void putPublicKeyExpireTime(Context context, String packageName, int expireTime) {
        PushPreferencesUtils.putIntByKey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_PREFIX_ENCRYPTION_PUBLIC_KEY_EXPIRE_TIME, expireTime);
    }

    public static int getPublicKeyExpireTime(Context context, String packageName) {
        return PushPreferencesUtils.getIntByKey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_PREFIX_ENCRYPTION_PUBLIC_KEY_EXPIRE_TIME);
    }

    public static void putFirstRequestPublicKey(Context context, String packageName, boolean first) {
        PushPreferencesUtils.putBooleanByKey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_FIRST_REQUEST_PUBLIC_KEY, first);
    }

    public static boolean getFirstRequestPublicKey(Context context, String packageName) {
        return PushPreferencesUtils.getBooleanByKey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_FIRST_REQUEST_PUBLIC_KEY);
    }

    public static void putAdLastCloseTime(Context context, String packageName, long time) {
        PushPreferencesUtils.putLongByKey(context, MZ_PUSH_PREFERENCE_NEW, packageName + MZ_PUSH_AD_LAST_CLOSE_TIME, time);
    }

    public static long getAdLastCloseTime(Context context, String packageName) {
        return PushPreferencesUtils.getLongByKey(context, MZ_PUSH_PREFERENCE_NEW, packageName + MZ_PUSH_AD_LAST_CLOSE_TIME);
    }
}

