/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.okio.Base64;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAUtils {
    private static final String TAG = "RSAUtils";
    private static final String RSA_ALGORITHM = "RSA";
    private static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static String decrypt(String publicKeyStr, String encrypted) {
        String decryptStr = null;
        try {
            if (publicKeyStr != null && !TextUtils.isEmpty((CharSequence)encrypted)) {
                byte[] decryptedByte = RSAUtils.base64Decode(encrypted);
                RSAPublicKey publicKey = RSAUtils.loadPublicKey(publicKeyStr);
                decryptStr = new String(RSAUtils.decrypt(publicKey, decryptedByte), UTF8);
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "decrypt " + e.getMessage());
        }
        return decryptStr;
    }

    private static byte[] decrypt(PublicKey publicKey, byte[] encrypted) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, publicKey);
        return cipher.doFinal(encrypted);
    }

    public static byte[] encrypt(PrivateKey privateKey, String message) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, privateKey);
        return cipher.doFinal(message.getBytes(UTF8));
    }

    private static RSAPublicKey loadPublicKey(String publicKeyStr) {
        RSAPublicKey rsaPublicKey = null;
        try {
            byte[] buffer = RSAUtils.base64Decode(publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            rsaPublicKey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            DebugLogger.e(TAG, "loadPublicKey NoSuchAlgorithmException " + e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            DebugLogger.e(TAG, "loadPublicKey InvalidKeySpecException " + e.getMessage());
        }
        return rsaPublicKey;
    }

    public static RSAPrivateKey loadPrivateKey(String privateKeyStr) {
        try {
            byte[] buffer = RSAUtils.base64Decode(privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] base64Decode(String data) {
        return Base64.decode(data);
    }

    public static KeyPair buildKeyPair() throws NoSuchAlgorithmException {
        int keySize = 1024;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA_ALGORITHM);
        keyPairGenerator.initialize(1024);
        return keyPairGenerator.genKeyPair();
    }
}

