/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Handler;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.impl.model.PlatformMessage;
import com.meizu.cloud.pushsdk.notification.MPushMessage;
import com.meizu.cloud.pushsdk.pushtracer.QuickTracker;
import com.meizu.cloud.pushsdk.pushtracer.event.Event;
import com.meizu.cloud.pushsdk.pushtracer.event.PushEvent;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class UxIPUtils {
    private static final String TAG = "UxIPUtils";
    private static final String NOTIFICATION_SERVICE_MESSAGE = "notification_service_message";
    private static final int ON_RECORD_MESSAGE_FLOW_MAP_SIZE = 8;
    private static final int ON_LOG_EVENT_MAP_SIZE = 8;

    public static void init(Context context) {
    }

    public static void notificationEvent(Context context, String pushInfo, int pushInfoType, String taskId, String imei) {
        if (!TextUtils.isEmpty((CharSequence)taskId)) {
            UxIPUtils.onRecordMessageFlow(context, context.getPackageName(), imei, taskId, "4.0.8", pushInfo, pushInfoType);
        }
    }

    public static void notificationEvent(Context context, Intent intent, String pushInfo, int pushInfoType) {
        UxIPUtils.notificationEvent(context, intent, "4.0.8", pushInfo, pushInfoType);
    }

    public static void notificationEvent(Context context, Intent intent, String pushSdkVersion, String pushInfo, int pushInfoType) {
        if (!TextUtils.isEmpty((CharSequence)UxIPUtils.getTaskId(intent))) {
            UxIPUtils.onRecordMessageFlow(context, context.getPackageName(), intent.getStringExtra("statistics_imei_key"), UxIPUtils.getTaskId(intent), pushSdkVersion, pushInfo, pushInfoType);
        }
    }

    public static String getTaskId(Intent intent) {
        String taskId = intent.getStringExtra("extra_app_push_task_Id");
        if (TextUtils.isEmpty((CharSequence)taskId)) {
            try {
                MPushMessage mPushMessage = (MPushMessage)intent.getSerializableExtra("pushMessage");
                if (mPushMessage != null) {
                    taskId = mPushMessage.getTaskId();
                }
            }
            catch (Exception e) {
                taskId = "no push platform task";
                DebugLogger.e(TAG, "parse MessageV2 error " + e.getMessage());
            }
        }
        return taskId;
    }

    public static void onRecordMessageFlow(Context context, String packageName, String deviceId, String taskId, String pushSdkVersion, String pushInfo, int pushInfoType) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(8);
        propertiesMap.put("taskId", taskId);
        propertiesMap.put("deviceId", deviceId);
        propertiesMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        propertiesMap.put("package_name", packageName);
        propertiesMap.put("pushsdk_version", pushSdkVersion);
        propertiesMap.put("push_info", pushInfo);
        propertiesMap.put("push_info_type", String.valueOf(pushInfoType));
        UxIPUtils.onLogEvent(context, false, NOTIFICATION_SERVICE_MESSAGE, propertiesMap);
    }

    public static void onShowPushMessageEvent(Context context, String packageName, String platformExtra) {
        PlatformMessage platformMessage = UxIPUtils.buildPlatformMessage(platformExtra);
        UxIPUtils.onShowPushMessageEvent(context, packageName, platformMessage.getDeviceId(), platformMessage.getTaskId(), platformMessage.getSeqId(), platformMessage.getPushTimesTamp());
    }

    public static PlatformMessage buildPlatformMessage(String platformExtra) {
        PlatformMessage platformMessage = new PlatformMessage();
        if (!TextUtils.isEmpty((CharSequence)platformExtra)) {
            try {
                JSONObject platformExtraJsonObj = new JSONObject(platformExtra);
                String taskId = null;
                String seqId = null;
                String pushTimestamp = null;
                String deviceId = null;
                if (platformExtraJsonObj.has("task_id")) {
                    taskId = platformExtraJsonObj.getString("task_id");
                }
                if (platformExtraJsonObj.has("seq_id")) {
                    seqId = platformExtraJsonObj.getString("seq_id");
                }
                if (platformExtraJsonObj.has("push_timestamp")) {
                    pushTimestamp = platformExtraJsonObj.getString("push_timestamp");
                }
                if (platformExtraJsonObj.has("device_id")) {
                    deviceId = platformExtraJsonObj.getString("device_id");
                }
                platformMessage = PlatformMessage.builder().taskId(taskId).deviceId(deviceId).pushTimesTamp(pushTimestamp).seqId(seqId).build();
            }
            catch (Exception e) {
                DebugLogger.e(TAG, "the platformExtra parse error");
            }
        } else {
            DebugLogger.e(TAG, "the platformExtra is empty");
        }
        return platformMessage;
    }

    public static void onShowPushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "spm", pushTimestamp);
    }

    public static void onShowPushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp, long delayedReportMillis) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "spm", pushTimestamp, delayedReportMillis);
    }

    public static void onDeletePushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "dpm", pushTimestamp);
    }

    public static void onReceivePushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, false, packageName, deviceId, taskId, seqId, "rpe", pushTimestamp);
    }

    public static void onReceivePushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp, long delayedReportMillis) {
        UxIPUtils.onLogEvent(context, false, packageName, deviceId, taskId, seqId, "rpe", pushTimestamp, delayedReportMillis);
    }

    public static void onReceiveThroughMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "rpe", pushTimestamp);
    }

    public static void onClickPushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "cpm", pushTimestamp);
    }

    public static void onInvalidPushMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "ipm", pushTimestamp);
    }

    public static void onShowInBoxPushMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, false, packageName, deviceId, taskId, seqId, "sipm", pushTimestamp);
    }

    public static void onShowInBoxPushMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp, long delayedReportMillis) {
        UxIPUtils.onLogEvent(context, false, packageName, deviceId, taskId, seqId, "sipm", pushTimestamp, delayedReportMillis);
    }

    public static void onNoShowPushMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp, long delayedReportMillis) {
        UxIPUtils.onLogEvent(context, false, packageName, deviceId, taskId, seqId, "npm", pushTimestamp, delayedReportMillis);
    }

    public static void onReceiveServerMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, false, packageName, deviceId, taskId, seqId, "rsm", pushTimestamp);
    }

    public static void onLogEvent(Context context, boolean emitNow, String packageName, String deviceId, String taskId, String seqId, String eventName, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, emitNow, packageName, deviceId, taskId, seqId, eventName, pushTimestamp, 0L);
    }

    public static void onAdAppInstalledMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "aaim", pushTimestamp);
    }

    public static void onAdClickCloseEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "acce", pushTimestamp);
    }

    public static void onAdCannotShowMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "acsm", pushTimestamp);
    }

    public static void onLogEvent(Context context, boolean emitNow, String packageName, String deviceId, String taskId, String seqId, String eventName, String pushTimestamp, long delayedReportMillis) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(8);
        propertiesMap.put("en", eventName);
        propertiesMap.put("ti", taskId);
        propertiesMap.put("di", deviceId);
        propertiesMap.put("ts", TextUtils.isEmpty((CharSequence)pushTimestamp) ? String.valueOf(System.currentTimeMillis() / 1000L) : pushTimestamp);
        propertiesMap.put("pn", packageName);
        propertiesMap.put("pv", "4.0.8");
        propertiesMap.put("nm", String.valueOf(System.currentTimeMillis() / 1000L));
        if (!TextUtils.isEmpty((CharSequence)seqId)) {
            propertiesMap.put("si", seqId);
        }
        if (!UxIPUtils.remotePushTracker(context, propertiesMap, emitNow, delayedReportMillis)) {
            UxIPUtils.onLogEvent(context, emitNow, eventName, propertiesMap);
        }
    }

    public static void onLogEvent(Context context, boolean emitNow, String eventName, Map<String, String> propertiesMap) {
        DebugLogger.e(TAG, "onLogEvent eventName [" + eventName + "] properties = " + propertiesMap);
        if (!NOTIFICATION_SERVICE_MESSAGE.equals(eventName)) {
            String nowTime = propertiesMap.get("nm") != null ? propertiesMap.get("nm") : String.valueOf(System.currentTimeMillis() / 1000L);
            QuickTracker.getAndroidTrackerClassic(context, null, null).track(((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((Event.Builder)((PushEvent.Builder)PushEvent.builder().eventName(eventName)).brand(UxIPUtils.brandType(context))).timestamp(Long.valueOf(propertiesMap.get("ts")))).eventCreateTime(nowTime)).deviceId(propertiesMap.get("di"))).packageName(propertiesMap.get("pn"))).pushsdkVersion(propertiesMap.get("pv"))).taskId(propertiesMap.get("ti"))).seqId(TextUtils.isEmpty((CharSequence)propertiesMap.get("si")) ? "" : propertiesMap.get("si"))).messageSeq(String.valueOf(PushPreferencesUtils.getMessageSeqInCrease(context, propertiesMap.get("pn"))))).build(), emitNow);
        }
    }

    private static boolean remotePushTracker(Context context, Map<String, String> propertiesMap, boolean emitNow, long delayedReportMillis) {
        Intent intent = UxIPUtils.getRemotePushTrackerIntent(context, propertiesMap);
        return UxIPUtils.startRemotePushTracker(context, intent, emitNow, propertiesMap, delayedReportMillis);
    }

    private static Intent getRemotePushTrackerIntent(Context context, Map<String, String> propertiesMap) {
        String componentName = null;
        String managerServicePackageName = null;
        Intent localIntent = new Intent("com.meizu.cloud.pushservice.action.PUSH_TRACKER_SERVICE");
        List localList = context.getPackageManager().queryIntentServices(localIntent, 0);
        if (localList != null) {
            for (ResolveInfo info : localList) {
                if (!"com.meizu.cloud".equals(info.serviceInfo.packageName)) continue;
                managerServicePackageName = info.serviceInfo.packageName;
                componentName = info.serviceInfo.name;
                break;
            }
            if (TextUtils.isEmpty(componentName) && localList.size() > 0) {
                managerServicePackageName = ((ResolveInfo)localList.get((int)0)).serviceInfo.packageName;
                componentName = ((ResolveInfo)localList.get((int)0)).serviceInfo.name;
            }
        }
        DebugLogger.i(TAG, "current process packageName " + managerServicePackageName);
        if (!TextUtils.isEmpty(componentName)) {
            try {
                String trackerData = Util.mapToJsonObject(propertiesMap).toString();
                Intent intent = new Intent();
                intent.setPackage(managerServicePackageName);
                intent.setAction("com.meizu.cloud.pushservice.action.PUSH_TRACKER_SERVICE");
                intent.putExtra("extra_push_tracker", trackerData);
                return intent;
            }
            catch (Exception e) {
                e.printStackTrace();
                DebugLogger.e(TAG, "getRemotePushTrackerIntent error " + e.getMessage());
            }
        }
        return null;
    }

    private static boolean startRemotePushTracker(final Context context, final Intent intent, final boolean emitNow, final Map<String, String> propertiesMap, final long delayedReportMillis) {
        if (intent == null) {
            DebugLogger.e(TAG, "startRemotePushTracker error intent is null");
            return false;
        }
        if (delayedReportMillis == 0L) {
            try {
                context.startService(intent);
                DebugLogger.i(TAG, "immediately start tracker data in mz_tracker process " + intent.getStringExtra("extra_push_tracker"));
            }
            catch (Exception e) {
                e.printStackTrace();
                DebugLogger.e(TAG, "startRemotePushTracker error " + e.getMessage());
                return false;
            }
        } else {
            new Handler(context.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        context.startService(intent);
                        DebugLogger.i(UxIPUtils.TAG, "delayed " + delayedReportMillis + " ms start tracker data in mz_tracker process " + intent.getStringExtra("extra_push_tracker"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        DebugLogger.e(UxIPUtils.TAG, "delayed startRemotePushTracker error " + e.getMessage());
                        UxIPUtils.onLogEvent(context, emitNow, (String)propertiesMap.get("en"), propertiesMap);
                    }
                }
            }, delayedReportMillis);
        }
        return true;
    }

    private static int brandType(Context context) {
        int brand = 0;
        if (MzSystemUtils.isMeizu(context)) {
            brand = 1;
        } else if (MzSystemUtils.isXiaoMi()) {
            brand = 2;
        } else if (MzSystemUtils.isHuaWei()) {
            brand = 3;
        }
        return brand;
    }
}

