/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class AdvertisementOption
implements Parcelable {
    public static final String TAG = "AdvertisementOption";
    public static final String ADVERTISEMENT_OPTION = "ado";
    public static final String AD_PACKAGE = "ap";
    public static final String PRIORITY_VALID_TIME = "pt";
    public static final String AD_INSTALL_PACKAGE = "aip";
    public static final Parcelable.Creator<AdvertisementOption> CREATOR = new Parcelable.Creator<AdvertisementOption>(){

        public AdvertisementOption a(Parcel parcel) {
            return new AdvertisementOption(parcel);
        }

        public AdvertisementOption[] a(int n2) {
            return new AdvertisementOption[n2];
        }
    };
    private String mAdPackage;
    private int mPriorityValidTime;
    private String mAdInstallPackage;

    public AdvertisementOption() {
    }

    protected AdvertisementOption(Parcel parcel) {
        this.mAdPackage = parcel.readString();
        this.mPriorityValidTime = parcel.readInt();
        this.mAdInstallPackage = parcel.readString();
    }

    public static AdvertisementOption parse(String string2) {
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            JSONObject jSONObject2;
            JSONObject jSONObject3 = jSONObject2;
            try {
                jSONObject2 = new JSONObject(string2);
                jSONObject = jSONObject3;
            }
            catch (JSONException jSONException) {
                DebugLogger.e(TAG, "parse json string error " + jSONException.getMessage());
            }
        }
        return AdvertisementOption.parse(jSONObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AdvertisementOption parse(JSONObject jSONObject) {
        AdvertisementOption advertisementOption;
        AdvertisementOption advertisementOption2 = advertisementOption;
        advertisementOption = new AdvertisementOption();
        if (jSONObject == null) {
            DebugLogger.e(TAG, "no such tag AdvertisementOption");
            return advertisementOption2;
        }
        try {
            if (!jSONObject.isNull(AD_PACKAGE)) {
                advertisementOption2.setAdPackage(jSONObject.getString(AD_PACKAGE));
            }
            if (!jSONObject.isNull(PRIORITY_VALID_TIME)) {
                advertisementOption2.setPriorityValidTime(jSONObject.getInt(PRIORITY_VALID_TIME));
            }
            if (jSONObject.isNull(AD_INSTALL_PACKAGE)) return advertisementOption2;
            advertisementOption2.setAdInstallPackage(jSONObject.getString(AD_INSTALL_PACKAGE));
            return advertisementOption2;
        }
        catch (JSONException jSONException) {
            DebugLogger.e(TAG, "parse json obj error " + jSONException.getMessage());
            return advertisementOption2;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.mAdPackage);
        parcel.writeInt(this.mPriorityValidTime);
        parcel.writeString(this.mAdInstallPackage);
    }

    public String getAdPackage() {
        return this.mAdPackage;
    }

    public void setAdPackage(String string2) {
        this.mAdPackage = string2;
    }

    public int getPriorityValidTime() {
        return this.mPriorityValidTime;
    }

    public void setPriorityValidTime(int n2) {
        this.mPriorityValidTime = n2;
    }

    public String getAdInstallPackage() {
        return this.mAdInstallPackage;
    }

    public void setAdInstallPackage(String string2) {
        this.mAdInstallPackage = string2;
    }

    public String toString() {
        return "AdvertisementOption{mAdPackage=" + this.mAdPackage + "mPriorityValidTime=" + this.mPriorityValidTime + "mAdInstallPackage=" + this.mAdInstallPackage + '}';
    }
}

