/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.push.sdk.server.constant;

import java.util.Collection;
import java.util.HashMap;

public class ErrorCode {
    private int value;
    private String description;
    private static HashMap<Integer, ErrorCode> intErrorCodeMap = ErrorCode.createIntegerErrorCodeMapping();
    public static ErrorCode UNKNOWN_ERROR = ErrorCode.valueOf((Integer)-1, "\u672a\u77e5\u9519\u8bef");
    public static ErrorCode SUCCESS = ErrorCode.valueOf((Integer)200, "\u6210\u529f");
    public static ErrorCode SYSTEM_ERROR = ErrorCode.valueOf((Integer)1001, "\u7cfb\u7edf\u9519\u8bef");
    public static ErrorCode SYSTEM_BUSY = ErrorCode.valueOf((Integer)1003, "\u670d\u52a1\u5668\u5fd9");
    public static ErrorCode PARAMETER_ERROR = ErrorCode.valueOf((Integer)1005, "\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u53c2\u8003API\u6587\u6863");
    public static ErrorCode INVALID_SIGN = ErrorCode.valueOf((Integer)1006, "\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25");
    public static ErrorCode INVALID_APPLICATION_ID = ErrorCode.valueOf((Integer)110000, "appId\u4e0d\u5408\u6cd5");
    public static ErrorCode INVALID_APPLICATION_KEY = ErrorCode.valueOf((Integer)110001, "appKey\u4e0d\u5408\u6cd5");
    public static ErrorCode UNSUBSCRIBE_PUSHID = ErrorCode.valueOf((Integer)110002, "pushId\u672a\u6ce8\u518c");
    public static ErrorCode INVALID_PUSHID = ErrorCode.valueOf((Integer)110003, "pushId\u975e\u6cd5");
    public static ErrorCode PARAM_BLANK = ErrorCode.valueOf((Integer)110004, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    public static ErrorCode APP_IN_BLACK_LIST = ErrorCode.valueOf((Integer)110009, "\u5e94\u7528\u88ab\u52a0\u5165\u9ed1\u540d\u5355");
    public static ErrorCode APP_REQUEST_EXCEED_LIMIT = ErrorCode.valueOf((Integer)110010, "\u5e94\u7528\u8bf7\u6c42\u9891\u7387\u8fc7\u5feb");
    public static ErrorCode APP_REQUEST_PUSH_LIMIT = ErrorCode.valueOf((Integer)110019, "\u8d85\u8fc7\u8be5\u5e94\u7528\u6bcf\u5929\u63a8\u9001\u6b21\u6570\u9650\u5236");
    public static ErrorCode INVALID_APPLICATION_PACKAGENAME = ErrorCode.valueOf((Integer)110031, "packageName\u4e0d\u5408\u6cd5");
    public static ErrorCode INVALID_TASK_ID = ErrorCode.valueOf((Integer)110032, "\u975e\u6cd5\u7684taskId");
    public static ErrorCode INVALID_APPLICATION_SECRET = ErrorCode.valueOf((Integer)110033, "\u975e\u6cd5\u7684appSecret");

    private static HashMap<Integer, ErrorCode> createIntegerErrorCodeMapping() {
        HashMap<Integer, ErrorCode> result = new HashMap<Integer, ErrorCode>();
        return result;
    }

    public static Collection<ErrorCode> getAllErrorCodes() {
        return intErrorCodeMap.values();
    }

    private ErrorCode(int value) {
        this.value = value;
    }

    private ErrorCode(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public String toString() {
        return "ErrorCode{value=" + this.value + ", description='" + this.description + '\'' + '}';
    }

    public String getFullDescription() {
        return this.getName() + "," + this.value + "," + this.description;
    }

    public String getName() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static ErrorCode valueOf(int value) {
        return intErrorCodeMap.get(value);
    }

    public static ErrorCode valueOf(int value, ErrorCode defaultIfMissing) {
        ErrorCode code = intErrorCodeMap.get(value);
        return code == null ? defaultIfMissing : code;
    }

    public static ErrorCode valueOf(Integer code, String reason) {
        ErrorCode result = intErrorCodeMap.get(code);
        if (result == null) {
            result = new ErrorCode(code, reason);
            intErrorCodeMap.put(code, result);
        }
        return result;
    }
}

